/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.test.utils;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.quarkus.security.test.utils.AuthData;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Inject;
import java.security.Permission;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Alternative
@ApplicationScoped
@Priority(value=1)
public class IdentityMock
implements SecurityIdentity {
    public static final AuthData ANONYMOUS = new AuthData(null, true, null);
    public static final AuthData USER = new AuthData(Collections.singleton("user"), false, "user", Set.of());
    public static final AuthData ADMIN = new AuthData(Collections.singleton("admin"), false, "admin", Set.of());
    private static volatile boolean anonymous;
    private static volatile Set<String> roles;
    private static volatile Set<Permission> permissions;
    private static volatile String name;

    public static void setUpAuth(AuthData auth) {
        anonymous = auth.anonymous;
        roles = auth.roles;
        name = auth.name;
        permissions = auth.permissions == null ? Set.of() : auth.permissions;
    }

    public Principal getPrincipal() {
        return new Principal(){

            @Override
            public String getName() {
                return name;
            }
        };
    }

    public boolean hasRole(String role) {
        if (roles == null) {
            return false;
        }
        return this.getRoles().contains(role);
    }

    public boolean isAnonymous() {
        return anonymous;
    }

    public Set<String> getRoles() {
        return roles;
    }

    public <T extends Credential> T getCredential(Class<T> aClass) {
        return null;
    }

    public Set<Credential> getCredentials() {
        return null;
    }

    public <T> T getAttribute(String s) {
        return null;
    }

    public Map<String, Object> getAttributes() {
        return null;
    }

    public Uni<Boolean> checkPermission(Permission permission) {
        boolean permitted = permission != null && permissions.stream().anyMatch(p -> p.implies(permission));
        return Uni.createFrom().item((Object)permitted);
    }

    static {
        permissions = new HashSet<Permission>();
    }

    @Alternative
    @ApplicationScoped
    @Priority(value=1)
    public static class IdentityAssociationMock
    extends SecurityIdentityAssociation {
        @Inject
        IdentityMock identity;

        public Uni<SecurityIdentity> getDeferredIdentity() {
            return Uni.createFrom().item((Object)this.identity);
        }

        public SecurityIdentity getIdentity() {
            return this.identity;
        }
    }
}

