/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

abstract class DelegateInvoker
implements ScheduledInvoker {
    protected final ScheduledInvoker delegate;

    public DelegateInvoker(ScheduledInvoker delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isBlocking() {
        return this.delegate.isBlocking();
    }

    @Override
    public boolean isRunningOnVirtualThread() {
        return this.delegate.isRunningOnVirtualThread();
    }

    protected CompletionStage<Void> invokeDelegate(ScheduledExecution execution) {
        try {
            return this.delegate.invoke(execution);
        }
        catch (Throwable e) {
            return CompletableFuture.failedStage(e);
        }
    }

    protected void invokeComplete(final CompletableFuture<Void> ret, ScheduledExecution execution) {
        this.invokeDelegate(execution).whenComplete(new BiConsumer<Void, Throwable>(){

            @Override
            public void accept(Void r, Throwable t) {
                if (t != null) {
                    ret.completeExceptionally(t);
                } else {
                    ret.complete(null);
                }
            }
        });
    }
}

