/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler;

import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.Trigger;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Scheduler {
    public boolean isStarted();

    public void pause();

    public void pause(String var1);

    public void resume();

    public void resume(String var1);

    public boolean isPaused(String var1);

    public boolean isRunning();

    public List<Trigger> getScheduledJobs();

    public Trigger getScheduledJob(String var1);

    public JobDefinition<?> newJob(String var1);

    public Trigger unscheduleJob(String var1);

    public String implementation();

    public static interface JobDefinition<THIS extends JobDefinition<THIS>> {
        public THIS setCron(String var1);

        public THIS setInterval(String var1);

        public THIS setDelayed(String var1);

        public THIS setConcurrentExecution(Scheduled.ConcurrentExecution var1);

        public THIS setSkipPredicate(Scheduled.SkipPredicate var1);

        public THIS setSkipPredicate(Class<? extends Scheduled.SkipPredicate> var1);

        public THIS setOverdueGracePeriod(String var1);

        public THIS setTimeZone(String var1);

        public THIS setExecuteWith(String var1);

        public THIS setExecutionMaxDelay(String var1);

        default public THIS setTask(Consumer<ScheduledExecution> task) {
            return this.setTask(task, false);
        }

        default public THIS setTask(Class<? extends Consumer<ScheduledExecution>> taskClass) {
            return this.setTask(taskClass, false);
        }

        public THIS setTask(Consumer<ScheduledExecution> var1, boolean var2);

        public THIS setTask(Class<? extends Consumer<ScheduledExecution>> var1, boolean var2);

        public THIS setAsyncTask(Function<ScheduledExecution, Uni<Void>> var1);

        public THIS setAsyncTask(Class<? extends Function<ScheduledExecution, Uni<Void>>> var1);

        public Trigger schedule();
    }
}

