/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.common.providers.serialisers.AbstractJsonMessageBodyReader;
import org.jboss.resteasy.reactive.common.util.EmptyInputStream;

public class JacksonBasicMessageBodyReader
extends AbstractJsonMessageBodyReader {
    protected final ObjectReader reader;

    @Inject
    public JacksonBasicMessageBodyReader(ObjectMapper mapper) {
        this.reader = mapper.reader();
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return this.doReadFrom(type, genericType, entityStream);
        }
        catch (MismatchedInputException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    private Object doReadFrom(Class<Object> type, Type genericType, InputStream entityStream) throws IOException {
        if (entityStream instanceof EmptyInputStream) {
            return null;
        }
        return this.reader.forType(this.reader.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
    }
}

