/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.resteasy.reactive.jackson.CustomSerialization;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.reactive.common.providers.serialisers.JsonMessageBodyWriterUtil;

public class JacksonBasicMessageBodyWriter
implements MessageBodyWriter<Object> {
    private static final String JSON_VIEW_NAME = JsonView.class.getName();
    private static final String CUSTOM_SERIALIZATION = CustomSerialization.class.getName();
    protected final ObjectMapper originalMapper;
    protected final ObjectWriter defaultWriter;
    protected final ConcurrentMap<Method, ObjectWriter> perMethodWriter = new ConcurrentHashMap<Method, ObjectWriter>();

    @Inject
    public JacksonBasicMessageBodyWriter(ObjectMapper mapper) {
        this.originalMapper = mapper;
        JsonFactory jsonFactory = mapper.getFactory();
        if (this.needsNewFactory(jsonFactory)) {
            jsonFactory = jsonFactory.copy();
            JacksonBasicMessageBodyWriter.setNecessaryJsonFactoryConfig(jsonFactory);
            this.defaultWriter = mapper.writer().with(jsonFactory);
        } else {
            this.defaultWriter = mapper.writer();
        }
    }

    private boolean needsNewFactory(JsonFactory jsonFactory) {
        return jsonFactory.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET) || jsonFactory.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
    }

    protected static void setNecessaryJsonFactoryConfig(JsonFactory jsonFactory) {
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        jsonFactory.configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, false);
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonMessageBodyWriterUtil.setContentTypeIfNecessary(httpHeaders);
        if (o instanceof String) {
            entityStream.write(((String)o).getBytes());
        } else {
            if (annotations != null) {
                for (Annotation annotation : annotations) {
                    if (!JsonView.class.equals(annotation.annotationType()) || !this.handleJsonView((JsonView)annotation, o, entityStream)) continue;
                    return;
                }
            }
            entityStream.write(this.defaultWriter.writeValueAsBytes(o));
        }
    }

    private boolean handleJsonView(JsonView jsonView, Object o, OutputStream stream) throws IOException {
        if (jsonView != null && jsonView.value().length > 0) {
            this.defaultWriter.withView(jsonView.value()[0]).writeValue(stream, o);
            return true;
        }
        return false;
    }
}

