/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ConsoleCommandBuildItem;
import io.quarkus.deployment.console.QuarkusCommand;
import io.quarkus.resteasy.reactive.server.deployment.SetupEndpointsResultBuildItem;
import io.quarkus.resteasy.reactive.server.runtime.ExceptionMapperRecorder;
import io.quarkus.resteasy.reactive.server.runtime.NotFoundExceptionMapper;
import io.quarkus.resteasy.reactive.spi.CustomExceptionMapperBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.devmode.RouteDescriptionBuildItem;
import io.quarkus.vertx.http.deployment.devmode.console.DevConsoleProcessor;
import io.quarkus.vertx.http.runtime.devmode.AdditionalRouteDescription;
import io.quarkus.vertx.http.runtime.devmode.RouteDescription;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Argument;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;

public class ResteasyReactiveDevModeProcessor {
    private static final String META_INF_RESOURCES = "META-INF/resources";
    private static final Set<String> knownPaths = Collections.synchronizedSet(new HashSet());

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void setupExceptionMapper(BuildProducer<CustomExceptionMapperBuildItem> customExceptionMappers, HttpRootPathBuildItem httpRoot, ExceptionMapperRecorder recorder) {
        customExceptionMappers.produce((BuildItem)new CustomExceptionMapperBuildItem(NotFoundExceptionMapper.class.getName()));
        recorder.setHttpRoot(httpRoot.getRootPath());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void addStaticResourcesExceptionMapper(ApplicationArchivesBuildItem applicationArchivesBuildItem, ExceptionMapperRecorder recorder) {
        recorder.setStaticResourceRoots(applicationArchivesBuildItem.getAllApplicationArchives().stream().map(i -> (String)i.apply(t -> {
            Path p = t.getPath(META_INF_RESOURCES);
            return p == null ? null : p.toAbsolutePath().toString();
        })).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void addReactiveRoutesExceptionMapper(List<RouteDescriptionBuildItem> routeDescriptions, ExceptionMapperRecorder recorder) {
        ArrayList<RouteDescription> reactiveRoutes = new ArrayList<RouteDescription>();
        for (RouteDescriptionBuildItem description : routeDescriptions) {
            reactiveRoutes.add(description.getDescription());
        }
        recorder.setReactiveRoutes(reactiveRoutes);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void addAdditionalEndpointsExceptionMapper(List<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, ExceptionMapperRecorder recorder, HttpRootPathBuildItem httpRoot) {
        List endpoints = displayableEndpoints.stream().map(v -> new AdditionalRouteDescription(v.getEndpoint(httpRoot), v.getDescription())).sorted().collect(Collectors.toList());
        recorder.setAdditionalEndpoints(endpoints);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    ConsoleCommandBuildItem openCommand(HttpRootPathBuildItem rp, NonApplicationRootPathBuildItem np, SetupEndpointsResultBuildItem setupEndpointsResultBuildItem) {
        knownPaths.clear();
        for (ResourceClass clazz : setupEndpointsResultBuildItem.getResourceClasses()) {
            Object cp = clazz.getPath();
            if (!((String)cp).startsWith("/")) {
                cp = "/" + (String)cp;
            }
            for (ResourceMethod method : clazz.getMethods()) {
                if (!method.getHttpMethod().equals("GET")) continue;
                if (method.getPath() == null || method.getPath().equals("") || method.getPath().equals("/")) {
                    knownPaths.add((String)cp);
                    continue;
                }
                if (((String)cp).endsWith("/")) {
                    if (method.getPath().startsWith("/")) {
                        knownPaths.add((String)cp + method.getPath().substring(1));
                        continue;
                    }
                    knownPaths.add((String)cp + method.getPath());
                    continue;
                }
                if (method.getPath().startsWith("/")) {
                    knownPaths.add((String)cp + method.getPath());
                    continue;
                }
                knownPaths.add((String)cp + "/" + method.getPath());
            }
        }
        Config c = ConfigProvider.getConfig();
        String host = c.getOptionalValue("quarkus.http.host", String.class).orElse("localhost");
        String port = c.getOptionalValue("quarkus.http.port", String.class).orElse("8080");
        return new ConsoleCommandBuildItem((Command)new OpenCommand(rp, np, host, port));
    }

    public static class CompletionResult {
        final boolean appendSpace;
        final Set<String> results;

        public CompletionResult(boolean appendSpace, Set<String> results) {
            this.appendSpace = appendSpace;
            this.results = results;
        }

        public boolean isAppendSpace() {
            return this.appendSpace;
        }

        public Set<String> getResults() {
            return this.results;
        }
    }

    public static class PathCompleter
    implements OptionCompleter {
        public void complete(CompleterInvocation completerInvocation) {
            CompletionResult result = PathCompleter.complete(knownPaths, completerInvocation.getGivenCompleteValue());
            completerInvocation.setAppendSpace(result.appendSpace);
            completerInvocation.setCompleterValues(result.results);
        }

        public static CompletionResult complete(Set<String> knownPaths, String soFar) {
            boolean appendSpace = true;
            HashSet<String> getRoutes = new HashSet<String>(knownPaths);
            Object url = soFar;
            if (!((String)url).startsWith("/")) {
                url = "/" + (String)url;
            }
            HashSet<String> toAdd = new HashSet<String>();
            block0: for (String route : getRoutes) {
                URITemplate template = new URITemplate(route, false);
                URITemplate.TemplateComponent[] components = template.components;
                int urlPos = 0;
                boolean done = false;
                for (int i = 0; i < components.length; ++i) {
                    URITemplate.TemplateComponent component = components[i];
                    if (component.type == URITemplate.Type.LITERAL) {
                        int componentPos = 0;
                        while (componentPos < component.literalText.length() && urlPos < ((String)url).length()) {
                            if (((String)url).charAt(urlPos++) == component.literalText.charAt(componentPos++)) continue;
                            done = true;
                            break;
                        }
                        if (urlPos == ((String)url).length() && componentPos != component.literalText.length()) {
                            StringBuilder sb = new StringBuilder();
                            sb.append((String)url);
                            sb.append(component.literalText.substring(componentPos));
                            if (i != components.length - 1) {
                                sb.append(components[i + 1].stringRepresentation());
                                appendSpace = false;
                            }
                            toAdd.add(sb.toString());
                            done = true;
                        }
                    } else {
                        boolean found = false;
                        int startingUrlPos = urlPos;
                        while (urlPos < ((String)url).length()) {
                            if (((String)url).charAt(urlPos) == '/') {
                                found = true;
                                break;
                            }
                            ++urlPos;
                        }
                        if (!found) {
                            toAdd.add(((String)url).substring(0, startingUrlPos) + "{" + component.name + "}");
                            appendSpace = false;
                            done = true;
                        }
                    }
                    if (done) continue block0;
                }
            }
            return new CompletionResult(appendSpace, toAdd);
        }
    }

    @CommandDefinition(name="open", description="Opens a path in a web browser")
    public static class OpenCommand
    extends QuarkusCommand {
        @Argument(required=true, completer=PathCompleter.class)
        private String url;
        final HttpRootPathBuildItem rp;
        final NonApplicationRootPathBuildItem np;
        final String host;
        final String port;

        public OpenCommand(HttpRootPathBuildItem rp, NonApplicationRootPathBuildItem np, String host, String port) {
            this.rp = rp;
            this.np = np;
            this.host = host;
            this.port = port;
        }

        public CommandResult doExecute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            DevConsoleProcessor.openBrowser((HttpRootPathBuildItem)this.rp, (NonApplicationRootPathBuildItem)this.np, (String)(this.url.startsWith("/") ? this.url : "/" + this.url), (String)this.host, (String)this.port);
            return CommandResult.SUCCESS;
        }
    }
}

