/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.resteasy.reactive.server.deployment.DotNames;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.MultipartPopulatorGenerator;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.MultipartTransformer;

public class QuarkusMultipartParamHandler
implements EndpointIndexer.MultipartParameterIndexerExtension {
    private final Map<String, String> multipartInputGeneratedPopulators = new HashMap<String, String>();
    final BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
    final Predicate<String> applicationClassPredicate;
    final BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer;
    final BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildProducer;

    public QuarkusMultipartParamHandler(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, Predicate<String> applicationClassPredicate, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildProducer) {
        this.generatedClassBuildItemBuildProducer = generatedClassBuildItemBuildProducer;
        this.applicationClassPredicate = applicationClassPredicate;
        this.reflectiveClassProducer = reflectiveClassProducer;
        this.bytecodeTransformerBuildProducer = bytecodeTransformerBuildProducer;
    }

    public void handleMultipartParameter(ClassInfo multipartClassInfo, IndexView index) {
        String className = multipartClassInfo.name().toString();
        if (this.multipartInputGeneratedPopulators.containsKey(className)) {
            return;
        }
        this.reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{className}));
        String populatorClassName = MultipartPopulatorGenerator.generate((ClassInfo)multipartClassInfo, (ClassOutput)new GeneratedClassGizmoAdaptor(this.generatedClassBuildItemBuildProducer, this.applicationClassPredicate.test(className)), (IndexView)index);
        this.multipartInputGeneratedPopulators.put(className, populatorClassName);
        ClassInfo currentClassInHierarchy = multipartClassInfo;
        while (true) {
            ClassInfo newCurrentClassInHierarchy;
            this.bytecodeTransformerBuildProducer.produce((BuildItem)new BytecodeTransformerBuildItem(currentClassInHierarchy.name().toString(), (BiFunction)new MultipartTransformer(populatorClassName)));
            DotName superClassDotName = currentClassInHierarchy.superName();
            if (superClassDotName.equals((Object)DotNames.OBJECT_NAME) || (newCurrentClassInHierarchy = index.getClassByName(superClassDotName)) == null) break;
            currentClassInHierarchy = newCurrentClassInHierarchy;
        }
    }
}

