/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.runtime.AuthenticationCompletionExceptionMapper;
import io.quarkus.resteasy.runtime.AuthenticationFailedExceptionMapper;
import io.quarkus.resteasy.runtime.AuthenticationRedirectExceptionMapper;
import io.quarkus.resteasy.runtime.CompositeExceptionMapper;
import io.quarkus.resteasy.runtime.EagerSecurityFilter;
import io.quarkus.resteasy.runtime.ForbiddenExceptionMapper;
import io.quarkus.resteasy.runtime.JaxRsPermissionChecker;
import io.quarkus.resteasy.runtime.JaxRsSecurityConfig;
import io.quarkus.resteasy.runtime.SecurityContextFilter;
import io.quarkus.resteasy.runtime.StandardSecurityCheckInterceptor;
import io.quarkus.resteasy.runtime.UnauthorizedExceptionMapper;
import io.quarkus.resteasy.runtime.vertx.JsonArrayReader;
import io.quarkus.resteasy.runtime.vertx.JsonArrayWriter;
import io.quarkus.resteasy.runtime.vertx.JsonObjectReader;
import io.quarkus.resteasy.runtime.vertx.JsonObjectWriter;
import io.quarkus.security.spi.DefaultSecurityCheckBuildItem;
import java.util.List;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.spi.ResourceFactory;

public class ResteasyBuiltinsProcessor {
    protected static final String META_INF_RESOURCES = "META-INF/resources";

    @BuildStep
    void setUpDenyAllJaxRs(JaxRsSecurityConfig securityConfig, BuildProducer<DefaultSecurityCheckBuildItem> defaultSecurityCheckProducer) {
        if (securityConfig.denyJaxRs) {
            defaultSecurityCheckProducer.produce((BuildItem)DefaultSecurityCheckBuildItem.denyAll());
        } else if (securityConfig.defaultRolesAllowed.isPresent()) {
            defaultSecurityCheckProducer.produce((BuildItem)DefaultSecurityCheckBuildItem.rolesAllowed((List)((List)securityConfig.defaultRolesAllowed.get())));
        }
    }

    @BuildStep
    void setUpSecurity(BuildProducer<ResteasyJaxrsProviderBuildItem> providers, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItem, Capabilities capabilities) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(UnauthorizedExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(ForbiddenExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AuthenticationFailedExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AuthenticationRedirectExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AuthenticationCompletionExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(CompositeExceptionMapper.class.getName()));
        if (capabilities.isPresent("io.quarkus.security")) {
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(SecurityContextFilter.class.getName()));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityContextFilter.class));
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(EagerSecurityFilter.class.getName()));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(EagerSecurityFilter.class));
            ResteasyBuiltinsProcessor.transformEagerSecurityNativeMethod(bytecodeTransformerProducer);
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(JaxRsPermissionChecker.class));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(StandardSecurityCheckInterceptor.RolesAllowedInterceptor.class));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(StandardSecurityCheckInterceptor.PermissionsAllowedInterceptor.class));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(StandardSecurityCheckInterceptor.PermitAllInterceptor.class));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(StandardSecurityCheckInterceptor.AuthenticatedInterceptor.class));
        }
    }

    @BuildStep
    void vertxProviders(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonArrayReader.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonArrayWriter.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonObjectReader.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonObjectWriter.class.getName()));
    }

    private static void transformEagerSecurityNativeMethod(BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerProducer) {
        bytecodeTransformerProducer.produce((BuildItem)new BytecodeTransformerBuildItem(ResourceMethodInvoker.class.getName(), (cls, classVisitor) -> {
            ClassTransformer classTransformer = new ClassTransformer(cls);
            try (MethodCreator getResourceFactory = classTransformer.addMethod("getResourceFactory", ResourceFactory.class, new Object[0]);){
                getResourceFactory.setModifiers(1);
                FieldDescriptor resourceFieldDesc = FieldDescriptor.of(ResourceMethodInvoker.class, (String)"resource", ResourceFactory.class);
                ResultHandle resourceField = getResourceFactory.readInstanceField(resourceFieldDesc, getResourceFactory.getThis());
                getResourceFactory.returnValue(resourceField);
            }
            return classTransformer.applyTo(classVisitor);
        }));
        bytecodeTransformerProducer.produce((BuildItem)new BytecodeTransformerBuildItem(EagerSecurityFilter.class.getName(), (cls, classVisitor) -> {
            ClassTransformer classTransformer = new ClassTransformer(cls);
            MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod(EagerSecurityFilter.class, (String)"getResourceFactory", ResourceFactory.class, (Class[])new Class[]{ResourceMethodInvoker.class});
            classTransformer.removeMethod(methodDescriptor);
            try (MethodCreator methodCreator = classTransformer.addMethod(methodDescriptor);){
                methodCreator.setModifiers(8);
                ResultHandle invoker = methodCreator.getMethodParam(0);
                MethodDescriptor getResourceFactoryDescriptor = MethodDescriptor.ofMethod(ResourceMethodInvoker.class, (String)"getResourceFactory", ResourceFactory.class, (Class[])new Class[0]);
                ResultHandle resource = methodCreator.invokeVirtualMethod(getResourceFactoryDescriptor, invoker, new ResultHandle[0]);
                methodCreator.returnValue(resource);
            }
            return classTransformer.applyTo(classVisitor);
        }));
    }
}

