/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.properties;

import io.quarkus.rest.data.panache.deployment.properties.MethodProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;

public class ResourceProperties {
    private final boolean exposed;
    private final String path;
    private final boolean paged;
    private final boolean hal;
    private final String halCollectionName;
    private final String[] rolesAllowed;
    private final boolean isAuthenticated;
    private final Collection<AnnotationInstance> classAnnotations;
    private final Map<String, MethodProperties> methodProperties;

    public ResourceProperties(boolean exposed, String path, boolean paged, boolean hal, String halCollectionName, String[] rolesAllowed, boolean isAuthenticated, Collection<AnnotationInstance> classAnnotations, Map<String, MethodProperties> methodProperties) {
        this.exposed = exposed;
        this.path = path;
        this.paged = paged;
        this.hal = hal;
        this.halCollectionName = halCollectionName;
        this.rolesAllowed = rolesAllowed;
        this.isAuthenticated = isAuthenticated;
        this.classAnnotations = classAnnotations;
        this.methodProperties = methodProperties;
    }

    public boolean isExposed() {
        if (this.exposed) {
            return true;
        }
        for (MethodProperties properties : this.methodProperties.values()) {
            if (!properties.isExposed()) continue;
            return true;
        }
        return false;
    }

    public boolean isExposed(String methodName) {
        if (this.methodProperties.containsKey(methodName)) {
            return this.methodProperties.get(methodName).isExposed();
        }
        return this.exposed;
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(String methodName) {
        if (this.methodProperties.containsKey(methodName)) {
            return this.methodProperties.get(methodName).getPath();
        }
        return "";
    }

    public boolean isPaged() {
        return this.paged;
    }

    public boolean isHal() {
        return this.hal;
    }

    public String getHalCollectionName() {
        return this.halCollectionName;
    }

    public String[] getRolesAllowed(String methodName) {
        if (this.methodProperties.containsKey(methodName)) {
            return this.methodProperties.get(methodName).getRolesAllowed();
        }
        return this.rolesAllowed;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public Collection<AnnotationInstance> getClassAnnotations() {
        return this.classAnnotations;
    }

    public Collection<AnnotationInstance> getMethodAnnotations(String methodName) {
        if (this.methodProperties.containsKey(methodName)) {
            return this.methodProperties.get(methodName).getMethodAnnotations();
        }
        return Collections.emptyList();
    }
}

