/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.utils;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.SignatureBuilder;
import io.quarkus.gizmo.Type;
import io.quarkus.rest.data.panache.deployment.utils.TypeUtils;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import org.jboss.resteasy.reactive.RestResponse;

public final class SignatureMethodCreator {
    private static final Type RESPONSE_TYPE = Type.classType(Response.class);

    public static MethodCreator getMethodCreator(String methodName, ClassCreator classCreator, ReturnType returnType, Parameter ... parameters) {
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<Object> paramClasses = new ArrayList<Object>();
        for (Parameter param : parameters) {
            paramNames.add(param.name);
            paramTypes.add(param.type);
            paramClasses.add(param.clazz);
        }
        MethodCreator methodCreator = classCreator.getMethodCreator(methodName, returnType.classType, paramClasses.toArray(new Object[0]));
        SignatureBuilder.MethodSignatureBuilder signatureBuilder = SignatureBuilder.forMethod().setReturnType(returnType.type);
        paramTypes.forEach(arg_0 -> ((SignatureBuilder.MethodSignatureBuilder)signatureBuilder).addParameterType(arg_0));
        methodCreator.setSignature(signatureBuilder.build());
        methodCreator.setParameterNames(paramNames.toArray(new String[0]));
        return methodCreator;
    }

    public static Parameter param(String name, Object type) {
        return SignatureMethodCreator.param(name, type, TypeUtils.toGizmoType(type));
    }

    public static Parameter param(String name, Object clazz, Type type) {
        Parameter parameter = new Parameter();
        parameter.name = name;
        parameter.clazz = clazz;
        parameter.type = type;
        return parameter;
    }

    public static ReturnType responseType(Object entityTypeStr) {
        return SignatureMethodCreator.getReturnType(RestResponse.class, entityTypeStr);
    }

    public static ReturnType uniType(Object entityTypeStr) {
        return SignatureMethodCreator.getReturnType(Uni.class, entityTypeStr);
    }

    private static ReturnType getReturnType(Class<?> entityType, Object ... arguments) {
        ReturnType returnType = new ReturnType();
        Type[] typeArguments = new Type[arguments.length];
        for (int index = 0; index < arguments.length; ++index) {
            typeArguments[index] = TypeUtils.toGizmoType(arguments[index]);
        }
        returnType.classType = entityType;
        returnType.type = Type.parameterizedType((Type.ClassType)Type.classType(entityType), (Type[])typeArguments);
        return returnType;
    }

    public static class Parameter {
        private String name;
        private Type type;
        private Object clazz;

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public Object getClazz() {
            return this.clazz;
        }
    }

    public static class ReturnType {
        private Class<?> classType;
        private Type type;
    }
}

