/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.AnnotationCreator;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.rest.data.panache.RestDataPanacheException;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.MethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import io.quarkus.rest.data.panache.runtime.sort.SortQueryParamValidator;
import io.quarkus.resteasy.reactive.links.RestLink;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.RestResponse;

public abstract class StandardMethodImplementor
implements MethodImplementor {
    private static final String OPENAPI_PACKAGE = "org.eclipse.microprofile.openapi.annotations";
    private static final String OPENAPI_RESPONSE_ANNOTATION = "org.eclipse.microprofile.openapi.annotations.responses.APIResponse";
    private static final String OPENAPI_CONTENT_ANNOTATION = "org.eclipse.microprofile.openapi.annotations.media.Content";
    private static final String OPENAPI_SCHEMA_ANNOTATION = "org.eclipse.microprofile.openapi.annotations.media.Schema";
    private static final String SCHEMA_TYPE_CLASS_NAME = "org.eclipse.microprofile.openapi.annotations.enums.SchemaType";
    private static final String SCHEMA_TYPE_ARRAY = "ARRAY";
    private static final String ROLES_ALLOWED_ANNOTATION = "jakarta.annotation.security.RolesAllowed";
    private static final Logger LOGGER = Logger.getLogger(StandardMethodImplementor.class);
    protected final ResponseImplementor responseImplementor;
    private final Capabilities capabilities;

    protected StandardMethodImplementor(Capabilities capabilities) {
        this.capabilities = capabilities;
        this.responseImplementor = new ResponseImplementor();
    }

    @Override
    public void implement(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        if (resourceProperties.isExposed(this.getResourceMethodName())) {
            this.implementInternal(classCreator, resourceMetadata, resourceProperties, resourceField);
        }
    }

    protected abstract void implementInternal(ClassCreator var1, ResourceMetadata var2, ResourceProperties var3, FieldDescriptor var4);

    protected abstract String getResourceMethodName();

    protected TryBlock implementTryBlock(BytecodeCreator bytecodeCreator, String message) {
        TryBlock tryBlock = bytecodeCreator.tryBlock();
        CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
        catchBlock.throwException(RestDataPanacheException.class, message, catchBlock.getCaughtException());
        catchBlock.close();
        return tryBlock;
    }

    protected void addGetAnnotation(AnnotatedElement element) {
        element.addAnnotation(GET.class);
    }

    protected void addPostAnnotation(AnnotatedElement element) {
        element.addAnnotation(POST.class);
    }

    protected void addPutAnnotation(AnnotatedElement element) {
        element.addAnnotation(PUT.class);
    }

    protected void addDeleteAnnotation(AnnotatedElement element) {
        element.addAnnotation(DELETE.class);
    }

    protected void addLinksAnnotation(AnnotatedElement element, ResourceProperties resourceProperties, String entityClassName, String rel) {
        if (resourceProperties.isHal()) {
            AnnotationCreator linkResource = element.addAnnotation(RestLink.class);
            try {
                Class<?> entityClass = Thread.currentThread().getContextClassLoader().loadClass(entityClassName);
                linkResource.addValue("entityType", entityClass);
                linkResource.addValue("rel", (Object)rel);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)("Unable to create links for entity: '" + entityClassName + "'"), (Throwable)e);
            }
        }
    }

    protected void addPathAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(Path.class).addValue("value", (Object)value);
    }

    protected void addPathParamAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(PathParam.class).addValue("value", (Object)value);
    }

    protected void addQueryParamAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(QueryParam.class).addValue("value", (Object)value);
    }

    protected void addDefaultValueAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(DefaultValue.class).addValue("value", (Object)value);
    }

    protected void addProducesJsonAnnotation(AnnotatedElement element, ResourceProperties properties) {
        if (properties.isHal()) {
            this.addProducesAnnotation(element, "application/json", "application/hal+json");
        } else {
            this.addProducesAnnotation(element, "application/json");
        }
    }

    protected void addProducesAnnotation(AnnotatedElement element, String ... mediaTypes) {
        element.addAnnotation(Produces.class).addValue("value", (Object)mediaTypes);
    }

    protected void addConsumesAnnotation(AnnotatedElement element, String ... mediaTypes) {
        element.addAnnotation(Consumes.class).addValue("value", (Object)mediaTypes);
    }

    protected void addContextAnnotation(AnnotatedElement element) {
        element.addAnnotation(Context.class);
    }

    protected void addSortQueryParamValidatorAnnotation(AnnotatedElement element) {
        element.addAnnotation(SortQueryParamValidator.class);
    }

    protected void addMethodAnnotations(AnnotatedElement element, Collection<AnnotationInstance> methodAnnotations) {
        if (methodAnnotations != null) {
            for (AnnotationInstance methodAnnotation : methodAnnotations) {
                element.addAnnotation(methodAnnotation);
            }
        }
    }

    protected void addSecurityAnnotations(AnnotatedElement element, ResourceProperties resourceProperties) {
        String[] rolesAllowed = resourceProperties.getRolesAllowed(this.getResourceMethodName());
        if (rolesAllowed.length > 0 && this.hasSecurityCapability()) {
            element.addAnnotation(ROLES_ALLOWED_ANNOTATION).add("value", (Object)rolesAllowed);
        }
    }

    protected void addOpenApiResponseAnnotation(AnnotatedElement element, RestResponse.Status status) {
        if (this.capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            element.addAnnotation(OPENAPI_RESPONSE_ANNOTATION).add("responseCode", (Object)String.valueOf(status.getStatusCode()));
        }
    }

    protected void addOpenApiResponseAnnotation(AnnotatedElement element, RestResponse.Status status, String entityType) {
        this.addOpenApiResponseAnnotation(element, status, entityType, false);
    }

    protected void addOpenApiResponseAnnotation(AnnotatedElement element, RestResponse.Status status, String entityType, boolean isList) {
        if (this.capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            this.addOpenApiResponseAnnotation(element, status, StandardMethodImplementor.toClass(entityType), isList);
        }
    }

    protected void addOpenApiResponseAnnotation(AnnotatedElement element, RestResponse.Status status, Class<?> clazz, boolean isList) {
        if (this.capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            AnnotationCreator schemaAnnotation = AnnotationCreator.of((String)OPENAPI_SCHEMA_ANNOTATION).add("implementation", clazz);
            if (isList) {
                schemaAnnotation.add("type", (Object)StandardMethodImplementor.schemaTypeArray());
            }
            element.addAnnotation(OPENAPI_RESPONSE_ANNOTATION).add("responseCode", (Object)String.valueOf(status.getStatusCode())).add("content", (Object)new Object[]{AnnotationCreator.of((String)OPENAPI_CONTENT_ANNOTATION).add("mediaType", (Object)"application/json").add("schema", (Object)schemaAnnotation)});
        }
    }

    protected String appendToPath(String path, String suffix) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.lastIndexOf("/"));
        }
        if (suffix.startsWith("/")) {
            suffix = suffix.substring(1);
        }
        return String.join((CharSequence)"/", path, suffix);
    }

    protected boolean hasSecurityCapability() {
        return this.capabilities.isPresent("io.quarkus.security");
    }

    protected boolean hasValidatorCapability() {
        return this.capabilities.isPresent("io.quarkus.hibernate.validator");
    }

    protected boolean isNotReactivePanache() {
        return !this.capabilities.isPresent("io.quarkus.hibernate.reactive");
    }

    private static Enum schemaTypeArray() {
        Class<?> schemaTypeClass = StandardMethodImplementor.toClass(SCHEMA_TYPE_CLASS_NAME);
        return Enum.valueOf(schemaTypeClass, SCHEMA_TYPE_ARRAY);
    }

    private static Class<?> toClass(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class (" + className + ") cannot be found during deployment.", e);
        }
    }
}

