/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

public abstract class ResourceMethodListenerImplementor {
    protected static final String ON_AFTER = "onAfter";
    protected static final String ON_BEFORE_ADD_METHOD_NAME = "onBeforeAdd";
    protected static final String ON_AFTER_ADD_METHOD_NAME = "onAfterAdd";
    protected static final String ON_BEFORE_UPDATE_METHOD_NAME = "onBeforeUpdate";
    protected static final String ON_AFTER_UPDATE_METHOD_NAME = "onAfterUpdate";
    protected static final String ON_BEFORE_DELETE_METHOD_NAME = "onBeforeDelete";
    protected static final String ON_AFTER_DELETE_METHOD_NAME = "onAfterDelete";
    protected final Map<FieldDescriptor, ClassInfo> listenerFields = new HashMap<FieldDescriptor, ClassInfo>();

    public ResourceMethodListenerImplementor(ClassCreator cc, List<ClassInfo> resourceMethodListeners) {
        for (int index = 0; index < resourceMethodListeners.size(); ++index) {
            ClassInfo eventListenerClass = resourceMethodListeners.get(index);
            FieldCreator delegateField = (FieldCreator)cc.getFieldCreator("listener" + index, eventListenerClass.name().toString()).setModifiers(4);
            delegateField.addAnnotation(Inject.class);
            this.listenerFields.put(delegateField.getFieldDescriptor(), eventListenerClass);
        }
    }

    public void onBeforeAdd(BytecodeCreator methodCreator, ResultHandle entity) {
        this.invokeMethodUsingEntity(ON_BEFORE_ADD_METHOD_NAME, methodCreator, entity);
    }

    public void onBeforeUpdate(BytecodeCreator methodCreator, ResultHandle entity) {
        this.invokeMethodUsingEntity(ON_BEFORE_UPDATE_METHOD_NAME, methodCreator, entity);
    }

    public void onBeforeDelete(BytecodeCreator methodCreator, ResultHandle id) {
        this.invokeMethodUsingId(ON_BEFORE_DELETE_METHOD_NAME, methodCreator, id);
    }

    protected void invokeMethodUsingEntity(String methodName, BytecodeCreator methodCreator, ResultHandle entity) {
        this.processEventListener(methodName, methodCreator, methodCreator.getThis(), entity);
    }

    protected void invokeMethodUsingId(String methodName, BytecodeCreator methodCreator, ResultHandle id) {
        this.processEventListener(methodName, methodCreator, methodCreator.getThis(), id);
    }

    protected void processEventListener(String methodName, BytecodeCreator methodCreator, ResultHandle eventListenerContainer, ResultHandle parameter) {
        for (Map.Entry<FieldDescriptor, ClassInfo> eventListenerEntry : this.listenerFields.entrySet()) {
            MethodInfo method = this.findMethodByName(eventListenerEntry.getValue(), methodName);
            if (method == null) continue;
            ResultHandle eventListener = methodCreator.readInstanceField(eventListenerEntry.getKey(), eventListenerContainer);
            methodCreator.invokeVirtualMethod(method, eventListener, new ResultHandle[]{parameter});
        }
    }

    protected MethodInfo findMethodByName(ClassInfo classInfo, String methodName) {
        List methods = classInfo.methods();
        for (int index = 0; index < methods.size(); ++index) {
            MethodInfo method = (MethodInfo)methods.get(index);
            if (!methodName.equals(method.name())) continue;
            return method;
        }
        return null;
    }
}

