/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.csrf.reactive.runtime;

import io.quarkus.csrf.reactive.runtime.RestCsrfConfig;
import io.quarkus.vertx.http.security.CSRF;
import io.smallrye.config.SmallRyeConfig;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;

public final class RestCsrfBuilder
implements CSRF.Builder {
    private String formFieldName;
    private String tokenHeaderName;
    private String cookieName;
    private Duration cookieMaxAge;
    private String cookiePath;
    private Optional<String> cookieDomain;
    private boolean cookieForceSecure;
    private boolean cookieHttpOnly;
    private Optional<Set<String>> createTokenPath;
    private int tokenSize;
    private Optional<String> tokenSignatureKey;
    private boolean verifyToken;
    private boolean requireFormUrlEncoded;

    public RestCsrfBuilder() {
        this(RestCsrfBuilder.getRestCsrfConfig());
    }

    private RestCsrfBuilder(RestCsrfConfig config) {
        this.formFieldName = config.formFieldName();
        this.tokenHeaderName = config.tokenHeaderName();
        this.cookieName = config.cookieName();
        this.cookieMaxAge = config.cookieMaxAge();
        this.cookiePath = config.cookiePath();
        this.cookieDomain = config.cookieDomain();
        this.cookieForceSecure = config.cookieForceSecure();
        this.cookieHttpOnly = config.cookieHttpOnly();
        this.createTokenPath = config.createTokenPath();
        this.tokenSize = config.tokenSize();
        this.tokenSignatureKey = config.tokenSignatureKey();
        this.verifyToken = config.verifyToken();
        this.requireFormUrlEncoded = config.requireFormUrlEncoded();
    }

    public CSRF.Builder formFieldName(String formFieldName) {
        this.formFieldName = RestCsrfBuilder.requireNonNull(formFieldName, "Form field name");
        return this;
    }

    public CSRF.Builder tokenHeaderName(String tokenHeaderName) {
        this.tokenHeaderName = RestCsrfBuilder.requireNonNull(tokenHeaderName, "Token header name");
        return this;
    }

    public CSRF.Builder cookieName(String cookieName) {
        this.cookieName = RestCsrfBuilder.requireNonNull(cookieName, "Cookie name");
        return this;
    }

    public CSRF.Builder cookieMaxAge(Duration cookieMaxAge) {
        this.cookieMaxAge = RestCsrfBuilder.requireNonNull(cookieMaxAge, "Cookie max age");
        return this;
    }

    public CSRF.Builder cookiePath(String cookiePath) {
        this.cookiePath = RestCsrfBuilder.requireNonNull(cookiePath, "Cookie path");
        return this;
    }

    public CSRF.Builder cookieDomain(String cookieDomain) {
        this.cookieDomain = Optional.of(RestCsrfBuilder.requireNonNull(cookieDomain, "Cookie domain"));
        return this;
    }

    public CSRF.Builder cookieForceSecure() {
        this.cookieForceSecure = true;
        return this;
    }

    public CSRF.Builder cookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
        return this;
    }

    public CSRF.Builder createTokenPath(String createTokenPath) {
        RestCsrfBuilder.requireNonNull(createTokenPath, "Create token path");
        return this.createTokenPath(Set.of(createTokenPath));
    }

    public CSRF.Builder createTokenPath(Set<String> createTokenPath) {
        RestCsrfBuilder.requireNonNull(createTokenPath, "Create token path");
        if (this.createTokenPath.isEmpty()) {
            this.createTokenPath = Optional.of(Set.copyOf(createTokenPath));
        } else {
            HashSet<String> newPaths = new HashSet<String>((Collection)this.createTokenPath.get());
            newPaths.addAll(createTokenPath);
            this.createTokenPath = Optional.of(newPaths);
        }
        return this;
    }

    public CSRF.Builder tokenSize(int tokenSize) {
        this.tokenSize = tokenSize;
        return this;
    }

    public CSRF.Builder tokenSignatureKey(String tokenSignatureKey) {
        this.tokenSignatureKey = Optional.of(RestCsrfBuilder.requireNonNull(tokenSignatureKey, "Token signature key"));
        return this;
    }

    public CSRF.Builder requireFormUrlEncoded(boolean requireFormUrlEncoded) {
        this.requireFormUrlEncoded = requireFormUrlEncoded;
        return this;
    }

    public CSRF build() {
        record CSRFImpl(String formFieldName, String tokenHeaderName, String cookieName, Duration cookieMaxAge, String cookiePath, Optional<String> cookieDomain, boolean cookieForceSecure, boolean cookieHttpOnly, Optional<Set<String>> createTokenPath, int tokenSize, Optional<String> tokenSignatureKey, boolean verifyToken, boolean requireFormUrlEncoded) implements RestCsrfConfig,
        CSRF
        {
        }
        return new CSRFImpl(this.formFieldName, this.tokenHeaderName, this.cookieName, this.cookieMaxAge, this.cookiePath, this.cookieDomain, this.cookieForceSecure, this.cookieHttpOnly, this.createTokenPath, this.tokenSize, this.tokenSignatureKey, this.verifyToken, this.requireFormUrlEncoded);
    }

    private static <T> T requireNonNull(T value, String what) {
        if (value == null) {
            throw new IllegalArgumentException(what + " must not be null");
        }
        return value;
    }

    private static RestCsrfConfig getRestCsrfConfig() {
        return (RestCsrfConfig)((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).getConfigMapping(RestCsrfConfig.class);
    }
}

