/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.csrf.reactive.runtime;

import io.quarkus.csrf.reactive.runtime.RestCsrfConfig;
import io.quarkus.csrf.reactive.runtime.RestCsrfConfigHolder;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;

@ApplicationScoped
@Named(value="csrf")
public class CsrfTokenParameterProvider {
    private static final String CSRF_TOKEN_KEY = "csrf_token";
    @Inject
    RoutingContext context;
    private final String csrfFormFieldName;
    private final String csrfCookieName;
    private final String csrfHeaderName;

    public CsrfTokenParameterProvider(RestCsrfConfigHolder configHolder) {
        RestCsrfConfig config = configHolder.getConfig();
        this.csrfFormFieldName = config.formFieldName();
        this.csrfCookieName = config.cookieName();
        this.csrfHeaderName = config.tokenHeaderName();
    }

    public String getToken() {
        String token = (String)this.context.get(CSRF_TOKEN_KEY);
        if (token == null) {
            throw new IllegalStateException("CSRFFilter should have set the attribute " + this.csrfFormFieldName + ", but it is null");
        }
        return token;
    }

    public String getParameterName() {
        return this.csrfFormFieldName;
    }

    public String getCookieName() {
        return this.csrfCookieName;
    }

    public String getHeaderName() {
        return this.csrfHeaderName;
    }
}

