/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.reactive.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.oidc.token.propagation.common.deployment.AccessTokenInstanceBuildItem;
import io.quarkus.oidc.token.propagation.common.deployment.AccessTokenRequestFilterGenerator;
import io.quarkus.oidc.token.propagation.reactive.AccessTokenRequestReactiveFilter;
import io.quarkus.oidc.token.propagation.reactive.deployment.OidcTokenPropagationReactiveBuildTimeConfig;
import io.quarkus.rest.client.reactive.deployment.DotNames;
import io.quarkus.rest.client.reactive.deployment.RegisterProviderAnnotationInstanceBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

@BuildSteps(onlyIf={IsEnabled.class})
public class OidcTokenPropagationReactiveBuildStep {
    @BuildStep
    void oidcClientFilterSupport(List<AccessTokenInstanceBuildItem> accessTokenInstances, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<GeneratedBeanBuildItem> generatedBean, BuildProducer<RegisterProviderAnnotationInstanceBuildItem> providerProducer) {
        if (!accessTokenInstances.isEmpty()) {
            AccessTokenRequestFilterGenerator filterGenerator = new AccessTokenRequestFilterGenerator(unremovableBeans, reflectiveClass, generatedBean, AccessTokenRequestReactiveFilter.class);
            for (AccessTokenInstanceBuildItem instance : accessTokenInstances) {
                String providerClass = filterGenerator.generateClass(instance);
                providerProducer.produce((BuildItem)new RegisterProviderAnnotationInstanceBuildItem(instance.targetClass(), AnnotationInstance.create((DotName)DotNames.REGISTER_PROVIDER, (AnnotationTarget)instance.getAnnotationTarget(), List.of(AnnotationValue.createClassValue((String)"value", (Type)Type.create((DotName)DotName.createSimple((String)providerClass), (Type.Kind)Type.Kind.CLASS)), AnnotationValue.createIntegerValue((String)"priority", (int)1000)))));
            }
        }
    }

    @BuildStep
    void registerProvider(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClassesBuildItem) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(AccessTokenRequestReactiveFilter.class));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{AccessTokenRequestReactiveFilter.class}).reason(this.getClass().getName()).methods().fields().build());
        additionalIndexedClassesBuildItem.produce((BuildItem)new AdditionalIndexedClassesBuildItem(AccessTokenRequestReactiveFilter.class.getName()));
    }

    @BuildStep(onlyIf={IsEnabledDuringAuth.class})
    SystemPropertyBuildItem activateTokenCredentialPropagationViaDuplicatedContext(Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.oidc")) {
            return new SystemPropertyBuildItem("io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX", "true");
        }
        if (capabilities.isPresent("io.quarkus.jwt")) {
            return new SystemPropertyBuildItem("io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX", "true");
        }
        throw new ConfigurationException("Configuration property 'quarkus.rest-client-oidc-token-propagation.enabled-during-authentication' is set to 'true', however this configuration property is only supported when either 'quarkus-oidc' or 'quarkus-smallrye-jwt' extensions are present.");
    }

    public static class IsEnabledDuringAuth
    implements BooleanSupplier {
        OidcTokenPropagationReactiveBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabledDuringAuthentication();
        }
    }

    public static class IsEnabled
    implements BooleanSupplier {
        OidcTokenPropagationReactiveBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled();
        }
    }
}

