/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.jaxb.runtime;

import jakarta.enterprise.context.control.ActivateRequestContext;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.beans.Introspector;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.xml.namespace.QName;

@ActivateRequestContext
public class ClientMessageBodyWriter
implements MessageBodyWriter<Object> {
    @Inject
    Marshaller marshaller;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        this.setContentTypeIfNecessary(httpHeaders);
        this.marshal(o, entityStream);
    }

    private void setContentTypeIfNecessary(MultivaluedMap<String, Object> httpHeaders) {
        Object contentType = httpHeaders.getFirst((Object)"Content-Type");
        if (this.isNotXml(contentType)) {
            httpHeaders.putSingle((Object)"Content-Type", (Object)"application/xml");
        }
    }

    protected void marshal(Object o, OutputStream outputStream) {
        try {
            XmlRootElement jaxbElement;
            Class<?> clazz = o.getClass();
            Object jaxbObject = o;
            if (!(o instanceof JAXBElement) && (jaxbElement = clazz.getAnnotation(XmlRootElement.class)) == null) {
                jaxbObject = new JAXBElement(new QName(Introspector.decapitalize(clazz.getSimpleName())), clazz, o);
            }
            this.marshaller.marshal(jaxbObject, outputStream);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isNotXml(Object contentType) {
        return contentType == null || !contentType.toString().contains("xml");
    }
}

