/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.client.config;

import io.quarkus.redis.runtime.client.config.RedisClientConfig;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithParentName;
import java.util.Map;

@ConfigMapping(prefix="quarkus.redis")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface RedisConfig {
    public static final String REDIS_CONFIG_ROOT_NAME = "redis";
    public static final String HOSTS_CONFIG_NAME = "hosts";
    public static final String DEFAULT_CLIENT_NAME = "<default>";

    @WithParentName
    public RedisClientConfig defaultRedisClient();

    @WithParentName
    public Map<String, RedisClientConfig> namedRedisClients();

    public static boolean isDefaultClient(String name) {
        return DEFAULT_CLIENT_NAME.equalsIgnoreCase(name);
    }

    public static String propertyKey(String name, String radical) {
        Object prefix = DEFAULT_CLIENT_NAME.equals(name) ? "quarkus.redis." : "quarkus.redis.\"" + name + "\".";
        return (String)prefix + radical;
    }
}

