/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.transactions.OptimisticLockingTransactionResult;
import io.quarkus.redis.datasource.transactions.TransactionResult;
import io.quarkus.redis.runtime.datasource.OptimisticLockingTransactionResultImpl;
import io.quarkus.redis.runtime.datasource.TransactionResultImpl;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class TransactionHolder {
    private final List<Function<Response, Object>> mappers = new ArrayList<Function<Response, Object>>();
    private volatile boolean discarded = false;

    public void enqueue(Function<Response, Object> mapper) {
        this.mappers.add(mapper);
    }

    public TransactionResult toResult(Response response) {
        boolean hasErrors = false;
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < this.mappers.size(); ++i) {
            Response responsePart = response.get(i);
            if (responsePart == null || responsePart.type() != ResponseType.ERROR) {
                results.add(this.mappers.get(i).apply(responsePart));
                continue;
            }
            hasErrors = true;
            results.add(responsePart.getDelegate());
        }
        return new TransactionResultImpl(this.discarded, hasErrors, results);
    }

    public <I> OptimisticLockingTransactionResult<I> toOptimisticLockingResult(I input, Response response) {
        boolean hasErrors = false;
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < this.mappers.size(); ++i) {
            Response responsePart = response.get(i);
            if (responsePart.type() == ResponseType.ERROR) {
                hasErrors = true;
                results.add(responsePart.getDelegate());
                continue;
            }
            results.add(this.mappers.get(i).apply(responsePart));
        }
        return new OptimisticLockingTransactionResultImpl<I>(this.discarded, hasErrors, input, results);
    }

    public void discard() {
        this.discarded = true;
    }

    public boolean discarded() {
        return this.discarded;
    }
}

