/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import com.fasterxml.jackson.core.type.TypeReference;
import io.quarkus.redis.datasource.codecs.Codec;
import io.quarkus.redis.datasource.codecs.Codecs;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class Marshaller {
    public static final TypeReference<String> STRING_TYPE_REFERENCE = new TypeReference<String>(){};
    Map<Type, Codec> codecs = new ConcurrentHashMap<Type, Codec>();

    public Marshaller(Type ... hints) {
        this.addAll(hints);
    }

    public void addAll(Type ... hints) {
        ParameterValidation.doesNotContainNull((Object[])hints, (String)"hints");
        for (Type hint : hints) {
            this.codecs.computeIfAbsent(hint, h -> Codecs.getDefaultCodecFor(hint));
        }
    }

    public void add(Class<?> hint) {
        this.codecs.computeIfAbsent(hint, h -> Codecs.getDefaultCodecFor(hint));
    }

    public byte[] encode(Object o) {
        if (o instanceof String) {
            return ((String)o).getBytes(StandardCharsets.UTF_8);
        }
        if (o == null) {
            return null;
        }
        Class<?> clazz = o.getClass();
        Codec codec = this.codec(clazz);
        return codec.encode(o);
    }

    @SafeVarargs
    public final <T> List<byte[]> encode(T ... objects) {
        ParameterValidation.nonNull(objects, (String)"objects");
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (T o : objects) {
            byte[] r = this.encode((Object)o);
            result.add(r);
        }
        return result;
    }

    Codec codec(Type clazz) {
        Codec codec = this.codecs.get(clazz);
        if (codec == null) {
            codec = Codecs.getDefaultCodecFor(clazz);
            this.codecs.put(clazz, codec);
        }
        return codec;
    }

    public final <T> T decode(Type clazz, Response r) {
        if (r == null) {
            return null;
        }
        if (r.type() == ResponseType.SIMPLE) {
            return this.decode(clazz, r.toString().getBytes());
        }
        return this.decode(clazz, r.toBytes());
    }

    public final <T> T decode(Type clazz, byte[] r) {
        if (r == null) {
            return null;
        }
        Codec codec = this.codec(clazz);
        return (T)codec.decode(r);
    }

    public <F, V> Map<F, V> decodeAsMap(Response response, Type typeOfField, Type typeOfValue) {
        if (response == null || response.size() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap map = new LinkedHashMap();
        if (((Response)response.iterator().next()).type() == ResponseType.BULK) {
            Object current = null;
            for (Response member : response) {
                if (current == null) {
                    current = this.decode(typeOfField, member.toString().getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                Object val = this.decode(typeOfValue, member);
                map.put(current, val);
                current = null;
            }
        } else {
            for (Response member : response) {
                for (String key : member.getKeys()) {
                    Object field = this.decode(typeOfField, key.getBytes(StandardCharsets.UTF_8));
                    Object val = this.decode(typeOfValue, response.get(key));
                    map.put(field, val);
                }
            }
        }
        return map;
    }

    public <F> List<F> decodeAsList(Response response, Type typeOfItem) {
        if (response == null) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        for (Response item : response) {
            list.add(this.decode(typeOfItem, item));
        }
        return list;
    }

    public <T> List<T> decodeAsList(Response response, Function<Response, T> mapper) {
        if (response == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Response item : response) {
            if (item == null) {
                list.add(null);
                continue;
            }
            list.add(mapper.apply(item));
        }
        return list;
    }

    public <F> Set<F> decodeAsSet(Response response, Type typeOfItem) {
        if (response == null) {
            return Collections.emptySet();
        }
        HashSet set = new HashSet();
        for (Response item : response) {
            set.add(this.decode(typeOfItem, item));
        }
        return set;
    }

    final <F, V> Map<F, V> decodeAsOrderedMap(Response response, Type typeOfValue, F[] fields) {
        Iterator iterator = response.iterator();
        LinkedHashMap map = new LinkedHashMap();
        for (F field : fields) {
            Response v = (Response)iterator.next();
            map.put(field, this.decode(typeOfValue, v));
        }
        return map;
    }
}

