/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.client;

import io.quarkus.runtime.configuration.ConfigurationException;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.mutiny.redis.client.Request;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class RedisDataLoader {
    static final Logger LOGGER = Logger.getLogger((String)"RedisDataLoader");

    static void load(Vertx vertx, Redis redis, String path) {
        LOGGER.infof("Importing Redis data from %s", (Object)path);
        Buffer buffer = vertx.fileSystem().readFileBlocking(path);
        if (buffer == null) {
            throw new ConfigurationException("Unable to read the " + path + " file");
        }
        List<Request> batch = RedisDataLoader.read(buffer.toString().lines().collect(Collectors.toList()));
        redis.batch(batch).await().atMost(Duration.ofMinutes(1L));
    }

    private static boolean isComment(String line) {
        return line.startsWith("--") || line.startsWith("#");
    }

    private static List<Request> read(List<String> lines) {
        ArrayList<Request> requests = new ArrayList<Request>();
        int lineNumber = 0;
        for (int i = 0; i < lines.size(); ++i) {
            Request req;
            String line = lines.get(i);
            if (line.trim().length() == 0 || RedisDataLoader.isComment(line.trim()) || (req = RedisDataLoader.read(++lineNumber, line.trim())) == null) continue;
            requests.add(req);
        }
        return requests;
    }

    private static Request read(int lineNumber, String line) {
        State state = State.COMMAND;
        StringBuffer current = new StringBuffer();
        Request request = null;
        int pos = 0;
        for (char c : line.toCharArray()) {
            ++pos;
            if (state == State.COMMAND) {
                if (Character.isSpaceChar(c)) {
                    request = Request.cmd((Command)Command.create((String)RedisDataLoader.getAndClear(current)));
                    state = State.ARGUMENTS;
                    continue;
                }
                current.append(c);
                continue;
            }
            if (state == State.ARGUMENTS) {
                if (Character.isSpaceChar(c)) continue;
                if (c == '\"') {
                    state = State.PARAM_IN_DOUBLE_QUOTES;
                    continue;
                }
                if (c == '\'') {
                    state = State.PARAM_IN_QUOTES;
                    continue;
                }
                state = State.PARAM;
                current.append(c);
                continue;
            }
            if (state == State.PARAM) {
                if (!Character.isSpaceChar(c)) {
                    current.append(c);
                    continue;
                }
                request.arg(RedisDataLoader.getAndClear(current));
                state = State.ARGUMENTS;
                continue;
            }
            if (state == State.PARAM_IN_QUOTES) {
                if (c != '\'') {
                    current.append(c);
                    continue;
                }
                request.arg(RedisDataLoader.getAndClear(current));
                state = State.ARGUMENTS;
                continue;
            }
            if (state == State.PARAM_IN_DOUBLE_QUOTES) {
                if (c != '\"') {
                    current.append(c);
                    continue;
                }
                request.arg(RedisDataLoader.getAndClear(current));
                state = State.ARGUMENTS;
                continue;
            }
            throw new IllegalStateException("Unexpected character at " + lineNumber + ":" + pos + ", current state is " + state.name());
        }
        if (current.length() > 0) {
            if (state == State.COMMAND) {
                request = Request.cmd((Command)Command.create((String)RedisDataLoader.getAndClear(current)));
            } else if (state == State.PARAM) {
                request.arg(RedisDataLoader.getAndClear(current));
            } else {
                throw new IllegalStateException("End of line unexpected at " + lineNumber + ":" + pos);
            }
        }
        return request;
    }

    private static String getAndClear(StringBuffer buffer) {
        String content = buffer.toString();
        buffer.setLength(0);
        return content;
    }

    private static enum State {
        COMMAND,
        ARGUMENTS,
        PARAM,
        PARAM_IN_QUOTES,
        PARAM_IN_DOUBLE_QUOTES;

    }
}

