/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.bitmap;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import java.util.ArrayList;
import java.util.List;

public class BitFieldArgs
implements RedisCommandExtraArguments {
    private final List<Object> commands = new ArrayList<Object>();
    private BitFieldType previousBitFieldType;

    public BitFieldArgs get() {
        return this.get(this.getPreviousFieldType(), 0);
    }

    public BitFieldArgs get(BitFieldType bitFieldType) {
        return this.get(bitFieldType, 0);
    }

    public BitFieldArgs get(int offset) {
        return this.get(this.getPreviousFieldType(), offset);
    }

    public BitFieldArgs get(BitFieldType bft, int offset) {
        return this.get(bft, new Offset(false, offset));
    }

    public BitFieldArgs get(BitFieldType bft, Offset offset) {
        if (offset == null) {
            throw new IllegalArgumentException("`offset` must not be `null`");
        }
        if (offset.offset < 0) {
            throw new IllegalArgumentException("`offset` must be greater or equal to 0");
        }
        this.previousBitFieldType = bft;
        this.commands.addAll(List.of("GET", bft.toString(), offset.toString()));
        return this;
    }

    public BitFieldArgs set(BitFieldType bft, int offset, long value) {
        return this.set(bft, new Offset(false, offset), value);
    }

    public BitFieldArgs set(BitFieldType bft, Offset offset, long value) {
        if (bft == null) {
            throw new IllegalArgumentException("The BitFieldType must not be `null`");
        }
        if (offset.offset < 0) {
            throw new IllegalArgumentException("The offset must be greater or equals to 0");
        }
        this.previousBitFieldType = bft;
        this.commands.addAll(List.of("SET", bft.toString(), offset.toString(), Long.toString(value)));
        return this;
    }

    public BitFieldArgs set(long value) {
        return this.set(this.getPreviousFieldType(), value);
    }

    public BitFieldArgs set(BitFieldType bitFieldType, long value) {
        return this.set(bitFieldType, 0, value);
    }

    public BitFieldArgs set(int offset, long value) {
        return this.set(this.getPreviousFieldType(), offset, value);
    }

    public BitFieldArgs incrBy(BitFieldType bitFieldType, int offset, long value) {
        return this.incrBy(bitFieldType, new Offset(false, offset), value);
    }

    public BitFieldArgs incrBy(BitFieldType bft, Offset offset, long value) {
        if (bft == null) {
            throw new IllegalArgumentException("`btf` must not be `null`");
        }
        if (offset == null) {
            throw new IllegalArgumentException("`offset` must not be `null`");
        }
        this.previousBitFieldType = bft;
        this.commands.addAll(List.of("INCRBY", bft.toString(), offset.toString(), Long.toString(value)));
        return this;
    }

    public BitFieldArgs incrBy(int offset, long value) {
        return this.incrBy(this.getPreviousFieldType(), offset, value);
    }

    public BitFieldArgs incrBy(long value) {
        return this.incrBy(this.getPreviousFieldType(), value);
    }

    public BitFieldArgs incrBy(BitFieldType bitFieldType, long value) {
        return this.incrBy(bitFieldType, 0, value);
    }

    public BitFieldArgs overflow(OverflowType overflowType) {
        if (overflowType == null) {
            throw new IllegalArgumentException("`overflowType` must not be `null`");
        }
        this.commands.addAll(List.of("OVERFLOW", overflowType.name()));
        return this;
    }

    public static BitFieldType signed(int bits) {
        return new BitFieldType(true, bits);
    }

    public static BitFieldType unsigned(int bits) {
        return new BitFieldType(false, bits);
    }

    public static Offset offset(int offset) {
        return new Offset(false, offset);
    }

    public static Offset typeWidthBasedOffset(int offset) {
        return new Offset(true, offset);
    }

    private BitFieldType getPreviousFieldType() {
        if (this.previousBitFieldType == null) {
            throw new IllegalStateException("No previous field type found");
        }
        return this.previousBitFieldType;
    }

    @Override
    public List<Object> toArgs() {
        return this.commands;
    }

    public static class BitFieldType {
        public final boolean signed;
        public final int bits;

        public BitFieldType(String bit) {
            if (bit.startsWith("i")) {
                this.signed = true;
                this.bits = Integer.parseInt(bit.substring(1));
            } else if (bit.startsWith("u")) {
                this.signed = false;
                this.bits = Integer.parseInt(bit.substring(1));
            }
            throw new IllegalArgumentException("Invalid integer encoding for a bit field type: " + bit + ". It must start with `i` (signed integers) or `u` (unsigned integers)");
        }

        public BitFieldType(boolean signed, int bits) {
            if (bits <= 0) {
                throw new IllegalArgumentException("`bits` must be strictly positive");
            }
            if (signed && bits >= 65) {
                throw new IllegalArgumentException("Signed integers support only up to 64 bits");
            }
            if (!signed && bits >= 64) {
                throw new IllegalArgumentException("Unsigned integers support only up to 63 bits");
            }
            this.signed = signed;
            this.bits = bits;
        }

        public String toString() {
            return (this.signed ? "i" : "u") + this.bits;
        }
    }

    public static class Offset {
        public final boolean multiplyByTypeWidth;
        public final int offset;

        public Offset(String s) {
            if (s.startsWith("#")) {
                this.multiplyByTypeWidth = true;
                this.offset = Integer.parseInt(s.substring(1));
            } else {
                this.multiplyByTypeWidth = false;
                this.offset = Integer.parseInt(s);
            }
        }

        public Offset(boolean multiplyByTypeWidth, int offset) {
            this.multiplyByTypeWidth = multiplyByTypeWidth;
            this.offset = offset;
        }

        public String toString() {
            return (this.multiplyByTypeWidth ? "#" : "") + this.offset;
        }
    }

    public static enum OverflowType {
        WRAP,
        SAT,
        FAIL;

    }
}

