/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.timeseries;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncrementArgs
implements RedisCommandExtraArguments {
    private long timestamp = -1L;
    private Duration retention;
    private boolean uncompressed;
    private int chunkSize;
    private final Map<String, Object> labels = new HashMap<String, Object>();

    public IncrementArgs setTimestamp(long value) {
        this.timestamp = value;
        return this;
    }

    public IncrementArgs setRetention(Duration retention) {
        this.retention = (Duration)ParameterValidation.nonNull((Object)retention, (String)"retention");
        return this;
    }

    public IncrementArgs uncompressed() {
        this.uncompressed = true;
        return this;
    }

    public IncrementArgs chunkSize(int size) {
        this.chunkSize = size;
        return this;
    }

    public IncrementArgs label(String label, Object value) {
        this.labels.put(label, value);
        return this;
    }

    @Override
    public List<Object> toArgs() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.timestamp >= 0L) {
            list.add("TIMESTAMP");
            list.add(Long.toString(this.timestamp));
        }
        if (this.retention != null) {
            list.add("RETENTION");
            if (this.retention == Duration.ZERO) {
                list.add("0");
            } else {
                list.add(Long.toString(this.retention.toMillis()));
            }
        }
        if (this.uncompressed) {
            list.add("UNCOMPRESSED");
        }
        if (this.chunkSize > 0) {
            list.add("CHUNK_SIZE");
            list.add(Integer.toString(this.chunkSize));
        }
        if (!this.labels.isEmpty()) {
            list.add("LABELS");
            for (Map.Entry<String, Object> entry : this.labels.entrySet()) {
                list.add(entry.getKey());
                list.add(entry.getValue().toString());
            }
        }
        return list;
    }
}

