/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.json.JsonSetArgs;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class AbstractJsonCommands<K>
extends AbstractRedisCommands {
    private static final JsonSetArgs JSON_SET_DEFAULT = new JsonSetArgs();

    public AbstractJsonCommands(RedisCommandExecutor api, Type k) {
        super(api, new Marshaller(k));
    }

    <T> Uni<Response> _jsonSet(K key, String path, T value) {
        return this._jsonSet(key, path, Json.encode(value).getBytes(), JSON_SET_DEFAULT);
    }

    Uni<Response> _jsonSet(K key, String path, JsonObject json) {
        ParameterValidation.nonNull((Object)json, (String)"json");
        return this._jsonSet(key, path, json.toBuffer().getBytes(), JSON_SET_DEFAULT);
    }

    Uni<Response> _jsonSet(K key, String path, JsonArray json) {
        ParameterValidation.nonNull((Object)json, (String)"json");
        return this._jsonSet(key, path, json.toBuffer().getBytes(), JSON_SET_DEFAULT);
    }

    Uni<Response> _jsonSet(K key, String path, JsonObject json, JsonSetArgs args) {
        ParameterValidation.nonNull((Object)json, (String)"json");
        return this._jsonSet(key, path, json.toBuffer().getBytes(), args);
    }

    Uni<Response> _jsonSet(K key, String path, JsonArray json, JsonSetArgs args) {
        ParameterValidation.nonNull((Object)json, (String)"json");
        return this._jsonSet(key, path, json.toBuffer().getBytes(), args);
    }

    <T> Uni<Response> _jsonSet(K key, String path, T value, JsonSetArgs args) {
        return this._jsonSet(key, path, Json.encode(value).getBytes(), args);
    }

    Uni<Response> _jsonSet(K key, String path, byte[] encoded, JsonSetArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(path, "path");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.JSON_SET).put(this.marshaller.encode(key)).put(path).put(encoded).putAll(args.toArgs());
        return this.execute(cmd);
    }

    Uni<Response> _jsonGet(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.JSON_GET).put(this.marshaller.encode(key));
        return this.execute(cmd);
    }

    Uni<Response> _jsonGet(K key, String path) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)path, (String)"path");
        RedisCommand cmd = RedisCommand.of(Command.JSON_GET).put(this.marshaller.encode(key)).put(path);
        return this.execute(cmd);
    }

    Uni<Response> _jsonGet(K key, String ... paths) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.doesNotContainNull((Object[])paths, (String)"path");
        RedisCommand cmd = RedisCommand.of(Command.JSON_GET).put(this.marshaller.encode(key)).putAll(paths);
        return this.execute(cmd);
    }

    <T> Uni<Response> _jsonArrAppend(K key, String path, T ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        ArrayList<String> encoded = new ArrayList<String>();
        for (T value : values) {
            encoded.add(Json.encode(value));
        }
        RedisCommand cmd = RedisCommand.of(Command.JSON_ARRAPPEND).put(this.marshaller.encode(key));
        if (path != null) {
            cmd.put(path);
        }
        cmd.putAll(encoded);
        return this.execute(cmd);
    }

    <T> Uni<Response> _jsonArrIndex(K key, String path, T value, long start, long end) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)path, (String)"path");
        ParameterValidation.nonNull(value, (String)"value");
        RedisCommand cmd = RedisCommand.of(Command.JSON_ARRINDEX).put(this.marshaller.encode(key)).put(path).put(Json.encode(value)).put(start).put(end);
        return this.execute(cmd);
    }

    <T> Uni<Response> _jsonArrInsert(K key, String path, int index, T[] values) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)path, (String)"path");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        RedisCommand cmd = RedisCommand.of(Command.JSON_ARRINSERT).put(this.marshaller.encode(key)).put(path).put(index);
        for (T value : values) {
            cmd.put(Json.encode(value));
        }
        return this.execute(cmd);
    }

    Uni<Response> _jsonArrLen(K key, String path) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.JSON_ARRLEN).put(this.marshaller.encode(key));
        if (path != null) {
            cmd.put(path);
        }
        return this.execute(cmd);
    }

    Uni<Response> _jsonArrPop(K key, String path, int index) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.JSON_ARRPOP).put(this.marshaller.encode(key));
        if (path != null) {
            cmd.put(path);
        }
        if (index != -1) {
            cmd.put(-1);
        }
        return this.execute(cmd);
    }

    Uni<Response> _jsonArrTrim(K key, String path, int start, int stop) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)path, (String)"path");
        RedisCommand cmd = RedisCommand.of(Command.JSON_ARRTRIM).put(this.marshaller.encode(key)).put(path).put(start).put(stop);
        return this.execute(cmd);
    }

    Uni<Response> _jsonClear(K key, String path) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.JSON_CLEAR).put(this.marshaller.encode(key));
        if (path != null) {
            cmd.put(path);
        }
        return this.execute(cmd);
    }

    Uni<Response> _jsonDel(K key, String path) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.JSON_DEL).put(this.marshaller.encode(key));
        if (path != null) {
            cmd.put(path);
        }
        return this.execute(cmd);
    }

    Uni<Response> _jsonMget(String path, K ... keys) {
        Validation.notNullOrBlank(path, "path");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        RedisCommand cmd = RedisCommand.of(Command.JSON_MGET);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        cmd.put(path);
        return this.execute(cmd);
    }

    Uni<Response> _jsonNumincrby(K key, String path, double value) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(path, "path");
        RedisCommand cmd = RedisCommand.of(Command.JSON_NUMINCRBY).put(this.marshaller.encode(key)).put(path).put(value);
        return this.execute(cmd);
    }

    Uni<Response> _jsonObjKeys(K key, String path) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.JSON_OBJKEYS).put(this.marshaller.encode(key));
        if (path != null) {
            cmd.put(path);
        }
        return this.execute(cmd);
    }

    Uni<Response> _jsonObjLen(K key, String path) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.JSON_OBJLEN).put(this.marshaller.encode(key));
        if (path != null) {
            cmd.put(path);
        }
        return this.execute(cmd);
    }

    Uni<Response> _jsonStrAppend(K key, String path, String value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)value, (String)"value");
        RedisCommand cmd = RedisCommand.of(Command.JSON_STRAPPEND).put(this.marshaller.encode(key));
        if (path != null) {
            cmd.put(path);
        }
        cmd.put(Json.encode((Object)value));
        return this.execute(cmd);
    }

    Uni<Response> _jsonToggle(K key, String path) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)path, (String)"path");
        RedisCommand cmd = RedisCommand.of(Command.JSON_TOGGLE).put(this.marshaller.encode(key)).put(path);
        return this.execute(cmd);
    }

    Uni<Response> _jsonStrLen(K key, String path) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.JSON_STRLEN).put(this.marshaller.encode(key));
        if (path != null) {
            cmd.put(path);
        }
        return this.execute(cmd);
    }

    Uni<Response> _jsonType(K key, String path) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.JSON_TYPE).put(this.marshaller.encode(key));
        if (path != null) {
            cmd.put(path);
        }
        return this.execute(cmd);
    }
}

