/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AggregateArgs
implements RedisCommandExtraArguments {
    private boolean verbatim;
    private final Map<String, String> fields = new HashMap<String, String>();
    private boolean loadAllFields;
    private Duration timeout;
    private final List<Clause> clauses = new ArrayList<Clause>();
    private int offset = -1;
    private int count = -1;
    private final Map<String, Object> params = new HashMap<String, Object>();
    private int dialect = -1;
    private int cursorCount = -1;
    private Duration cursorMaxIdle;
    private boolean cursor;

    public AggregateArgs verbatim() {
        this.verbatim = true;
        return this;
    }

    public AggregateArgs allFields() {
        this.loadAllFields = true;
        return this;
    }

    public AggregateArgs field(String field, String alias) {
        this.fields.put(Validation.notNullOrBlank(field, "field"), alias);
        return this;
    }

    public AggregateArgs field(String field) {
        this.fields.put(Validation.notNullOrBlank(field, "field"), null);
        return this;
    }

    public AggregateArgs timeout(Duration timeout) {
        this.timeout = ParameterValidation.validate((Duration)timeout, (String)"timeout");
        return this;
    }

    public AggregateArgs groupBy(GroupBy groupBy) {
        this.clauses.add((Clause)ParameterValidation.nonNull((Object)groupBy, (String)"groupBy"));
        return this;
    }

    public AggregateArgs sortBy(SortBy sortBy) {
        this.clauses.add((Clause)ParameterValidation.nonNull((Object)sortBy, (String)"sortBy"));
        return this;
    }

    public AggregateArgs apply(Apply apply) {
        this.clauses.add((Clause)ParameterValidation.nonNull((Object)apply, (String)"apply"));
        return this;
    }

    public AggregateArgs limit(int offset, int count) {
        this.offset = ParameterValidation.positive((int)offset, (String)"offset");
        this.count = ParameterValidation.positive((int)count, (String)"count");
        return this;
    }

    public AggregateArgs filter(String filter) {
        this.clauses.add(new Filter(Validation.notNullOrBlank(filter, "filter")));
        return this;
    }

    public AggregateArgs param(String name, Object value) {
        this.params.put(Validation.notNullOrBlank(name, "name"), ParameterValidation.nonNull((Object)value, (String)"value"));
        return this;
    }

    public AggregateArgs dialect(int version) {
        this.dialect = version;
        return this;
    }

    public AggregateArgs withCursor() {
        this.cursor = true;
        return this;
    }

    public AggregateArgs cursorCount(int count) {
        this.cursorCount = ParameterValidation.positive((int)count, (String)"count");
        return this;
    }

    public AggregateArgs cursorMaxIdleTime(Duration maxIdleDuration) {
        this.cursorMaxIdle = ParameterValidation.validate((Duration)maxIdleDuration, (String)"maxIdleDuration");
        return this;
    }

    @Override
    public List<Object> toArgs() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.verbatim) {
            list.add("VERBATIM");
        }
        if (this.loadAllFields) {
            list.add("LOAD");
            list.add("*");
        }
        if (!this.fields.isEmpty()) {
            list.add("LOAD");
            ArrayList<String> f = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                f.add(entry.getKey());
                if (entry.getValue() == null) continue;
                f.add("AS");
                f.add(entry.getValue());
            }
            list.add(Integer.toString(f.size()));
            list.addAll(f);
        }
        if (this.timeout != null) {
            list.add("TIMEOUT");
            list.add(Long.toString(this.timeout.toMillis()));
        }
        if (!this.params.isEmpty()) {
            list.add("PARAMS");
            list.add(Integer.toString(this.params.size() * 2));
            for (Map.Entry entry : this.params.entrySet()) {
                list.add(entry.getKey());
                list.add(entry.getValue().toString());
            }
        }
        for (Clause clause : this.clauses) {
            list.addAll(clause.toArgs());
        }
        if (this.offset != -1) {
            list.add("LIMIT");
            list.add(Integer.toString(this.offset));
            list.add(Integer.toString(this.count));
        }
        if (this.dialect != -1) {
            list.add("DIALECT");
            list.add(Integer.toString(this.dialect));
        }
        if (this.cursor) {
            list.add("WITHCURSOR");
        }
        if (this.cursorCount != -1) {
            list.add("COUNT");
            list.add(Integer.toString(this.cursorCount));
        }
        if (this.cursorMaxIdle != null) {
            list.add("MAXIDLE");
            list.add(Long.toString(this.cursorMaxIdle.toMillis()));
        }
        return list;
    }

    public boolean hasCursor() {
        return this.cursor;
    }

    private static interface Clause {
        public List<String> toArgs();
    }

    private static class Filter
    implements Clause {
        private final String filter;

        private Filter(String filter) {
            this.filter = filter;
        }

        @Override
        public List<String> toArgs() {
            return List.of("FILTER", this.filter);
        }
    }

    private static class ReduceFunction {
        private final String function;
        private final Object[] args;
        private final String alias;

        public ReduceFunction(String function, String alias, Object ... args) {
            this.function = Validation.notNullOrBlank(function, "function");
            this.alias = alias;
            this.args = ParameterValidation.doesNotContainNull((Object[])args, (String)"args");
        }

        public List<String> toArgs() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("REDUCE");
            list.add(this.function);
            if (this.args != null && this.args.length > 0) {
                list.add(Integer.toString(this.args.length));
                for (Object arg : this.args) {
                    list.add(arg.toString());
                }
            } else {
                list.add("0");
            }
            if (this.alias != null) {
                list.add("AS");
                list.add(this.alias);
            }
            return list;
        }
    }

    public static class GroupBy
    implements Clause {
        private final List<String> properties = new ArrayList<String>();
        private final List<ReduceFunction> functions = new ArrayList<ReduceFunction>();

        public GroupBy addProperty(String property) {
            this.properties.add((String)ParameterValidation.nonNull((Object)property, (String)"property"));
            return this;
        }

        public GroupBy addReduceFunction(String function, String alias, Object ... args) {
            this.functions.add(new ReduceFunction(function, alias, args));
            return this;
        }

        public GroupBy addReduceFunction(String function, Object ... args) {
            this.functions.add(new ReduceFunction(function, null, args));
            return this;
        }

        @Override
        public List<String> toArgs() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("GROUPBY");
            list.add(Integer.toString(this.properties.size()));
            list.addAll(this.properties);
            for (ReduceFunction function : this.functions) {
                list.addAll(function.toArgs());
            }
            return list;
        }
    }

    public static class Apply
    implements Clause {
        private final String expr;
        private final String alias;

        public Apply(String expr, String alias) {
            this.expr = Validation.notNullOrBlank(expr, expr);
            this.alias = Validation.notNullOrBlank(alias, "alias");
        }

        @Override
        public List<String> toArgs() {
            return List.of("APPLY", this.expr, "AS", this.alias);
        }
    }

    public static class SortBy
    implements Clause {
        private final Map<String, String> properties = new LinkedHashMap<String, String>();
        private int max = -1;

        public SortBy ascending(String property) {
            this.properties.put(property, "ASC");
            return this;
        }

        public SortBy descending(String property) {
            this.properties.put(property, "DESC");
            return this;
        }

        public SortBy max(int max) {
            this.max = max;
            return this;
        }

        @Override
        public List<String> toArgs() {
            if (this.properties.isEmpty() && this.max == -1) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("SORTBY");
            list.add(Integer.toString(this.properties.size() * 2));
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                list.add(entry.getKey());
                list.add(entry.getValue());
            }
            if (this.max != -1) {
                list.add("MAX");
                list.add(Integer.toString(this.max));
            }
            return list;
        }
    }
}

