/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.value.GetExArgs;
import io.quarkus.redis.datasource.value.SetArgs;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.util.Map;

class AbstractStringCommands<K, V>
extends AbstractRedisCommands {
    protected final Type typeOfValue;

    AbstractStringCommands(RedisCommandExecutor redis, Type k, Type v) {
        super(redis, new Marshaller(k, v));
        this.typeOfValue = v;
    }

    Uni<Response> _set(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        RedisCommand cmd = RedisCommand.of(Command.SET).put(this.marshaller.encode(key)).put(this.marshaller.encode(value));
        return this.execute(cmd);
    }

    Uni<Response> _set(K key, V value, io.quarkus.redis.datasource.string.SetArgs setArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        ParameterValidation.nonNull((Object)setArgs, (String)"setArgs");
        RedisCommand cmd = RedisCommand.of(Command.SET);
        cmd.put(this.marshaller.encode(key));
        cmd.put(this.marshaller.encode(value));
        cmd.putArgs(setArgs);
        return this.execute(cmd);
    }

    Uni<Response> _set(K key, V value, SetArgs setArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        ParameterValidation.nonNull((Object)setArgs, (String)"setArgs");
        RedisCommand cmd = RedisCommand.of(Command.SET);
        cmd.put(this.marshaller.encode(key));
        cmd.put(this.marshaller.encode(value));
        cmd.putArgs(setArgs);
        return this.execute(cmd);
    }

    Uni<Response> _setGet(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        RedisCommand cmd = RedisCommand.of(Command.SET);
        cmd.put(this.marshaller.encode(key));
        cmd.put(this.marshaller.encode(value));
        cmd.putArgs(new io.quarkus.redis.datasource.string.SetArgs().get());
        return this.execute(cmd);
    }

    V decodeV(Response r) {
        return (V)this.marshaller.decode(this.typeOfValue, r);
    }

    Uni<Response> _setGet(K key, V value, io.quarkus.redis.datasource.string.SetArgs setArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        ParameterValidation.nonNull((Object)setArgs, (String)"setArgs");
        RedisCommand cmd = RedisCommand.of(Command.SET);
        cmd.put(this.marshaller.encode(key));
        cmd.put(this.marshaller.encode(value));
        cmd.putArgs(setArgs.get());
        return this.execute(cmd);
    }

    Uni<Response> _setGet(K key, V value, SetArgs setArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        ParameterValidation.nonNull((Object)setArgs, (String)"setArgs");
        RedisCommand cmd = RedisCommand.of(Command.SET);
        cmd.put(this.marshaller.encode(key));
        cmd.put(this.marshaller.encode(value));
        cmd.putArgs(setArgs.get());
        return this.execute(cmd);
    }

    Uni<Response> _setex(K key, long seconds, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((long)seconds, (String)"seconds");
        ParameterValidation.nonNull(value, (String)"value");
        return this.execute(RedisCommand.of(Command.SETEX).put(this.marshaller.encode(key)).put(seconds).put(this.marshaller.encode(value)));
    }

    Uni<Response> _psetex(K key, long milliseconds, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((long)milliseconds, (String)"seconds");
        ParameterValidation.nonNull(value, (String)"value");
        return this.execute(RedisCommand.of(Command.PSETEX).put(this.marshaller.encode(key)).put(milliseconds).put(this.marshaller.encode(value)));
    }

    Uni<Response> _setnx(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        return this.execute(RedisCommand.of(Command.SETNX).put(this.marshaller.encode(key)).put(this.marshaller.encode(value)));
    }

    Uni<Response> _setrange(K key, long offset, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        ParameterValidation.positiveOrZero((long)offset, (String)"offset");
        return this.execute(RedisCommand.of(Command.SETRANGE).put(this.marshaller.encode(key)).put(offset).put(this.marshaller.encode(value)));
    }

    Uni<Response> _strlen(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.STRLEN).put(this.marshaller.encode(key)));
    }

    Uni<Response> _decr(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.DECR).put(this.marshaller.encode(key)));
    }

    Uni<Response> _decrby(K key, long amount) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.DECRBY).put(this.marshaller.encode(key)).put(amount));
    }

    Uni<Response> _get(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.GET).put(this.marshaller.encode(key)));
    }

    Uni<Response> _getdel(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.GETDEL).put(this.marshaller.encode(key)));
    }

    Uni<Response> _getex(K key, io.quarkus.redis.datasource.string.GetExArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.GETEX);
        cmd.put(this.marshaller.encode(key));
        cmd.putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _getex(K key, GetExArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.GETEX);
        cmd.put(this.marshaller.encode(key));
        cmd.putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _getrange(K key, long start, long end) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positiveOrZero((long)start, (String)"start");
        return this.execute(RedisCommand.of(Command.GETRANGE).put(this.marshaller.encode(key)).put(start).put(end));
    }

    Uni<Response> _getset(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        return this.execute(RedisCommand.of(Command.GETSET).put(this.marshaller.encode(key)).put(this.marshaller.encode(value)));
    }

    Uni<Response> _incr(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.INCR).put(this.marshaller.encode(key)));
    }

    Uni<Response> _incrby(K key, long amount) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.INCRBY).put(this.marshaller.encode(key)).put(amount));
    }

    Uni<Response> _incrbyfloat(K key, double amount) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.INCRBYFLOAT).put(this.marshaller.encode(key)).put(amount));
    }

    Uni<Response> _append(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.APPEND).put(this.marshaller.encode(key)).put(this.marshaller.encode(value)));
    }

    Uni<Response> _mget(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        return this.execute(RedisCommand.of(Command.MGET).put(this.marshaller.encode(keys)));
    }

    Map<K, V> decodeAsOrderedMap(Response r, K[] keys) {
        return this.marshaller.decodeAsOrderedMap(r, this.typeOfValue, keys);
    }

    Uni<Response> _mset(Map<K, V> map) {
        Validation.notNullOrEmpty(map, "map");
        RedisCommand cmd = RedisCommand.of(Command.MSET);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            cmd.put(this.marshaller.encode(entry.getKey())).put(this.marshaller.encode(entry.getValue()));
        }
        return this.execute(cmd);
    }

    Uni<Response> _msetnx(Map<K, V> map) {
        Validation.notNullOrEmpty(map, "map");
        RedisCommand cmd = RedisCommand.of(Command.MSETNX);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            cmd.put(this.marshaller.encode(entry.getKey())).put(this.marshaller.encode(entry.getValue()));
        }
        return this.execute(cmd);
    }

    Uni<Response> _lcs(K key1, K key2) {
        ParameterValidation.nonNull(key1, (String)"key1");
        ParameterValidation.nonNull(key2, (String)"key2");
        return this.execute(RedisCommand.of(Command.LCS).put(this.marshaller.encode(key1)).put(this.marshaller.encode(key2)));
    }

    Uni<Response> _lcsLength(K key1, K key2) {
        ParameterValidation.nonNull(key1, (String)"key1");
        ParameterValidation.nonNull(key2, (String)"key2");
        return this.execute(RedisCommand.of(Command.LCS).put(this.marshaller.encode(key1)).put(this.marshaller.encode(key2)).put("LEN"));
    }
}

