/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.sortedset.ReactiveZScanCursor;
import io.quarkus.redis.datasource.sortedset.ScoredValue;
import io.quarkus.redis.datasource.sortedset.ZScanCursor;
import java.time.Duration;
import java.util.List;

public class ZScanBlockingCursorImpl<V>
implements ZScanCursor<V> {
    private final ReactiveZScanCursor<V> reactive;
    private final Duration timeout;

    public ZScanBlockingCursorImpl(ReactiveZScanCursor<V> reactive, Duration timeout) {
        this.timeout = timeout;
        this.reactive = reactive;
    }

    @Override
    public boolean hasNext() {
        return this.reactive.hasNext();
    }

    @Override
    public List<ScoredValue<V>> next() {
        return (List)this.reactive.next().await().atMost(this.timeout);
    }

    @Override
    public long cursorId() {
        return this.reactive.cursorId();
    }

    @Override
    public Iterable<ScoredValue<V>> toIterable() {
        return this.reactive.toMulti().subscribe().asIterable();
    }
}

