/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.ScanArgs;
import io.quarkus.redis.datasource.list.KeyValue;
import io.quarkus.redis.datasource.sortedset.Range;
import io.quarkus.redis.datasource.sortedset.ReactiveZScanCursor;
import io.quarkus.redis.datasource.sortedset.ScoreRange;
import io.quarkus.redis.datasource.sortedset.ScoredValue;
import io.quarkus.redis.datasource.sortedset.ZAddArgs;
import io.quarkus.redis.datasource.sortedset.ZAggregateArgs;
import io.quarkus.redis.datasource.sortedset.ZRangeArgs;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.ReactiveSortable;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.quarkus.redis.runtime.datasource.ZScanReactiveCursorImpl;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class AbstractSortedSetCommands<K, V>
extends ReactiveSortable<K, V> {
    protected final Type typeOfValue;
    protected final Type typeOfKey;
    protected static final ZAggregateArgs DEFAULT_INSTANCE_AGG = new ZAggregateArgs();
    protected static final ZRangeArgs DEFAULT_INSTANCE_RANGE = new ZRangeArgs();

    AbstractSortedSetCommands(RedisCommandExecutor redis, Type k, Type v) {
        super(redis, new Marshaller(k, v), v);
        this.typeOfValue = v;
        this.typeOfKey = k;
    }

    Uni<Response> _zadd(K key, double score, V value) {
        return this._zadd(key, new ZAddArgs(), score, value);
    }

    Uni<Response> _zadd(K key, Map<V, Double> items) {
        return this._zadd(key, new ZAddArgs(), items);
    }

    Uni<Response> _zadd(K key, ScoredValue<V> ... items) {
        return this._zadd(key, new ZAddArgs(), items);
    }

    Uni<Response> _zadd(K key, ZAddArgs args, double score, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        ParameterValidation.nonNull((Object)args, (String)"args");
        String s = this.getScoreAsString(score);
        return this.execute(RedisCommand.of(Command.ZADD).put(this.marshaller.encode(key)).putArgs(args).put(s).put(this.marshaller.encode(value)));
    }

    Uni<Response> _zadd(K key, ZAddArgs args, Map<V, Double> items) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(items, (String)"items");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.ZADD).put(this.marshaller.encode(key)).putArgs(args);
        for (Map.Entry<V, Double> entry : items.entrySet()) {
            ParameterValidation.nonNull((Object)entry.getValue(), (String)"value from items");
            String s = this.getScoreAsString(entry.getValue());
            cmd.put(s).put(this.marshaller.encode(entry.getKey()));
        }
        return this.execute(cmd);
    }

    Uni<Response> _zadd(K key, ZAddArgs args, ScoredValue<V> ... items) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(items, (String)"items");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.ZADD).put(this.marshaller.encode(key)).putArgs(args);
        for (ScoredValue<V> item : items) {
            ParameterValidation.nonNull(item.value, (String)"value from scored value");
            String s = this.getScoreAsString(item.score);
            byte[] m = this.marshaller.encode(item.value);
            cmd.put(s).put(m);
        }
        return this.execute(cmd);
    }

    Uni<Response> _zaddincr(K key, double score, V value) {
        return this._zaddincr(key, new ZAddArgs(), score, value);
    }

    Uni<Response> _zaddincr(K key, ZAddArgs args, double score, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        ParameterValidation.nonNull((Object)args, (String)"args");
        String s = this.getScoreAsString(score);
        return this.execute(RedisCommand.of(Command.ZADD).put(this.marshaller.encode(key)).putArgs(args).put("INCR").put(s).put(this.marshaller.encode(value)));
    }

    Uni<Response> _zcard(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.ZCARD).put(this.marshaller.encode(key)));
    }

    Uni<Response> _zcount(K key, ScoreRange<Double> range) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(range, (String)"range");
        return this.execute(RedisCommand.of(Command.ZCOUNT).put(this.marshaller.encode(key)).put(range.getLowerBound()).put(range.getUpperBound()));
    }

    Uni<Response> _zdiff(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length < 2) {
            throw new IllegalArgumentException("Need at least two keys");
        }
        RedisCommand cmd = RedisCommand.of(Command.ZDIFF).put(keys.length).putAll(this.marshaller.encode(keys));
        return this.execute(cmd);
    }

    Uni<Response> _zdiffWithScores(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length < 2) {
            throw new IllegalArgumentException("Need at least two keys");
        }
        RedisCommand cmd = RedisCommand.of(Command.ZDIFF).put(keys.length);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        cmd.put("WITHSCORES");
        return this.execute(cmd);
    }

    Uni<Response> _zdiffstore(K destination, K ... keys) {
        ParameterValidation.nonNull(destination, (String)"destination");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length < 2) {
            throw new IllegalArgumentException("Need at least two keys");
        }
        RedisCommand cmd = RedisCommand.of(Command.ZDIFFSTORE).put(this.marshaller.encode(destination)).put(keys.length);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        return this.execute(cmd);
    }

    Uni<Response> _zincrby(K key, double increment, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        String s = this.getScoreAsString(increment);
        return this.execute(RedisCommand.of(Command.ZINCRBY).put(this.marshaller.encode(key)).put(s).put(this.marshaller.encode(value)));
    }

    Uni<Response> _zinter(ZAggregateArgs args, K ... keys) {
        ParameterValidation.nonNull((Object)args, (String)"args");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length < 2) {
            throw new IllegalArgumentException("Need at least two keys");
        }
        RedisCommand cmd = RedisCommand.of(Command.ZINTER).put(keys.length);
        for (K k : keys) {
            cmd.put(this.marshaller.encode(k));
        }
        cmd.putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _zinter(K ... keys) {
        return this._zinter(DEFAULT_INSTANCE_AGG, keys);
    }

    Uni<Response> _zinterWithScores(ZAggregateArgs arguments, K ... keys) {
        ParameterValidation.nonNull((Object)arguments, (String)"arguments");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length < 2) {
            throw new IllegalArgumentException("Need at least two keys");
        }
        RedisCommand cmd = RedisCommand.of(Command.ZINTER).put(keys.length);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        cmd.putArgs(arguments).put("WITHSCORES");
        return this.execute(cmd);
    }

    Uni<Response> _zinterWithScores(K ... keys) {
        return this._zinterWithScores(DEFAULT_INSTANCE_AGG, keys);
    }

    Uni<Response> _zintercard(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length < 2) {
            throw new IllegalArgumentException("Need at least two keys");
        }
        RedisCommand cmd = RedisCommand.of(Command.ZINTERCARD).put(keys.length);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        return this.execute(cmd);
    }

    Uni<Response> _zintercard(long limit, K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length < 2) {
            throw new IllegalArgumentException("Need at least two keys");
        }
        ParameterValidation.positive((long)limit, (String)"limit");
        RedisCommand cmd = RedisCommand.of(Command.ZINTERCARD).put(keys.length);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        if (limit != 0L) {
            cmd.put("LIMIT").put(limit);
        }
        return this.execute(cmd);
    }

    Uni<Response> _zinterstore(K destination, ZAggregateArgs arguments, K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length < 2) {
            throw new IllegalArgumentException("Need at least two keys");
        }
        ParameterValidation.nonNull((Object)arguments, (String)"arguments");
        ParameterValidation.nonNull(destination, (String)"destination");
        RedisCommand cmd = RedisCommand.of(Command.ZINTERSTORE).put(this.marshaller.encode(destination)).put(keys.length).putAll(this.marshaller.encode(keys)).putArgs(arguments);
        return this.execute(cmd);
    }

    @SafeVarargs
    final Uni<Response> _zinterstore(K destination, K ... keys) {
        return this._zinterstore(destination, DEFAULT_INSTANCE_AGG, keys);
    }

    Uni<Response> _zlexcount(K key, Range<String> range) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(range, (String)"range");
        return this.execute(RedisCommand.of(Command.ZLEXCOUNT).put(this.marshaller.encode(key)).put(range.getLowerBound()).put(range.getUpperBound()));
    }

    Uni<Response> _zmpopMin(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        RedisCommand cmd = RedisCommand.of(Command.ZMPOP).put(keys.length).putAll(this.marshaller.encode(keys)).put("MIN");
        return this.execute(cmd);
    }

    Uni<Response> _zmpopMin(int count, K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        ParameterValidation.positive((int)count, (String)"count");
        RedisCommand cmd = RedisCommand.of(Command.ZMPOP).put(keys.length).putAll(this.marshaller.encode(keys)).put("MIN").put("COUNT").put(count);
        return this.execute(cmd);
    }

    Uni<Response> _zmpopMax(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        RedisCommand cmd = RedisCommand.of(Command.ZMPOP).put(keys.length).putAll(this.marshaller.encode(keys)).put("MAX");
        return this.execute(cmd);
    }

    Uni<Response> _zmpopMax(int count, K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        ParameterValidation.positive((int)count, (String)"count");
        RedisCommand cmd = RedisCommand.of(Command.ZMPOP).put(keys.length).putAll(this.marshaller.encode(keys)).put("MAX").put("COUNT").put(count);
        return this.execute(cmd);
    }

    Uni<Response> _bzmpopMin(Duration timeout, K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        Validation.validateTimeout(timeout, "timeout");
        RedisCommand cmd = RedisCommand.of(Command.BZMPOP).put(timeout.toSeconds()).put(keys.length).putAll(this.marshaller.encode(keys)).put("MIN");
        return this.execute(cmd);
    }

    Uni<Response> _bzmpopMin(Duration timeout, int count, K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        Validation.validateTimeout(timeout, "timeout");
        RedisCommand cmd = RedisCommand.of(Command.BZMPOP).put(timeout.toSeconds()).put(keys.length).putAll(this.marshaller.encode(keys)).put("MIN").put("COUNT").put(count);
        return this.execute(cmd);
    }

    Uni<Response> _bzmpopMax(Duration timeout, K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        Validation.validateTimeout(timeout, "timeout");
        RedisCommand cmd = RedisCommand.of(Command.BZMPOP).put(timeout.toSeconds()).put(keys.length).putAll(this.marshaller.encode(keys)).put("MAX");
        return this.execute(cmd);
    }

    Uni<Response> _bzmpopMax(Duration timeout, int count, K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        Validation.validateTimeout(timeout, "timeout");
        RedisCommand cmd = RedisCommand.of(Command.BZMPOP).put(timeout.toSeconds()).put(keys.length).putAll(this.marshaller.encode(keys)).put("MAX").put("COUNT").put(count);
        return this.execute(cmd);
    }

    Uni<Response> _zmscore(K key, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(values, "values");
        RedisCommand cmd = RedisCommand.of(Command.ZMSCORE).put(this.marshaller.encode(key)).putAll(this.marshaller.encode(values));
        return this.execute(cmd);
    }

    Uni<Response> _zpopmax(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.ZPOPMAX).put(this.marshaller.encode(key)));
    }

    Uni<Response> _zpopmax(K key, int count) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((int)count, (String)"count");
        RedisCommand cmd = RedisCommand.of(Command.ZPOPMAX).put(this.marshaller.encode(key)).put(count);
        return this.execute(cmd);
    }

    Uni<Response> _zpopmin(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.ZPOPMIN).put(this.marshaller.encode(key)));
    }

    Uni<Response> _zpopmin(K key, int count) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((int)count, (String)"count");
        RedisCommand cmd = RedisCommand.of(Command.ZPOPMIN).put(this.marshaller.encode(key)).put(count);
        return this.execute(cmd);
    }

    Uni<Response> _zrandmember(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.ZRANDMEMBER).put(this.marshaller.encode(key)));
    }

    Uni<Response> _zrandmember(K key, int count) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((int)count, (String)"count");
        return this.execute(RedisCommand.of(Command.ZRANDMEMBER).put(this.marshaller.encode(key)).put(count));
    }

    Uni<Response> _zrandmemberWithScores(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.ZRANDMEMBER).put(this.marshaller.encode(key)).put(1).put("WITHSCORES"));
    }

    Uni<Response> _zrandmemberWithScores(K key, int count) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((int)count, (String)"count");
        return this.execute(RedisCommand.of(Command.ZRANDMEMBER).put(this.marshaller.encode(key)).put(count).put("WITHSCORES"));
    }

    @SafeVarargs
    final Uni<Response> _bzpopmin(Duration timeout, K ... keys) {
        ParameterValidation.nonNull(keys, (String)"keys");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        Validation.validateTimeout(timeout, "timeout");
        RedisCommand cmd = RedisCommand.of(Command.BZPOPMIN);
        cmd.putAll(this.marshaller.encode(keys)).put(timeout.toSeconds());
        return this.execute(cmd);
    }

    @SafeVarargs
    final Uni<Response> _bzpopmax(Duration timeout, K ... keys) {
        ParameterValidation.nonNull(keys, (String)"keys");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        Validation.validateTimeout(timeout, "timeout");
        RedisCommand cmd = RedisCommand.of(Command.BZPOPMAX);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        cmd.put(timeout.toSeconds());
        return this.execute(cmd);
    }

    Uni<Response> _zrange(K key, long start, long stop, ZRangeArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.ZRANGE).put(this.marshaller.encode(key)).put(start).put(stop).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _zrangeWithScores(K key, long start, long stop, ZRangeArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.ZRANGE).put(this.marshaller.encode(key)).put(start).put(stop).putArgs(args).put("WITHSCORES");
        return this.execute(cmd);
    }

    Uni<Response> _zrange(K key, long start, long stop) {
        return this._zrange(key, start, stop, DEFAULT_INSTANCE_RANGE);
    }

    Uni<Response> _zrangeWithScores(K key, long start, long stop) {
        return this._zrangeWithScores(key, start, stop, DEFAULT_INSTANCE_RANGE);
    }

    Uni<Response> _zrangebylex(K key, Range<String> range, ZRangeArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        ParameterValidation.nonNull(range, (String)"range");
        RedisCommand cmd = RedisCommand.of(Command.ZRANGE);
        if (args.isReverse()) {
            cmd.put(this.marshaller.encode(key)).put(range.getUpperBound()).put(range.getLowerBound()).put("BYLEX").putArgs(args);
        } else {
            cmd.put(this.marshaller.encode(key)).put(range.getLowerBound()).put(range.getUpperBound()).put("BYLEX").putArgs(args);
        }
        return this.execute(cmd);
    }

    Uni<Response> _zrangebylex(K key, Range<String> range) {
        return this._zrangebylex(key, range, DEFAULT_INSTANCE_RANGE);
    }

    Uni<Response> _zrangebyscore(K key, ScoreRange<Double> range, ZRangeArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        ParameterValidation.nonNull(range, (String)"range");
        RedisCommand cmd = RedisCommand.of(Command.ZRANGE);
        if (args.isReverse() && range.isUnbounded()) {
            cmd.put(this.marshaller.encode(key)).put(range.getUpperBound()).put(range.getLowerBound()).put("BYSCORE").putArgs(args);
        } else {
            cmd.put(this.marshaller.encode(key)).put(range.getLowerBound()).put(range.getUpperBound()).put("BYSCORE").putArgs(args);
        }
        return this.execute(cmd);
    }

    Uni<Response> _zrangebyscoreWithScores(K key, ScoreRange<Double> range, ZRangeArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        ParameterValidation.nonNull(range, (String)"range");
        RedisCommand cmd = RedisCommand.of(Command.ZRANGE);
        if (args.isReverse() && range.isUnbounded()) {
            cmd.put(this.marshaller.encode(key)).put(range.getUpperBound()).put(range.getLowerBound()).put("BYSCORE").putArgs(args).put("WITHSCORES");
        } else {
            cmd.put(this.marshaller.encode(key)).put(range.getLowerBound()).put(range.getUpperBound()).put("BYSCORE").putArgs(args).put("WITHSCORES");
        }
        return this.execute(cmd);
    }

    Uni<Response> _zrangebyscore(K key, ScoreRange<Double> range) {
        return this._zrangebyscore(key, range, DEFAULT_INSTANCE_RANGE);
    }

    Uni<Response> _zrangebyscoreWithScores(K key, ScoreRange<Double> range) {
        return this._zrangebyscoreWithScores(key, range, DEFAULT_INSTANCE_RANGE);
    }

    Uni<Response> _zrangestore(K dst, K src, long min, long max, ZRangeArgs args) {
        ParameterValidation.nonNull(dst, (String)"dst");
        ParameterValidation.nonNull(src, (String)"src");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.ZRANGESTORE).put(this.marshaller.encode(dst)).put(this.marshaller.encode(src)).put(min).put(max).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _zrangestore(K dst, K src, long min, long max) {
        return this._zrangestore(dst, src, min, max, DEFAULT_INSTANCE_RANGE);
    }

    Uni<Response> _zrangestorebylex(K dst, K src, Range<String> range, ZRangeArgs args) {
        ParameterValidation.nonNull(dst, (String)"dst");
        ParameterValidation.nonNull(src, (String)"src");
        ParameterValidation.nonNull(range, (String)"range");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.ZRANGESTORE).put(this.marshaller.encode(dst)).put(this.marshaller.encode(src)).put(range.getLowerBound()).put(range.getUpperBound()).put("BYLEX").putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _zrangestorebylex(K dst, K src, Range<String> range) {
        return this._zrangestorebylex(dst, src, range, DEFAULT_INSTANCE_RANGE);
    }

    Uni<Response> _zrangestorebyscore(K dst, K src, ScoreRange<Double> range, ZRangeArgs args) {
        ParameterValidation.nonNull(dst, (String)"dst");
        ParameterValidation.nonNull(src, (String)"src");
        ParameterValidation.nonNull(range, (String)"range");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.ZRANGESTORE).put(this.marshaller.encode(dst)).put(this.marshaller.encode(src)).put(range.getLowerBound()).put(range.getUpperBound()).put("BYSCORE").putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _zrangestorebyscore(K dst, K src, ScoreRange<Double> range) {
        return this._zrangestorebyscore(dst, src, range, DEFAULT_INSTANCE_RANGE);
    }

    Uni<Response> _zrank(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        return this.execute(RedisCommand.of(Command.ZRANK).put(this.marshaller.encode(key)).put(this.marshaller.encode(value)));
    }

    Uni<Response> _zrem(K key, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(values, "values");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        RedisCommand cmd = RedisCommand.of(Command.ZREM).put(this.marshaller.encode(key));
        for (V value : values) {
            cmd.put(this.marshaller.encode(value));
        }
        return this.execute(cmd);
    }

    Uni<Response> _zremrangebylex(K key, Range<String> range) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(range, (String)"range");
        return this.execute(RedisCommand.of(Command.ZREMRANGEBYLEX).put(this.marshaller.encode(key)).put(range.getLowerBound()).put(range.getUpperBound()));
    }

    Uni<Response> _zremrangebyrank(K key, long start, long stop) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.ZREMRANGEBYRANK).put(this.marshaller.encode(key)).put(start).put(stop));
    }

    Uni<Response> _zremrangebyscore(K key, ScoreRange<Double> range) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(range, (String)"range");
        return this.execute(RedisCommand.of(Command.ZREMRANGEBYSCORE).put(this.marshaller.encode(key)).put(range.getLowerBound()).put(range.getUpperBound()));
    }

    Uni<Response> _zrevrank(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        return this.execute(RedisCommand.of(Command.ZREVRANK).put(this.marshaller.encode(key)).put(this.marshaller.encode(value)));
    }

    ReactiveZScanCursor<V> _zscan(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return new ZScanReactiveCursorImpl(this.redis, key, this.marshaller, this.typeOfValue, Collections.emptyList());
    }

    ReactiveZScanCursor<V> _zscan(K key, ScanArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        return new ZScanReactiveCursorImpl(this.redis, key, this.marshaller, this.typeOfValue, args.toArgs());
    }

    Uni<Response> _zscore(K key, V value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        return this.execute(RedisCommand.of(Command.ZSCORE).put(this.marshaller.encode(key)).put(this.marshaller.encode(value)));
    }

    Uni<Response> _zunion(ZAggregateArgs args, K ... keys) {
        ParameterValidation.nonNull((Object)args, (String)"args");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        RedisCommand cmd = RedisCommand.of(Command.ZUNION).put(keys.length);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        cmd.putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _zunion(K ... keys) {
        return this._zunion(DEFAULT_INSTANCE_AGG, keys);
    }

    Uni<Response> _zunionWithScores(K ... keys) {
        return this._zunionWithScores(DEFAULT_INSTANCE_AGG, keys);
    }

    Uni<Response> _zunionWithScores(ZAggregateArgs args, K ... keys) {
        ParameterValidation.nonNull((Object)args, (String)"args");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        RedisCommand cmd = RedisCommand.of(Command.ZUNION).put(keys.length);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        cmd.putArgs(args).put("WITHSCORES");
        return this.execute(cmd);
    }

    Uni<Response> _zunionstore(K destination, ZAggregateArgs args, K ... keys) {
        ParameterValidation.nonNull(destination, (String)"destination");
        ParameterValidation.nonNull((Object)args, (String)"args");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        RedisCommand cmd = RedisCommand.of(Command.ZUNIONSTORE).put(this.marshaller.encode(destination)).put(keys.length);
        for (K key : keys) {
            cmd.put(this.marshaller.encode(key));
        }
        cmd.putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _zunionstore(K destination, K ... keys) {
        return this._zunionstore(destination, DEFAULT_INSTANCE_AGG, keys);
    }

    protected String getScoreAsString(double score) {
        if (score == Double.MIN_VALUE || score == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (score == Double.MAX_VALUE || score == Double.POSITIVE_INFINITY) {
            return "+inf";
        }
        return Double.toString(score);
    }

    final List<ScoredValue<V>> decodeAsListOfScoredValues(Response response) {
        ArrayList<ScoredValue<V>> list = new ArrayList<ScoredValue<V>>();
        if (response == null || !response.iterator().hasNext()) {
            return Collections.emptyList();
        }
        if (((Response)response.iterator().next()).type() == ResponseType.BULK) {
            Object current = null;
            for (Response nested : response) {
                if (current == null) {
                    current = this.decodeV(nested);
                    continue;
                }
                list.add(ScoredValue.of(current, nested.toDouble()));
                current = null;
            }
            return list;
        }
        for (Response r : response) {
            list.add(this.decodeAsScoredValue(r));
        }
        return list;
    }

    ScoredValue<V> decodeAsScoredValue(Response r) {
        if (r == null || r.getDelegate() == null) {
            return null;
        }
        if (r.size() == 0) {
            return ScoredValue.empty();
        }
        return ScoredValue.of(this.decodeV(r.get(0)), r.get(1).toDouble());
    }

    Double decodeAsDouble(Response r) {
        if (r == null) {
            return null;
        }
        return r.toDouble();
    }

    Long decodeAsLong(Response r) {
        if (r == null) {
            return null;
        }
        return r.toLong();
    }

    long decodeLongOrZero(Response r) {
        if (r == null) {
            return 0L;
        }
        return r.toLong();
    }

    List<Double> decodeAsListOfDouble(Response response) {
        return this.marshaller.decodeAsList(response, nested -> {
            if (nested == null) {
                return null;
            }
            return nested.toDouble();
        });
    }

    List<V> decodeAsListOfValues(Response r) {
        return this.marshaller.decodeAsList(r, this.typeOfValue);
    }

    ScoredValue<V> decodeAsScoredValueOrEmpty(Response r) {
        if (r == null || r.size() == 0) {
            return ScoredValue.empty();
        }
        return this.decodeAsScoredValue(r.get(0));
    }

    List<ScoredValue<V>> decodePopResponseWithCount(Response r) {
        if (r != null && r.getDelegate() != null && r.size() > 1) {
            return this.decodeAsListOfScoredValues(r.get(1));
        }
        return Collections.emptyList();
    }

    ScoredValue<V> decodePopResponse(Response r) {
        if (r == null || r.getDelegate() == null) {
            return null;
        }
        List<ScoredValue<V>> values = this.decodeAsListOfScoredValues(r.get(1));
        if (values.size() == 1) {
            return values.get(0);
        }
        return null;
    }

    V decodeV(Response r) {
        return (V)this.marshaller.decode(this.typeOfValue, r);
    }

    boolean decodeIntAsBoolean(Response r) {
        return r.toInteger() == 1;
    }

    KeyValue<K, ScoredValue<V>> decodeAsKeyValue(Response r) {
        if (r == null) {
            return null;
        }
        return KeyValue.of(this.marshaller.decode(this.typeOfKey, r.get(0)), ScoredValue.of(this.decodeV(r.get(1)), r.get(2).toDouble()));
    }
}

