/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.json.JsonCommands;
import io.quarkus.redis.datasource.json.JsonSetArgs;
import io.quarkus.redis.datasource.json.ReactiveJsonCommands;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommandGroup;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.List;

public class BlockingJsonCommandsImpl<K>
extends AbstractRedisCommandGroup
implements JsonCommands<K> {
    private final ReactiveJsonCommands<K> reactive;

    public BlockingJsonCommandsImpl(RedisDataSource ds, ReactiveJsonCommands<K> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public <T> void jsonSet(K key, String path, T value) {
        this.reactive.jsonSet(key, path, value).await().atMost(this.timeout);
    }

    @Override
    public void jsonSet(K key, String path, JsonObject json) {
        this.reactive.jsonSet(key, path, json).await().atMost(this.timeout);
    }

    @Override
    public void jsonSet(K key, String path, JsonObject json, JsonSetArgs args) {
        this.reactive.jsonSet(key, path, json, args).await().atMost(this.timeout);
    }

    @Override
    public void jsonSet(K key, String path, JsonArray json) {
        this.reactive.jsonSet(key, path, json).await().atMost(this.timeout);
    }

    @Override
    public void jsonSet(K key, String path, JsonArray json, JsonSetArgs args) {
        this.reactive.jsonSet(key, path, json, args).await().atMost(this.timeout);
    }

    @Override
    public <T> void jsonSet(K key, String path, T value, JsonSetArgs args) {
        this.reactive.jsonSet(key, path, value, args).await().atMost(this.timeout);
    }

    @Override
    public <T> T jsonGet(K key, Class<T> clazz) {
        return (T)this.reactive.jsonGet(key, clazz).await().atMost(this.timeout);
    }

    @Override
    public JsonObject jsonGetObject(K key) {
        return (JsonObject)this.reactive.jsonGetObject(key).await().atMost(this.timeout);
    }

    @Override
    public JsonArray jsonGetArray(K key) {
        return (JsonArray)this.reactive.jsonGetArray(key).await().atMost(this.timeout);
    }

    @Override
    public JsonArray jsonGet(K key, String path) {
        return (JsonArray)this.reactive.jsonGet(key, path).await().atMost(this.timeout);
    }

    @Override
    public JsonObject jsonGet(K key, String ... paths) {
        return (JsonObject)this.reactive.jsonGet(key, paths).await().atMost(this.timeout);
    }

    @Override
    public <T> List<Integer> jsonArrAppend(K key, String path, T ... values) {
        return (List)this.reactive.jsonArrAppend(key, path, values).await().atMost(this.timeout);
    }

    @Override
    public <T> List<Integer> jsonArrIndex(K key, String path, T value, int start, int end) {
        return (List)this.reactive.jsonArrIndex(key, path, value, start, end).await().atMost(this.timeout);
    }

    @Override
    public <T> List<Integer> jsonArrIndex(K key, String path, T value) {
        return (List)this.reactive.jsonArrIndex(key, path, value).await().atMost(this.timeout);
    }

    @Override
    public <T> List<Integer> jsonArrInsert(K key, String path, int index, T ... values) {
        return (List)this.reactive.jsonArrInsert(key, path, index, values).await().atMost(this.timeout);
    }

    @Override
    public List<Integer> jsonArrLen(K key, String path) {
        return (List)this.reactive.jsonArrLen(key, path).await().atMost(this.timeout);
    }

    @Override
    public <T> List<T> jsonArrPop(K key, Class<T> clazz, String path, int index) {
        return (List)this.reactive.jsonArrPop(key, clazz, path, index).await().atMost(this.timeout);
    }

    @Override
    public List<Integer> jsonArrTrim(K key, String path, int start, int stop) {
        return (List)this.reactive.jsonArrTrim(key, path, start, stop).await().atMost(this.timeout);
    }

    @Override
    public int jsonClear(K key, String path) {
        return (Integer)this.reactive.jsonClear(key, path).await().atMost(this.timeout);
    }

    @Override
    public int jsonDel(K key, String path) {
        return (Integer)this.reactive.jsonDel(key, path).await().atMost(this.timeout);
    }

    @Override
    public List<JsonArray> jsonMget(String path, K ... keys) {
        return (List)this.reactive.jsonMget(path, keys).await().atMost(this.timeout);
    }

    @Override
    public void jsonNumincrby(K key, String path, double value) {
        this.reactive.jsonNumincrby(key, path, value).await().atMost(this.timeout);
    }

    @Override
    public List<List<String>> jsonObjKeys(K key, String path) {
        return (List)this.reactive.jsonObjKeys(key, path).await().atMost(this.timeout);
    }

    @Override
    public List<Integer> jsonObjLen(K key, String path) {
        return (List)this.reactive.jsonObjLen(key, path).await().atMost(this.timeout);
    }

    @Override
    public List<Integer> jsonStrAppend(K key, String path, String value) {
        return (List)this.reactive.jsonStrAppend(key, path, value).await().atMost(this.timeout);
    }

    @Override
    public List<Integer> jsonStrLen(K key, String path) {
        return (List)this.reactive.jsonStrLen(key, path).await().atMost(this.timeout);
    }

    @Override
    public List<Boolean> jsonToggle(K key, String path) {
        return (List)this.reactive.jsonToggle(key, path).await().atMost(this.timeout);
    }

    @Override
    public List<String> jsonType(K key, String path) {
        return (List)this.reactive.jsonType(key, path).await().atMost(this.timeout);
    }
}

