/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.deployment.client;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.redis.client.RedisClient;
import io.quarkus.redis.client.RedisClientName;
import io.quarkus.redis.client.RedisHostsProvider;
import io.quarkus.redis.client.RedisOptionsCustomizer;
import io.quarkus.redis.client.reactive.ReactiveRedisClient;
import io.quarkus.redis.deployment.client.RedisBuildTimeConfig;
import io.quarkus.redis.deployment.client.RedisClientBuildTimeConfig;
import io.quarkus.redis.deployment.client.RequestedRedisClientBuildItem;
import io.quarkus.redis.runtime.client.RedisClientRecorder;
import io.quarkus.redis.runtime.client.config.RedisConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.impl.types.BulkType;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class RedisClientProcessor {
    static final DotName REDIS_CLIENT_ANNOTATION = DotName.createSimple((String)RedisClientName.class.getName());
    private static final String FEATURE = "redis-client";
    private static final Pattern NAMED_CLIENT_PROPERTY_NAME_PATTERN = Pattern.compile("^quarkus\\.redis\\.(.+)\\.hosts(-provider-name)?$");
    private static final List<DotName> SUPPORTED_INJECTION_TYPE = List.of(DotName.createSimple((String)RedisClient.class.getName()), DotName.createSimple((String)ReactiveRedisClient.class.getName()), DotName.createSimple((String)Redis.class.getName()), DotName.createSimple((String)io.vertx.mutiny.redis.client.RedisAPI.class.getName()), DotName.createSimple((String)io.vertx.redis.client.Redis.class.getName()), DotName.createSimple((String)RedisAPI.class.getName()));
    public static final String NO_REDIS_SCRIPT_FILE = "no-file";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void registerRuntimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> producer) {
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem(BulkType.class.getName()));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.RedisSentinelClient"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.RedisReplicationClient"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.Slots"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.RedisClusterConnection"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.RedisReplicationConnection"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.RedisClusterClient"));
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    List<AdditionalBeanBuildItem> registerRedisClientName() {
        ArrayList<AdditionalBeanBuildItem> list = new ArrayList<AdditionalBeanBuildItem>();
        list.add(AdditionalBeanBuildItem.builder().addBeanClass(RedisClientName.class).build());
        return list;
    }

    @BuildStep
    UnremovableBeanBuildItem makeHostsProviderAndOptionsCustomizerUnremovable() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{RedisHostsProvider.class, RedisOptionsCustomizer.class});
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void init(List<RequestedRedisClientBuildItem> clients, RedisClientRecorder recorder, RedisBuildTimeConfig buildTimeConfig, BeanArchiveIndexBuildItem indexBuildItem, BeanDiscoveryFinishedBuildItem beans, ShutdownContextBuildItem shutdown, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, RedisConfig config, VertxBuildItem vertxBuildItem, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchModeBuildItem launchMode, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        HashSet<String> names = new HashSet<String>();
        for (RequestedRedisClientBuildItem client : clients) {
            names.add(client.name);
        }
        IndexView indexView = indexBuildItem.getIndex();
        Collection clientAnnotations = indexView.getAnnotations(REDIS_CLIENT_ANNOTATION);
        for (AnnotationInstance annotationInstance : clientAnnotations) {
            names.add(annotationInstance.value().asString());
        }
        beans.getInjectionPoints().stream().filter(InjectionPointInfo::hasDefaultedQualifier).filter(i -> SUPPORTED_INJECTION_TYPE.contains(i.getRequiredType().name())).findAny().ifPresent(x -> names.add("<default>"));
        beans.getInjectionPoints().stream().filter(i -> SUPPORTED_INJECTION_TYPE.contains(i.getRequiredType().name())).filter(InjectionPointInfo::isProgrammaticLookup).findAny().ifPresent(x -> names.addAll(RedisClientProcessor.configuredClientNames(buildTimeConfig, ConfigProvider.getConfig())));
        recorder.initialize(vertxBuildItem.getVertx(), names);
        for (String string : names) {
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(string, Redis.class, recorder.getRedisClient(string)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(string, io.vertx.redis.client.Redis.class, recorder.getBareRedisClient(string)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(string, io.vertx.mutiny.redis.client.RedisAPI.class, recorder.getRedisAPI(string)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(string, RedisAPI.class, recorder.getBareRedisAPI(string)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(string, RedisClient.class, recorder.getLegacyRedisClient(string)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(string, ReactiveRedisClient.class, recorder.getLegacyReactiveRedisClient(string)));
        }
        recorder.cleanup((ShutdownContext)shutdown);
        this.preloadRedisData("<default>", buildTimeConfig.defaultRedisClient(), applicationArchivesBuildItem, launchMode.getLaunchMode(), nativeImageResources, hotDeploymentWatchedFiles, recorder);
        if (buildTimeConfig.namedRedisClients() != null) {
            for (Map.Entry entry : buildTimeConfig.namedRedisClients().entrySet()) {
                this.preloadRedisData((String)entry.getKey(), (RedisClientBuildTimeConfig)entry.getValue(), applicationArchivesBuildItem, launchMode.getLaunchMode(), nativeImageResources, hotDeploymentWatchedFiles, recorder);
            }
        }
    }

    static Set<String> configuredClientNames(RedisBuildTimeConfig buildTimeConfig, Config config) {
        HashSet<String> names = new HashSet<String>();
        if (buildTimeConfig.defaultDevService().devservices().enabled()) {
            names.add("<default>");
        }
        names.addAll(buildTimeConfig.additionalDevServices().keySet());
        for (String propertyName : config.getPropertyNames()) {
            if (propertyName.equals("quarkus.redis.hosts")) {
                names.add("<default>");
                continue;
            }
            Matcher matcher = NAMED_CLIENT_PROPERTY_NAME_PATTERN.matcher(propertyName);
            if (!matcher.matches()) continue;
            names.add(matcher.group(1));
        }
        return names;
    }

    static <T> SyntheticBeanBuildItem configureAndCreateSyntheticBean(String name, Class<T> type, Supplier<T> supplier) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(type).supplier(supplier).scope(ApplicationScoped.class)).unremovable()).setRuntimeInit();
        if ("<default>".equalsIgnoreCase(name)) {
            configurator.addQualifier(Default.class);
        } else {
            configurator.addQualifier().annotation(REDIS_CLIENT_ANNOTATION).addValue("value", (Object)name).done();
        }
        return configurator.done();
    }

    private void preloadRedisData(String name, RedisClientBuildTimeConfig clientConfig, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, RedisClientRecorder recorder) {
        List<String> importFiles = RedisClientProcessor.getRedisLoadScript(clientConfig, launchMode);
        ArrayList<String> paths = new ArrayList<String>();
        for (String importFile : importFiles) {
            Path loadScriptPath;
            try {
                loadScriptPath = applicationArchivesBuildItem.getRootArchive().getChildPath(importFile);
            }
            catch (RuntimeException e) {
                throw new ConfigurationException("Unable to interpret path referenced in '" + RedisConfig.propertyKey((String)name, (String)"redis-load-script") + "=" + String.join((CharSequence)",", importFiles) + "': " + e.getMessage());
            }
            if (loadScriptPath != null && !Files.isDirectory(loadScriptPath, new LinkOption[0])) {
                nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{importFile}));
            } else if (clientConfig != null && clientConfig.loadScript().isPresent()) {
                throw new ConfigurationException("Unable to find file referenced in '" + RedisConfig.propertyKey((String)name, (String)"redis-load-script") + "=" + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)clientConfig.loadScript().get()) + "'. Remove property or add file to your path.");
            }
            hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(importFile));
            if (loadScriptPath == null) continue;
            paths.add(importFile);
        }
        if (!paths.isEmpty()) {
            if (clientConfig != null) {
                recorder.preload(name, paths, clientConfig.flushBeforeLoad(), clientConfig.loadOnlyIfEmpty());
            } else {
                recorder.preload(name, paths, true, true);
            }
        }
    }

    @BuildStep
    HealthBuildItem addHealthCheck(RedisBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkus.redis.runtime.client.health.RedisHealthCheck", buildTimeConfig.healthEnabled());
    }

    private static List<String> getRedisLoadScript(RedisClientBuildTimeConfig config, LaunchMode launchMode) {
        if (config == null) {
            return List.of("import.redis");
        }
        Optional<List<String>> scripts = config.loadScript();
        if (scripts.isPresent()) {
            return scripts.get().stream().filter(s -> !NO_REDIS_SCRIPT_FILE.equalsIgnoreCase((String)s)).collect(Collectors.toList());
        }
        if (launchMode == LaunchMode.NORMAL) {
            return Collections.emptyList();
        }
        return List.of("import.redis");
    }
}

