/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.deployment.client;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.proxy.deployment.ProxyRegistryBuildItem;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.codecs.Codec;
import io.quarkus.redis.deployment.client.RedisBuildTimeConfig;
import io.quarkus.redis.deployment.client.RedisClientProcessor;
import io.quarkus.redis.deployment.client.RequestedRedisClientBuildItem;
import io.quarkus.redis.runtime.client.RedisClientRecorder;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.tls.deployment.spi.TlsRegistryBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class RedisDatasourceProcessor {
    private static final List<DotName> SUPPORTED_INJECTION_TYPE = List.of(DotName.createSimple((String)RedisDataSource.class.getName()), DotName.createSimple((String)ReactiveRedisDataSource.class.getName()));

    @BuildStep
    public void detectUsage(BuildProducer<RequestedRedisClientBuildItem> request, RedisBuildTimeConfig buildTimeConfig, BeanArchiveIndexBuildItem indexBuildItem, BeanDiscoveryFinishedBuildItem beans) {
        HashSet<String> names = new HashSet<String>();
        IndexView indexView = indexBuildItem.getIndex();
        Collection clientAnnotations = indexView.getAnnotations(RedisClientProcessor.REDIS_CLIENT_ANNOTATION);
        for (AnnotationInstance annotation : clientAnnotations) {
            names.add(annotation.value().asString());
        }
        beans.getInjectionPoints().stream().filter(InjectionPointInfo::hasDefaultedQualifier).filter(i -> SUPPORTED_INJECTION_TYPE.contains(i.getRequiredType().name())).findAny().ifPresent(x -> names.add("<default>"));
        beans.getInjectionPoints().stream().filter(i -> SUPPORTED_INJECTION_TYPE.contains(i.getRequiredType().name())).filter(InjectionPointInfo::isProgrammaticLookup).findAny().ifPresent(x -> names.addAll(RedisClientProcessor.configuredClientNames(buildTimeConfig, ConfigProvider.getConfig())));
        for (String name : names) {
            request.produce((BuildItem)new RequestedRedisClientBuildItem(name));
        }
    }

    @BuildStep
    public void makeCodecsUnremovable(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> producer) {
        producer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(Codec.class));
        for (ClassInfo implementor : index.getIndex().getAllKnownImplementors(Codec.class.getName())) {
            producer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)implementor.name().toString()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void init(RedisClientRecorder recorder, List<RequestedRedisClientBuildItem> clients, ShutdownContextBuildItem shutdown, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, VertxBuildItem vertxBuildItem, TlsRegistryBuildItem tlsRegistryBuildItem, ProxyRegistryBuildItem proxyRegistryBuildItem) {
        if (clients.isEmpty()) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        for (RequestedRedisClientBuildItem client : clients) {
            names.add(client.name);
        }
        recorder.initialize(vertxBuildItem.getVertx(), names, tlsRegistryBuildItem.registry(), proxyRegistryBuildItem.registry());
        for (String name : names) {
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(name, RedisDataSource.class, recorder.getBlockingDataSource(name)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(name, ReactiveRedisDataSource.class, recorder.getReactiveDataSource(name)));
        }
        recorder.cleanup((ShutdownContext)shutdown);
    }
}

