/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.deployment.client;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsDevServicesSupportedByLaunchMode;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.Startable;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.devservices.common.ComposeLocator;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.redis.deployment.client.DevServicesConfig;
import io.quarkus.redis.deployment.client.RedisBuildTimeConfig;
import io.quarkus.redis.runtime.client.config.RedisConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIf={IsDevServicesSupportedByLaunchMode.class, DevServicesConfig.Enabled.class})
public class DevServicesRedisProcessor {
    private static final Logger log = Logger.getLogger(DevServicesRedisProcessor.class);
    private static final String REDIS_IMAGE = "docker.io/redis:7";
    private static final int REDIS_EXPOSED_PORT = 6379;
    private static final String REDIS_SCHEME = "redis://";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-redis";
    private static final ContainerLocator redisContainerLocator = ContainerLocator.locateContainerWithLabels((int)6379, (String[])new String[]{"quarkus-dev-service-redis"});
    private static final String QUARKUS = "quarkus.";
    private static final String DOT = ".";

    @BuildStep
    public void startRedisContainers(LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, DevServicesComposeProjectBuildItem composeProjectBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, RedisBuildTimeConfig config, BuildProducer<DevServicesResultBuildItem> devServicesResult, io.quarkus.deployment.dev.devservices.DevServicesConfig devServicesConfig) {
        HashMap<String, RedisBuildTimeConfig.DevServiceConfiguration> currentDevServicesConfiguration = new HashMap<String, RedisBuildTimeConfig.DevServiceConfiguration>(config.additionalDevServices());
        currentDevServicesConfiguration.put("<default>", config.defaultDevService());
        try {
            for (Map.Entry entry : currentDevServicesConfiguration.entrySet()) {
                String name = (String)entry.getKey();
                boolean useSharedNetwork = DevServicesSharedNetworkBuildItem.isSharedNetworkRequired((io.quarkus.deployment.dev.devservices.DevServicesConfig)devServicesConfig, devServicesSharedNetworkBuildItem);
                String configPrefix = this.getConfigPrefix(name);
                DevServicesConfig redisConfig = ((RedisBuildTimeConfig.DevServiceConfiguration)entry.getValue()).devservices();
                if (DevServicesRedisProcessor.redisDevServicesEnabled(dockerStatusBuildItem, name, redisConfig, configPrefix)) continue;
                DevServicesResultBuildItem discovered = this.discoverRunningService(composeProjectBuildItem, configPrefix, redisConfig, launchMode.getLaunchMode(), useSharedNetwork);
                if (discovered != null) {
                    devServicesResult.produce((BuildItem)discovered);
                    continue;
                }
                devServicesResult.produce((BuildItem)DevServicesResultBuildItem.owned().feature(Feature.REDIS_CLIENT).serviceName(name).serviceConfig((Object)redisConfig).startable(() -> ((QuarkusPortRedisContainer)new QuarkusPortRedisContainer(DockerImageName.parse((String)redisConfig.imageName().orElse(REDIS_IMAGE)).asCompatibleSubstituteFor(REDIS_IMAGE), redisConfig.port(), composeProjectBuildItem.getDefaultNetworkId(), useSharedNetwork).withEnv(redisConfig.containerEnv())).withSharedServiceLabel(launchMode.getLaunchMode(), redisConfig.serviceName())).configProvider(Map.of(configPrefix + "hosts", s -> REDIS_SCHEME + s.getConnectionInfo())).build());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private DevServicesResultBuildItem discoverRunningService(DevServicesComposeProjectBuildItem composeProjectBuildItem, String configPrefix, DevServicesConfig devServicesConfig, LaunchMode launchMode, boolean useSharedNetwork) {
        return redisContainerLocator.locateContainer(devServicesConfig.serviceName(), devServicesConfig.shared(), launchMode).or(() -> ComposeLocator.locateContainer((DevServicesComposeProjectBuildItem)composeProjectBuildItem, List.of(devServicesConfig.imageName().orElse("redis")), (int)6379, (LaunchMode)launchMode, (boolean)useSharedNetwork)).map(containerAddress -> {
            String redisUrl = REDIS_SCHEME + containerAddress.getUrl();
            return DevServicesResultBuildItem.discovered().feature(Feature.REDIS_CLIENT).containerId(containerAddress.getId()).config(Map.of(configPrefix + "hosts", redisUrl)).build();
        }).orElse(null);
    }

    private static boolean redisDevServicesEnabled(DockerStatusBuildItem dockerStatusBuildItem, String name, DevServicesConfig devServicesConfig, String configPrefix) {
        boolean needToStart;
        if (!devServicesConfig.enabled()) {
            log.debug((Object)("Not starting devservices for " + (RedisConfig.isDefaultClient((String)name) ? "default redis client" : name) + " as it has been disabled in the config"));
            return true;
        }
        boolean bl = needToStart = !ConfigUtils.isPropertyNonEmpty((String)(configPrefix + "hosts"));
        if (!needToStart) {
            log.debug((Object)("Not starting dev services for " + (RedisConfig.isDefaultClient((String)name) ? "default redis client" : name) + " as hosts have been provided"));
            return true;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)("Please configure quarkus.redis.hosts for " + (RedisConfig.isDefaultClient((String)name) ? "default redis client" : name) + " or get a working docker instance"));
            return true;
        }
        return false;
    }

    private String getConfigPrefix(String name) {
        Object configPrefix = "quarkus.redis.";
        if (!RedisConfig.isDefaultClient((String)name)) {
            configPrefix = (String)configPrefix + name + DOT;
        }
        return configPrefix;
    }

    private static class QuarkusPortRedisContainer
    extends GenericContainer<QuarkusPortRedisContainer>
    implements Startable {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private final String hostName;

        public QuarkusPortRedisContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, String defaultNetworkId, boolean useSharedNetwork) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            this.hostName = ConfigureUtil.configureNetwork((GenericContainer)this, (String)defaultNetworkId, (boolean)useSharedNetwork, (String)"redis");
        }

        public QuarkusPortRedisContainer withSharedServiceLabel(LaunchMode launchMode, String serviceName) {
            return (QuarkusPortRedisContainer)ConfigureUtil.configureSharedServiceLabel((GenericContainer)this, (LaunchMode)launchMode, (String)DevServicesRedisProcessor.DEV_SERVICE_LABEL, (String)serviceName);
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 6379);
            } else {
                this.addExposedPort(6379);
            }
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 6379;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getFirstMappedPort();
        }

        public String getHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }

        public void close() {
            super.close();
        }

        public String getConnectionInfo() {
            return this.getHost() + ":" + this.getPort();
        }
    }
}

