/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.pg.client.runtime.health;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.runtime.DataSourceSupport;
import io.quarkus.reactive.datasource.runtime.ReactiveDataSourceUtil;
import io.quarkus.reactive.datasource.runtime.ReactiveDatasourceHealthCheck;
import io.quarkus.reactive.pg.client.runtime.PgPoolSupport;
import io.vertx.sqlclient.Pool;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
class ReactivePgDataSourcesHealthCheck
extends ReactiveDatasourceHealthCheck {
    public ReactivePgDataSourcesHealthCheck() {
        super("Reactive PostgreSQL connections health check", "SELECT 1");
    }

    @PostConstruct
    protected void init() {
        ArcContainer container = Arc.container();
        DataSourceSupport dataSourceSupport = (DataSourceSupport)container.instance(DataSourceSupport.class, new Annotation[0]).get();
        Set excludedNames = dataSourceSupport.getHealthCheckExcludedNames();
        PgPoolSupport pgPoolSupport = (PgPoolSupport)container.instance(PgPoolSupport.class, new Annotation[0]).get();
        Set<String> pgPoolNames = pgPoolSupport.getPgPoolNames();
        for (InstanceHandle handle : container.select(Pool.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            String poolName;
            if (!handle.getBean().isActive() || !pgPoolNames.contains(poolName = ReactiveDataSourceUtil.dataSourceName((Bean)handle.getBean())) || excludedNames.contains(poolName)) continue;
            this.addPool(poolName, (Pool)handle.get());
        }
    }
}

