/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.it.openshift.client.runtime;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.quarkus.arc.DefaultBean;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class OpenShiftClientProducer {
    private static final Logger LOGGER = Logger.getLogger(OpenShiftClientProducer.class);
    private OpenShiftClient client;

    @DefaultBean
    @Singleton
    @Produces
    public OpenShiftClient openShiftClient(KubernetesSerialization kubernetesSerialization, Config config) {
        OpenShiftConfig openShiftConfig = new OpenShiftConfig(config);
        openShiftConfig.setHttp2Disable(Boolean.valueOf(config.isHttp2Disable()));
        this.client = (OpenShiftClient)new KubernetesClientBuilder().withConfig((Config)openShiftConfig).withKubernetesSerialization(kubernetesSerialization).build().adapt(OpenShiftClient.class);
        return this.client;
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            LOGGER.info((Object)"Closing OpenShift client");
            this.client.close();
        }
    }
}

