/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.JavaScriptRequestChecker;
import io.quarkus.oidc.LogoutUtils;
import io.quarkus.oidc.OidcRedirectFilter;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.Redirect;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.common.runtime.AbstractJsonObject;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.BackChannelLogoutTokenCache;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.CodeAuthenticationStateBean;
import io.quarkus.oidc.runtime.LogoutException;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.PkceStateBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.jwt.build.JwtClaimsBuilder;
import io.smallrye.jwt.build.JwtSignatureBuilder;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.core.MultiMap;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.lang.UnresolvableKeyException;

public class CodeAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    public static final String SESSION_MAX_AGE_PARAM = "session-max-age";
    static final String AMP = "&";
    static final String QUESTION_MARK = "?";
    static final String EQ = "=";
    static final String COOKIE_DELIM = "|";
    static final Pattern COOKIE_PATTERN = Pattern.compile("\\|");
    static final Uni<Void> VOID_UNI = Uni.createFrom().voidItem();
    static final String NO_OIDC_COOKIES_AVAILABLE = "no_oidc_cookies";
    static final String HTTP_SCHEME = "http";
    private static final String INTERNAL_IDTOKEN_HEADER = "internal";
    private static final Logger LOG = Logger.getLogger(CodeAuthenticationMechanism.class);
    private final BlockingTaskRunner<String> createTokenStateRequestContext;
    private final BlockingTaskRunner<AuthorizationCodeTokens> getTokenStateRequestContext;
    private final SecureRandom secureRandom = new SecureRandom();

    public CodeAuthenticationMechanism(BlockingSecurityExecutor blockingExecutor) {
        this.createTokenStateRequestContext = new BlockingTaskRunner(blockingExecutor);
        this.getTokenStateRequestContext = new BlockingTaskRunner(blockingExecutor);
    }

    public Uni<SecurityIdentity> authenticate(final RoutingContext context, final IdentityProviderManager identityProviderManager, final OidcTenantConfig oidcTenantConfig) {
        final Map cookies = context.request().cookieMap();
        final String sessionCookieValue = OidcUtils.getSessionCookie(context.data(), cookies, oidcTenantConfig);
        if (sessionCookieValue != null) {
            LOG.debug((Object)"Session cookie is present, starting the reauthentication");
            Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
            return resolvedContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                    return CodeAuthenticationMechanism.this.reAuthenticate(sessionCookieValue, context, identityProviderManager, tenantContext);
                }
            });
        }
        if (this.isStateCookieAvailable(cookies)) {
            if (OidcTenantConfig.Authentication.ResponseMode.FORM_POST == oidcTenantConfig.authentication().responseMode().orElse(OidcTenantConfig.Authentication.ResponseMode.QUERY)) {
                if (OidcUtils.isFormUrlEncodedRequest(context)) {
                    return OidcUtils.getFormUrlEncodedData(context).onItem().transformToUni((Function)new Function<io.vertx.core.MultiMap, Uni<? extends SecurityIdentity>>(){

                        @Override
                        public Uni<? extends SecurityIdentity> apply(io.vertx.core.MultiMap requestParams) {
                            return CodeAuthenticationMechanism.this.processRedirectFromOidc(context, oidcTenantConfig, identityProviderManager, requestParams, cookies);
                        }
                    });
                }
                LOG.debug((Object)("HTTP POST and " + HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString() + " content type must be used with the form_post response mode"));
                return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
            }
            return this.processRedirectFromOidc(context, oidcTenantConfig, identityProviderManager, context.queryParams(), cookies);
        }
        context.put(NO_OIDC_COOKIES_AVAILABLE, (Object)Boolean.TRUE);
        return Uni.createFrom().optional(Optional.empty());
    }

    private boolean isStateCookieAvailable(Map<String, Cookie> cookies) {
        for (String name : cookies.keySet()) {
            if (!name.startsWith("q_auth")) continue;
            return true;
        }
        return false;
    }

    private Uni<SecurityIdentity> processRedirectFromOidc(final RoutingContext context, final OidcTenantConfig oidcTenantConfig, final IdentityProviderManager identityProviderManager, final io.vertx.core.MultiMap requestParams, Map<String, Cookie> cookies) {
        List stateQueryParam = requestParams.getAll("state");
        if (stateQueryParam.size() != 1) {
            return this.stateParamIsMissing(oidcTenantConfig, context, cookies, stateQueryParam.size() > 1);
        }
        String stateCookieNameSuffix = oidcTenantConfig.authentication().allowMultipleCodeFlows() ? "_" + (String)stateQueryParam.get(0) : "";
        Cookie stateCookie = context.request().getCookie(CodeAuthenticationMechanism.getStateCookieName(oidcTenantConfig) + stateCookieNameSuffix);
        if (stateCookie == null) {
            return this.stateCookieIsMissing(oidcTenantConfig, context, cookies);
        }
        final String[] parsedStateCookieValue = COOKIE_PATTERN.split(stateCookie.getValue());
        OidcUtils.removeCookie(context, oidcTenantConfig, stateCookie.getName());
        if (!parsedStateCookieValue[0].equals(stateQueryParam.get(0))) {
            String error = "State cookie value does not match the state query parameter value, completing the code flow with HTTP status 401";
            LOG.error((Object)"State cookie value does not match the state query parameter value, completing the code flow with HTTP status 401");
            return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException("State cookie value does not match the state query parameter value, completing the code flow with HTTP status 401"));
        }
        LOG.debug((Object)"State cookie is present, processing an expected redirect from the OIDC provider");
        if (requestParams.contains("code")) {
            LOG.debug((Object)"Authorization code is present, completing the code flow");
            Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
            return resolvedContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                    return CodeAuthenticationMechanism.this.performCodeFlow(identityProviderManager, context, tenantContext, requestParams, parsedStateCookieValue);
                }
            });
        }
        if (requestParams.contains("error")) {
            OidcUtils.removeCookie(context, oidcTenantConfig, stateCookie.getName());
            String error = requestParams.get("error");
            String errorDescription = requestParams.get("error_description");
            LOG.debugf("Authentication has failed, error: %s, description: %s", (Object)error, (Object)errorDescription);
            if (oidcTenantConfig.authentication().errorPath().isPresent()) {
                Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
                return resolvedContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                        String restorePath;
                        int userQueryIndex;
                        URI absoluteUri = URI.create(context.request().absoluteURI());
                        String userQuery = null;
                        CodeAuthenticationStateBean stateBean = CodeAuthenticationMechanism.this.getCodeAuthenticationBean(parsedStateCookieValue, tenantContext);
                        if (stateBean != null && stateBean.getRestorePath() != null && (userQueryIndex = (restorePath = stateBean.getRestorePath()).indexOf(CodeAuthenticationMechanism.QUESTION_MARK)) >= 0 && userQueryIndex + 1 < restorePath.length()) {
                            userQuery = restorePath.substring(userQueryIndex + 1);
                        }
                        StringBuilder errorUri = new StringBuilder(CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(oidcTenantConfig), absoluteUri.getAuthority(), oidcTenantConfig.authentication().errorPath().get()));
                        errorUri.append('?').append(CodeAuthenticationMechanism.this.getRequestParametersAsQuery(absoluteUri, requestParams, oidcTenantConfig));
                        if (userQuery != null) {
                            errorUri.append('&').append(userQuery);
                        }
                        String finalErrorUri = errorUri.toString();
                        LOG.debugf("Error URI: %s", (Object)finalErrorUri);
                        return Uni.createFrom().failure((Throwable)new AuthenticationRedirectException(CodeAuthenticationMechanism.filterRedirect(context, tenantContext, finalErrorUri, Redirect.Location.ERROR_PAGE)));
                    }
                });
            }
            String errorMessage = "Authorization code flow has failed, error code: %s, error description: %s.\nError handler path is not configured. Have a public JAX-RS resource listening\non a path such as '/error' and point to it with 'quarkus.oidc.authentication.error-path=/error'.\nCompleting the flow with HTTP status 401.\n".formatted(error, errorDescription == null ? "" : errorDescription);
            LOG.error((Object)errorMessage);
            return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException(errorMessage));
        }
        String error = "State cookie is present but neither 'code' nor 'error' query parameter is returned";
        LOG.error((Object)"State cookie is present but neither 'code' nor 'error' query parameter is returned");
        return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException("State cookie is present but neither 'code' nor 'error' query parameter is returned"));
    }

    private static String filterRedirect(RoutingContext context, TenantConfigContext tenantContext, String redirectUri, Redirect.Location location) {
        List<OidcRedirectFilter> redirectFilters = tenantContext.getOidcRedirectFilters(location);
        if (!redirectFilters.isEmpty()) {
            OidcRedirectFilter.OidcRedirectContext redirectContext = new OidcRedirectFilter.OidcRedirectContext(context, tenantContext.getOidcTenantConfig(), (String)redirectUri, io.vertx.core.MultiMap.caseInsensitiveMultiMap());
            for (OidcRedirectFilter filter : redirectFilters) {
                filter.filter(redirectContext);
            }
            io.vertx.core.MultiMap queries = redirectContext.additionalQueryParams();
            if (!queries.isEmpty()) {
                String encoded = OidcCommonUtils.encodeForm((MultiMap)new MultiMap(queries)).toString();
                String sep = ((String)redirectUri).lastIndexOf(QUESTION_MARK) > 0 ? AMP : QUESTION_MARK;
                redirectUri = (String)redirectUri + sep + encoded;
            }
        }
        return redirectUri;
    }

    private Uni<SecurityIdentity> stateParamIsMissing(OidcTenantConfig oidcTenantConfig, RoutingContext context, Map<String, Cookie> cookies, boolean multipleStateQueryParams) {
        if (multipleStateQueryParams) {
            String error = "State query parameter can not be multi-valued if the state cookie is present";
            LOG.error((Object)"State query parameter can not be multi-valued if the state cookie is present");
            this.removeStateCookies(oidcTenantConfig, context, cookies);
            return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException("State query parameter can not be multi-valued if the state cookie is present"));
        }
        LOG.debug((Object)"State parameter can not be empty if the state cookie is present");
        return this.stateCookieIsNotMatched(oidcTenantConfig, context, cookies);
    }

    private Uni<SecurityIdentity> stateCookieIsMissing(OidcTenantConfig oidcTenantConfig, RoutingContext context, Map<String, Cookie> cookies) {
        LOG.debug((Object)"Matching state cookie is not found");
        return this.stateCookieIsNotMatched(oidcTenantConfig, context, cookies);
    }

    private Uni<SecurityIdentity> stateCookieIsNotMatched(OidcTenantConfig oidcTenantConfig, RoutingContext context, Map<String, Cookie> cookies) {
        if (!oidcTenantConfig.authentication().allowMultipleCodeFlows() || context.request().path().equals(this.getRedirectPath(oidcTenantConfig, context))) {
            if (oidcTenantConfig.authentication().failOnMissingStateParam()) {
                this.removeStateCookies(oidcTenantConfig, context, cookies);
                String error = "State query parameter is missing";
                LOG.error((Object)"State query parameter is missing");
                return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException("State query parameter is missing"));
            }
            if (!oidcTenantConfig.authentication().allowMultipleCodeFlows()) {
                this.removeStateCookies(oidcTenantConfig, context, cookies);
            }
        }
        context.put(NO_OIDC_COOKIES_AVAILABLE, (Object)Boolean.TRUE);
        return Uni.createFrom().optional(Optional.empty());
    }

    private void removeStateCookies(OidcTenantConfig oidcTenantConfig, RoutingContext context, Map<String, Cookie> cookies) {
        for (String name : cookies.keySet()) {
            if (!name.startsWith("q_auth")) continue;
            OidcUtils.removeCookie(context, oidcTenantConfig, name);
        }
    }

    private String getRequestParametersAsQuery(URI requestUri, io.vertx.core.MultiMap requestParams, OidcTenantConfig oidcConfig) {
        if (OidcTenantConfig.Authentication.ResponseMode.FORM_POST == oidcConfig.authentication().responseMode().orElse(OidcTenantConfig.Authentication.ResponseMode.QUERY)) {
            return OidcCommonUtils.encodeForm((MultiMap)new MultiMap(requestParams)).toString();
        }
        return requestUri.getRawQuery();
    }

    private Uni<SecurityIdentity> reAuthenticate(String sessionCookie, final RoutingContext context, final IdentityProviderManager identityProviderManager, final TenantConfigContext configContext) {
        context.put(TenantConfigContext.class.getName(), (Object)configContext);
        return this.resolver.getTokenStateManager().getTokens(context, configContext.oidcConfig(), sessionCookie, this.getTokenStateRequestContext).onFailure(Throwable.class).recoverWithUni((Function)new Function<Throwable, Uni<? extends AuthorizationCodeTokens>>(){

            @Override
            public Uni<AuthorizationCodeTokens> apply(Throwable t) {
                Throwable failure = t instanceof AuthenticationFailedException ? t : new AuthenticationFailedException(t);
                return CodeAuthenticationMechanism.this.removeSessionCookie(context, configContext.oidcConfig()).replaceWith(Uni.createFrom().failure(failure));
            }
        }).chain((Function)new Function<AuthorizationCodeTokens, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<? extends SecurityIdentity> apply(final AuthorizationCodeTokens session) {
                context.put("access_token", (Object)session.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), (Object)session);
                final String currentIdToken = CodeAuthenticationMechanism.decryptIdToken(configContext, session.getIdToken());
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(currentIdToken, CodeAuthenticationMechanism.this.isInternalIdToken(currentIdToken, configContext))).call((Function)new LogoutCall(context, configContext, session.getIdToken())).onFailure().recoverWithUni((Function)new Function<Throwable, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<? extends SecurityIdentity> apply(Throwable t) {
                        if (t instanceof AuthenticationRedirectException) {
                            LOG.debug((Object)"Redirecting after the reauthentication");
                            return Uni.createFrom().failure((Throwable)((AuthenticationRedirectException)t));
                        }
                        if (t instanceof LogoutException) {
                            LOG.debugf("User has been logged out, authentication challenge is required", new Object[0]);
                            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t, CodeAuthenticationMechanism.tokenMap(currentIdToken)));
                        }
                        if (!(t instanceof TokenAutoRefreshException)) {
                            boolean expired;
                            boolean bl = expired = t.getCause() instanceof InvalidJwtException && ((InvalidJwtException)t.getCause()).hasErrorCode(1);
                            if (!expired) {
                                boolean unresolvedKey;
                                Throwable failure = null;
                                boolean bl2 = unresolvedKey = t.getCause() instanceof InvalidJwtException && t.getCause().getCause() instanceof UnresolvableKeyException;
                                if (unresolvedKey && !configContext.oidcConfig().authentication().failOnUnresolvedKid() && OidcUtils.isJwtTokenExpired(currentIdToken)) {
                                    LOG.debugf("Session can not be verified due to an unresolved key exception, reauthentication is required", new Object[0]);
                                    failure = new AuthenticationFailedException(CodeAuthenticationMechanism.tokenMap(currentIdToken));
                                } else {
                                    String error = CodeAuthenticationMechanism.logAuthenticationError(context, t);
                                    failure = t.getCause() instanceof AuthenticationCompletionException ? t.getCause() : new AuthenticationCompletionException(error, t.getCause());
                                }
                                return CodeAuthenticationMechanism.this.removeSessionCookie(context, configContext.oidcConfig()).replaceWith(Uni.createFrom().failure(failure));
                            }
                            if (CodeAuthenticationMechanism.this.isRpInitiatedLogout(context, configContext)) {
                                LOG.debug((Object)"Session has expired, performing an RP initiated logout");
                                CodeAuthenticationMechanism.this.fireEvent(SecurityEvent.Type.OIDC_LOGOUT_RP_INITIATED_SESSION_EXPIRED, Map.of("session-tokens", session));
                                return Uni.createFrom().item((Object)null).call(() -> CodeAuthenticationMechanism.this.buildLogoutRedirectUriUni(context, configContext, currentIdToken));
                            }
                            if (!configContext.oidcConfig().token().refreshExpired()) {
                                LOG.debug((Object)"Token has expired, token refresh is not allowed, redirecting to re-authenticate");
                                return CodeAuthenticationMechanism.this.refreshIsNotPossible(context, configContext, t);
                            }
                            if (session.getRefreshToken() == null) {
                                LOG.debug((Object)"Token has expired, token refresh is not possible because the refresh token is null");
                                return CodeAuthenticationMechanism.this.refreshIsNotPossible(context, configContext, t);
                            }
                            if (OidcUtils.isJwtTokenExpired(session.getRefreshToken())) {
                                LOG.debug((Object)"Token has expired, token refresh is not possible because the refresh token has expired");
                                return CodeAuthenticationMechanism.this.refreshIsNotPossible(context, configContext, t);
                            }
                            LOG.debug((Object)"Token has expired, trying to refresh it");
                            return CodeAuthenticationMechanism.this.refreshSecurityIdentity(configContext, currentIdToken, session.getRefreshToken(), context, identityProviderManager, false, null);
                        }
                        SecurityIdentity currentIdentity = ((TokenAutoRefreshException)t).getSecurityIdentity();
                        if (CodeAuthenticationMechanism.this.isLogout(context, configContext, currentIdentity)) {
                            return Uni.createFrom().item((Object)currentIdentity).call((Function)new LogoutCall(context, configContext, session.getIdToken()));
                        }
                        if (session.getRefreshToken() == null) {
                            LOG.debug((Object)"Token auto-refresh is required but is not possible because the refresh token is null");
                            return CodeAuthenticationMechanism.this.autoRefreshIsNotPossible(context, configContext, currentIdentity, t);
                        }
                        if (OidcUtils.isJwtTokenExpired(session.getRefreshToken())) {
                            LOG.debug((Object)"Token auto-refresh is required but is not possible because the refresh token has expired");
                            return CodeAuthenticationMechanism.this.autoRefreshIsNotPossible(context, configContext, currentIdentity, t);
                        }
                        LOG.debug((Object)"Token auto-refresh is starting");
                        return CodeAuthenticationMechanism.this.refreshSecurityIdentity(configContext, currentIdToken, session.getRefreshToken(), context, identityProviderManager, true, currentIdentity);
                    }
                });
            }
        });
    }

    private Uni<SecurityIdentity> refreshIsNotPossible(RoutingContext context, TenantConfigContext configContext, Throwable t) {
        if (configContext.oidcConfig().authentication().sessionExpiredPath().isPresent()) {
            return this.redirectToSessionExpiredPage(context, configContext);
        }
        return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t.getCause()));
    }

    private Uni<SecurityIdentity> autoRefreshIsNotPossible(RoutingContext context, TenantConfigContext configContext, SecurityIdentity currentIdentity, Throwable t) {
        if (currentIdentity != null) {
            return Uni.createFrom().item((Object)currentIdentity);
        }
        return this.refreshIsNotPossible(context, configContext, t);
    }

    private Uni<SecurityIdentity> redirectToSessionExpiredPage(RoutingContext context, TenantConfigContext configContext) {
        URI absoluteUri = URI.create(context.request().absoluteURI());
        StringBuilder sessionExpired = new StringBuilder(this.buildUri(context, this.isForceHttps(configContext.oidcConfig()), absoluteUri.getAuthority(), configContext.oidcConfig().authentication().sessionExpiredPath().get()));
        String sessionExpiredUri = sessionExpired.toString();
        LOG.debugf("Session Expired URI: %s", (Object)sessionExpiredUri);
        return this.removeSessionCookie(context, configContext.oidcConfig()).chain(() -> Uni.createFrom().failure((Throwable)new AuthenticationRedirectException(CodeAuthenticationMechanism.filterRedirect(context, configContext, sessionExpiredUri, Redirect.Location.SESSION_EXPIRED_PAGE))));
    }

    private boolean isLogout(RoutingContext context, TenantConfigContext configContext, SecurityIdentity identity) {
        return this.isRpInitiatedLogout(context, configContext) || this.isBackChannelLogoutPending(configContext, identity) || this.isFrontChannelLogoutValid(context, configContext, identity);
    }

    private boolean isBackChannelLogoutPending(TenantConfigContext configContext, SecurityIdentity identity) {
        if (configContext.oidcConfig().logout().backchannel().path().isEmpty()) {
            return false;
        }
        BackChannelLogoutTokenCache tokens = this.resolver.getBackChannelLogoutTokens().get(configContext.oidcConfig().tenantId().get());
        if (tokens != null) {
            JsonObject idTokenJson = OidcCommonUtils.decodeJwtContent((String)((JsonWebToken)identity.getPrincipal()).getRawToken());
            String logoutTokenKeyValue = idTokenJson.getString(configContext.oidcConfig().logout().backchannel().logoutTokenKey());
            return tokens.containsTokenVerification(logoutTokenKeyValue);
        }
        return false;
    }

    private boolean isBackChannelLogoutPendingAndValid(TenantConfigContext configContext, SecurityIdentity identity) {
        if (configContext.oidcConfig().logout().backchannel().path().isEmpty()) {
            return false;
        }
        BackChannelLogoutTokenCache tokens = this.resolver.getBackChannelLogoutTokens().get(configContext.oidcConfig().tenantId().get());
        if (tokens != null) {
            JsonObject idTokenJson = OidcCommonUtils.decodeJwtContent((String)((JsonWebToken)identity.getPrincipal()).getRawToken());
            String logoutTokenKeyValue = idTokenJson.getString(configContext.oidcConfig().logout().backchannel().logoutTokenKey());
            TokenVerificationResult backChannelLogoutTokenResult = tokens.removeTokenVerification(logoutTokenKeyValue);
            if (backChannelLogoutTokenResult == null) {
                return false;
            }
            String idTokenIss = idTokenJson.getString(Claims.iss.name());
            String logoutTokenIss = backChannelLogoutTokenResult.localVerificationResult.getString(Claims.iss.name());
            if (logoutTokenIss != null && !logoutTokenIss.equals(idTokenIss)) {
                LOG.debugf("Logout token issuer does not match the ID token issuer", new Object[0]);
                return false;
            }
            String idTokenSub = idTokenJson.getString(Claims.sub.name());
            String logoutTokenSub = backChannelLogoutTokenResult.localVerificationResult.getString(Claims.sub.name());
            if (logoutTokenSub != null && idTokenSub != null && !logoutTokenSub.equals(idTokenSub)) {
                LOG.debugf("Logout token subject does not match the ID token subject", new Object[0]);
                return false;
            }
            String idTokenSid = idTokenJson.getString("sid");
            String logoutTokenSid = backChannelLogoutTokenResult.localVerificationResult.getString("sid");
            if (logoutTokenSid != null && idTokenSid != null && !logoutTokenSid.equals(idTokenSid)) {
                LOG.debugf("Logout token session id does not match the ID token session id", new Object[0]);
                return false;
            }
            LOG.debugf("Backchannel logout request for the tenant %s has been completed", (Object)configContext.oidcConfig().tenantId().get());
            this.fireEvent(SecurityEvent.Type.OIDC_BACKCHANNEL_LOGOUT_COMPLETED, identity);
            return true;
        }
        return false;
    }

    private boolean isFrontChannelLogoutValid(RoutingContext context, TenantConfigContext configContext, SecurityIdentity identity) {
        if (this.isEqualToRequestPath(configContext.oidcConfig().logout().frontchannel().path(), context, configContext)) {
            JsonObject idTokenJson = OidcCommonUtils.decodeJwtContent((String)((JsonWebToken)identity.getPrincipal()).getRawToken());
            String idTokenIss = idTokenJson.getString(Claims.iss.name());
            List frontChannelIss = context.queryParam(Claims.iss.name());
            if (frontChannelIss != null && frontChannelIss.size() == 1 && !((String)frontChannelIss.get(0)).equals(idTokenIss)) {
                LOG.debugf("Frontchannel issuer parameter does not match the ID token issuer", new Object[0]);
                return false;
            }
            String idTokenSid = idTokenJson.getString("sid");
            List frontChannelSid = context.queryParam("sid");
            if (frontChannelSid != null && frontChannelSid.size() == 1 && !((String)frontChannelSid.get(0)).equals(idTokenSid)) {
                LOG.debugf("Frontchannel session id parameter does not match the ID token session id", new Object[0]);
                return false;
            }
            LOG.debugf("Frontchannel logout request for the tenant %s has been completed", (Object)configContext.oidcConfig().tenantId().get());
            this.fireEvent(SecurityEvent.Type.OIDC_FRONTCHANNEL_LOGOUT_COMPLETED, identity);
            return true;
        }
        return false;
    }

    private boolean isInternalIdToken(String idToken, TenantConfigContext configContext) {
        JsonObject headers;
        if (!configContext.oidcConfig().authentication().idTokenRequired().orElse(true).booleanValue() && (headers = OidcUtils.decodeJwtHeaders(idToken)) != null) {
            return headers.getBoolean(INTERNAL_IDTOKEN_HEADER, Boolean.valueOf(false));
        }
        return false;
    }

    private boolean isIdTokenRequired(TenantConfigContext configContext) {
        return configContext.oidcConfig().authentication().idTokenRequired().orElse(true);
    }

    private boolean isJavaScript(RoutingContext context) {
        JavaScriptRequestChecker checker = this.resolver.getJavaScriptRequestChecker();
        if (checker != null) {
            return checker.isJavaScriptRequest(context);
        }
        String value = context.request().getHeader("X-Requested-With");
        return "JavaScript".equals(value) || "XMLHttpRequest".equals(value);
    }

    private boolean shouldAutoRedirect(TenantConfigContext configContext, RoutingContext context) {
        return this.isJavaScript(context) ? configContext.oidcConfig().authentication().javaScriptAutoRedirect() : true;
    }

    public Uni<ChallengeData> getChallenge(final RoutingContext context) {
        Uni<TenantConfigContext> tenantContext = this.resolver.resolveContext(context);
        return tenantContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<ChallengeData> apply(TenantConfigContext tenantContext) {
                return CodeAuthenticationMechanism.this.getChallengeInternal(context, tenantContext);
            }
        });
    }

    public Uni<ChallengeData> getChallengeInternal(final RoutingContext context, final TenantConfigContext configContext) {
        OidcTenantConfig previousTenantConfig;
        LOG.debugf("Starting an authentication challenge for tenant %s.", (Object)configContext.oidcConfig().tenantId().get());
        if (configContext.oidcConfig().clientName().isPresent()) {
            LOG.debugf(" Client name: %s", configContext.oidcConfig().clientName().get());
        }
        OidcTenantConfig sessionCookieConfig = configContext.oidcConfig();
        String sessionTenantIdSetByCookie = (String)context.get("tenant-id-set-by-session-cookie");
        if (sessionTenantIdSetByCookie != null && !sessionTenantIdSetByCookie.equals(sessionCookieConfig.tenantId().get()) && (previousTenantConfig = this.resolver.getResolvedConfig(sessionTenantIdSetByCookie)) != null) {
            sessionCookieConfig = previousTenantConfig;
            LOG.debugf("Removing the session cookie for the previous tenant id: %s", (Object)sessionTenantIdSetByCookie);
            OidcUtils.getSessionCookie(context, sessionCookieConfig);
        }
        return this.removeSessionCookie(context, sessionCookieConfig).chain((Function)new Function<Void, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<ChallengeData> apply(Void t) {
                if (context.get(CodeAuthenticationMechanism.NO_OIDC_COOKIES_AVAILABLE) != null && CodeAuthenticationMechanism.this.isRedirectFromProvider(context, configContext)) {
                    LOG.warn((Object)"The state cookie is missing after the redirect from OpenId Connect Provider, authentication has failed");
                    return Uni.createFrom().item((Object)new ChallengeData(401, (CharSequence)"WWW-Authenticate", "OIDC"));
                }
                if (!CodeAuthenticationMechanism.this.shouldAutoRedirect(configContext, context)) {
                    return Uni.createFrom().item((Object)new ChallengeData(499, (CharSequence)"WWW-Authenticate", "OIDC"));
                }
                StringBuilder codeFlowParams = new StringBuilder(168);
                codeFlowParams.append("response_type").append(CodeAuthenticationMechanism.EQ).append("code");
                if (OidcTenantConfig.Authentication.ResponseMode.FORM_POST == configContext.oidcConfig().authentication().responseMode().orElse(OidcTenantConfig.Authentication.ResponseMode.QUERY)) {
                    codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("response_mode").append(CodeAuthenticationMechanism.EQ).append(configContext.oidcConfig().authentication().responseMode().get().toString().toLowerCase());
                }
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("client_id").append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode((String)((String)configContext.oidcConfig().clientId().get())));
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("scope").append(CodeAuthenticationMechanism.EQ).append(OidcUtils.encodeScopes(configContext.oidcConfig()));
                io.vertx.core.MultiMap requestQueryParams = null;
                if (!configContext.oidcConfig().authentication().forwardParams().isEmpty()) {
                    requestQueryParams = context.queryParams();
                    for (String forwardedParam : configContext.oidcConfig().authentication().forwardParams().get()) {
                        if (!requestQueryParams.contains(forwardedParam)) continue;
                        for (String requestQueryParamValue : requestQueryParams.getAll(forwardedParam)) {
                            codeFlowParams.append(CodeAuthenticationMechanism.AMP).append(forwardedParam).append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode((String)requestQueryParamValue));
                        }
                        requestQueryParams.remove(forwardedParam);
                    }
                }
                String redirectPath = CodeAuthenticationMechanism.this.getRedirectPath(configContext.oidcConfig(), context);
                String redirectUriParam = CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(configContext.oidcConfig()), redirectPath);
                LOG.debugf("Authentication request redirect_uri parameter: %s", (Object)redirectUriParam);
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("redirect_uri").append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode((String)redirectUriParam));
                PkceStateBean pkceStateBean = CodeAuthenticationMechanism.this.createPkceStateBean(configContext);
                String nonce = configContext.oidcConfig().authentication().nonceRequired() ? UUID.randomUUID().toString() : null;
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("state").append(CodeAuthenticationMechanism.EQ).append(CodeAuthenticationMechanism.this.generateCodeFlowState(context, configContext, redirectPath, requestQueryParams, pkceStateBean != null ? pkceStateBean.getCodeVerifier() : null, nonce));
                if (pkceStateBean != null) {
                    codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("code_challenge").append(CodeAuthenticationMechanism.EQ).append(pkceStateBean.getCodeChallenge());
                    codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("code_challenge_method").append(CodeAuthenticationMechanism.EQ).append("S256");
                }
                if (nonce != null) {
                    codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("nonce").append(CodeAuthenticationMechanism.EQ).append(nonce);
                }
                CodeAuthenticationMechanism.addExtraParamsToUri(codeFlowParams, configContext.oidcConfig().authentication().extraParams());
                Object authorizationURL = configContext.provider().getMetadata().getAuthorizationUri() + CodeAuthenticationMechanism.QUESTION_MARK + String.valueOf(codeFlowParams);
                authorizationURL = CodeAuthenticationMechanism.filterRedirect(context, configContext, (String)authorizationURL, Redirect.Location.OIDC_AUTHORIZATION);
                LOG.debugf("Code flow redirect to: %s", authorizationURL);
                return Uni.createFrom().item((Object)new ChallengeData(HttpResponseStatus.FOUND.code(), HttpHeaders.LOCATION, (String)authorizationURL));
            }
        });
    }

    private boolean isRedirectFromProvider(RoutingContext context, TenantConfigContext configContext) {
        String referer = context.request().getHeader(HttpHeaders.REFERER);
        return referer != null && referer.startsWith(configContext.provider().getMetadata().getAuthorizationUri());
    }

    private PkceStateBean createPkceStateBean(TenantConfigContext configContext) {
        if (configContext.oidcConfig().authentication().pkceRequired().orElse(false).booleanValue()) {
            PkceStateBean bean = new PkceStateBean();
            Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
            byte[] codeVerifierBytes = new byte[32];
            this.secureRandom.nextBytes(codeVerifierBytes);
            String codeVerifier = encoder.encodeToString(codeVerifierBytes);
            bean.setCodeVerifier(codeVerifier);
            try {
                byte[] codeChallengeBytes = OidcUtils.getSha256Digest(codeVerifier.getBytes(StandardCharsets.ISO_8859_1));
                String codeChallenge = encoder.encodeToString(codeChallengeBytes);
                bean.setCodeChallenge(codeChallenge);
            }
            catch (Exception ex) {
                LOG.errorf("Code challenge creation failure: %s", (Object)ex.getMessage());
                throw new AuthenticationCompletionException((Throwable)ex);
            }
            return bean;
        }
        return null;
    }

    private Uni<SecurityIdentity> performCodeFlow(final IdentityProviderManager identityProviderManager, final RoutingContext context, final TenantConfigContext configContext, final io.vertx.core.MultiMap requestParams, String[] parsedStateCookieValue) {
        String userPath = null;
        String userQuery = null;
        final CodeAuthenticationStateBean stateBean = this.getCodeAuthenticationBean(parsedStateCookieValue, configContext);
        if (stateBean != null && stateBean.getRestorePath() != null) {
            String restorePath = stateBean.getRestorePath();
            int userQueryIndex = restorePath.indexOf(QUESTION_MARK);
            if (userQueryIndex >= 0) {
                String string = userPath = this.isRestorePath(configContext.oidcConfig().authentication()) ? restorePath.substring(0, userQueryIndex) : null;
                if (userQueryIndex + 1 < restorePath.length()) {
                    userQuery = restorePath.substring(userQueryIndex + 1);
                }
            } else {
                userPath = restorePath;
            }
        }
        final String finalUserPath = userPath;
        final String finalUserQuery = userQuery;
        String code = requestParams.get("code");
        LOG.debug((Object)"Exchanging the authorization code for the tokens");
        Uni<AuthorizationCodeTokens> codeFlowTokensUni = this.getCodeFlowTokensUni(context, configContext, code, stateBean != null ? stateBean.getCodeVerifier() : null);
        return codeFlowTokensUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<AuthorizationCodeTokens, Throwable, Uni<? extends SecurityIdentity>>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public Uni<SecurityIdentity> apply(final AuthorizationCodeTokens tokens, Throwable tOuter) {
                boolean internalIdToken;
                if (tOuter != null) {
                    LOG.errorf("Exception during the code to token exchange: %s", (Object)tOuter.getMessage());
                    return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException(tOuter));
                }
                if (tokens.getIdToken() == null) {
                    if (CodeAuthenticationMechanism.this.isIdTokenRequired(configContext)) {
                        LOG.errorf("ID token is not available in the authorization code grant response", new Object[0]);
                        return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
                    }
                    if (tokens.getAccessToken() == null) {
                        LOG.errorf("Neither ID token nor access tokens are available in the authorization code grant response. Please check logs for more details, enable debug log level if no details are visible.", new Object[0]);
                        return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
                    }
                    tokens.setIdToken(CodeAuthenticationMechanism.this.generateInternalIdToken(configContext, null, null, tokens.getAccessTokenExpiresIn()));
                    internalIdToken = true;
                } else {
                    if (!CodeAuthenticationMechanism.prepareNonceForVerification(context, configContext.oidcConfig(), stateBean)) {
                        return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
                    }
                    internalIdToken = false;
                }
                context.put("new_authentication", (Object)Boolean.TRUE);
                context.put("access_token", (Object)tokens.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), (Object)tokens);
                final String idToken = CodeAuthenticationMechanism.decryptIdToken(configContext, tokens.getIdToken());
                LOG.debug((Object)"Authorization code has been exchanged, verifying ID token");
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(idToken, internalIdToken)).call(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<Void> apply(SecurityIdentity identity) {
                        if (internalIdToken && OidcUtils.cacheUserInfoInIdToken(CodeAuthenticationMechanism.this.resolver, configContext.oidcConfig())) {
                            tokens.setIdToken(CodeAuthenticationMechanism.this.generateInternalIdToken(configContext, (UserInfo)((Object)identity.getAttribute("userinfo")), null, tokens.getAccessTokenExpiresIn()));
                        }
                        return CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, tokens, idToken, identity);
                    }
                }).map((Function)new Function<SecurityIdentity, SecurityIdentity>(){

                    @Override
                    public SecurityIdentity apply(SecurityIdentity identity) {
                        boolean removeRedirectParams = configContext.oidcConfig().authentication().removeRedirectParameters();
                        if (removeRedirectParams || finalUserPath != null || finalUserQuery != null) {
                            URI absoluteUri = URI.create(context.request().absoluteURI());
                            StringBuilder finalUriWithoutQuery = new StringBuilder(CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(configContext.oidcConfig()), absoluteUri.getAuthority(), finalUserPath != null ? finalUserPath : absoluteUri.getRawPath()));
                            if (!removeRedirectParams) {
                                finalUriWithoutQuery.append('?').append(CodeAuthenticationMechanism.this.getRequestParametersAsQuery(absoluteUri, requestParams, configContext.oidcConfig()));
                            }
                            if (finalUserQuery != null) {
                                finalUriWithoutQuery.append(!removeRedirectParams ? "" : CodeAuthenticationMechanism.QUESTION_MARK);
                                finalUriWithoutQuery.append(finalUserQuery);
                            }
                            String finalRedirectUri = finalUriWithoutQuery.toString();
                            LOG.debugf("Removing code flow redirect parameters, final redirect URI: %s", (Object)finalRedirectUri);
                            throw new AuthenticationRedirectException(CodeAuthenticationMechanism.filterRedirect(context, configContext, finalRedirectUri, Redirect.Location.LOCAL_ENDPOINT_CALLBACK));
                        }
                        return identity;
                    }
                }).onFailure().transform((Function)new Function<Throwable, Throwable>(){

                    @Override
                    public Throwable apply(Throwable tInner) {
                        if (tInner instanceof AuthenticationRedirectException) {
                            LOG.debugf("Starting the final redirect", new Object[0]);
                            return tInner;
                        }
                        String errorMessage = CodeAuthenticationMechanism.logAuthenticationError(context, tInner);
                        return new AuthenticationCompletionException(errorMessage, tInner);
                    }
                });
            }
        });
    }

    private static String logAuthenticationError(RoutingContext context, Throwable t) {
        boolean accessTokenFailure;
        String errorMessage = null;
        boolean bl = accessTokenFailure = context.get("code_flow_access_token_failure") != null;
        if (accessTokenFailure) {
            errorMessage = "Access token verification has failed: %s\n".formatted(CodeAuthenticationMechanism.errorMessage(t));
            LOG.error((Object)errorMessage);
        } else {
            errorMessage = "ID token verification has failed: %s\n".formatted(CodeAuthenticationMechanism.errorMessage(t));
            LOG.error((Object)errorMessage);
        }
        return errorMessage;
    }

    private static boolean prepareNonceForVerification(RoutingContext context, OidcTenantConfig oidcConfig, CodeAuthenticationStateBean stateBean) {
        if (oidcConfig.authentication().nonceRequired()) {
            if (stateBean != null && stateBean.getNonce() != null) {
                context.put("nonce", (Object)stateBean.getNonce());
                return true;
            }
            LOG.errorf("ID token 'nonce' is required but the authentication request 'nonce' is not found in the state cookie", new Object[0]);
            return false;
        }
        return true;
    }

    private static String errorMessage(Throwable t) {
        return t.getCause() != null ? t.getCause().getMessage() : t.getMessage();
    }

    private CodeAuthenticationStateBean getCodeAuthenticationBean(String[] parsedStateCookieValue, TenantConfigContext configContext) {
        if (parsedStateCookieValue.length == 2) {
            CodeAuthenticationStateBean bean = new CodeAuthenticationStateBean();
            OidcTenantConfig.Authentication authentication = configContext.oidcConfig().authentication();
            boolean pkceRequired = authentication.pkceRequired().orElse(false);
            if (!pkceRequired && !authentication.nonceRequired()) {
                JsonObject json = new JsonObject(OidcCommonUtils.base64UrlDecode((String)parsedStateCookieValue[1]));
                bean.setRestorePath(json.getString("restore-path"));
                return bean;
            }
            JsonObject json = null;
            try {
                json = OidcUtils.decryptJson(parsedStateCookieValue[1], configContext.getStateCookieEncryptionKey());
            }
            catch (Exception ex) {
                LOG.errorf("State cookie value for the %s tenant can not be decrypted: %s", (Object)configContext.oidcConfig().tenantId().get(), (Object)ex.getMessage());
                throw new AuthenticationCompletionException((Throwable)ex);
            }
            bean.setRestorePath(json.getString("restore-path"));
            bean.setCodeVerifier(json.getString("code_verifier"));
            bean.setNonce(json.getString("nonce"));
            return bean;
        }
        return null;
    }

    private String generateInternalIdToken(TenantConfigContext context, UserInfo userInfo, String currentIdToken, Long accessTokenExpiresInSecs) {
        JwtClaimsBuilder builder = Jwt.claims();
        if (currentIdToken != null) {
            AbstractJsonObject currentIdTokenJson = new AbstractJsonObject(OidcUtils.decodeJwtContentAsString(currentIdToken)){};
            for (String claim : currentIdTokenJson.getPropertyNames()) {
                if (claim.equals(Claims.iat.name()) || claim.equals(Claims.exp.name())) continue;
                builder.claim(claim, currentIdTokenJson.get(claim));
            }
        }
        if (userInfo != null) {
            builder.claim("userinfo", (Object)userInfo.getJsonObject());
        }
        if (context.oidcConfig().authentication().internalIdTokenLifespan().isPresent()) {
            builder.expiresIn(context.oidcConfig().authentication().internalIdTokenLifespan().get().getSeconds());
        } else if (accessTokenExpiresInSecs != null) {
            builder.expiresIn(accessTokenExpiresInSecs.longValue());
        }
        builder.audience((String)context.oidcConfig().clientId().get());
        JwtSignatureBuilder sigBuilder = builder.jws().header(INTERNAL_IDTOKEN_HEADER, (Object)true);
        String clientOrJwtSecret = OidcCommonUtils.getClientOrJwtSecret((OidcClientCommonConfig.Credentials)context.oidcConfig().credentials());
        if (clientOrJwtSecret != null) {
            LOG.debug((Object)"Signing internal ID token with a configured client secret");
            return sigBuilder.sign(KeyUtils.createSecretKeyFromSecret((String)clientOrJwtSecret));
        }
        if (context.provider().client.getClientJwtKey() instanceof PrivateKey) {
            LOG.debug((Object)"Signing internal ID token with a configured JWT private key");
            return sigBuilder.sign(OidcUtils.createSecretKeyFromDigest(((PrivateKey)context.provider().client.getClientJwtKey()).getEncoded()));
        }
        LOG.debug((Object)"Signing internal ID token with a generated secret key");
        return sigBuilder.sign(context.getInternalIdTokenSigningKey());
    }

    private Uni<Void> processSuccessfulAuthentication(final RoutingContext context, final TenantConfigContext configContext, final AuthorizationCodeTokens tokens, final String idToken, final SecurityIdentity securityIdentity) {
        LOG.debug((Object)"ID token has been verified, removing the existing session cookie if any and creating a new one");
        return this.removeSessionCookie(context, configContext.oidcConfig()).chain((Function)new Function<Void, Uni<? extends Void>>(){

            @Override
            public Uni<? extends Void> apply(Void t) {
                JsonObject idTokenJson = OidcCommonUtils.decodeJwtContent((String)idToken);
                if (!idTokenJson.containsKey("exp") || !idTokenJson.containsKey("iat")) {
                    String error = "ID Token is required to contain 'exp' and 'iat' claims";
                    LOG.error((Object)"ID Token is required to contain 'exp' and 'iat' claims");
                    throw new AuthenticationCompletionException("ID Token is required to contain 'exp' and 'iat' claims");
                }
                long maxAge = idTokenJson.getLong("exp") - idTokenJson.getLong("iat");
                LOG.debugf("ID token is valid for %d seconds", maxAge);
                if (configContext.oidcConfig().token().lifespanGrace().isPresent()) {
                    maxAge += (long)configContext.oidcConfig().token().lifespanGrace().getAsInt();
                }
                if (configContext.oidcConfig().token().refreshExpired() && tokens.getRefreshToken() != null) {
                    maxAge += configContext.oidcConfig().authentication().sessionAgeExtension().getSeconds();
                }
                final long sessionMaxAge = maxAge;
                context.put(CodeAuthenticationMechanism.SESSION_MAX_AGE_PARAM, (Object)maxAge);
                context.put(TenantConfigContext.class.getName(), (Object)configContext);
                CodeAuthenticationMechanism.this.resolver.getBackChannelLogoutTokens().remove(configContext.oidcConfig().tenantId().get());
                return CodeAuthenticationMechanism.this.resolver.getTokenStateManager().createTokenState(context, configContext.oidcConfig(), tokens, CodeAuthenticationMechanism.this.createTokenStateRequestContext).map((Function)new Function<String, Void>(){

                    @Override
                    public Void apply(String cookieValue) {
                        String sessionName = OidcUtils.getSessionCookieName(configContext.oidcConfig());
                        LOG.debugf("Session cookie length for the tenant %s is %d bytes.", (Object)configContext.oidcConfig().tenantId().get(), (Object)cookieValue.length());
                        if (cookieValue.length() > OidcUtils.MAX_COOKIE_VALUE_LENGTH) {
                            LOG.debugf("Session cookie length for the tenant %s is greater than %d bytes. The cookie will be split to chunks to avoid browsers ignoring it. Alternative recommendations: 1. Set 'quarkus.oidc.token-state-manager.split-tokens=true' to have the ID, access and refresh tokens stored in separate cookies. 2. Set 'quarkus.oidc.token-state-manager.strategy=id-refresh-tokens' if you do not need to use the access token as a source of roles or to request UserInfo or propagate it to the downstream services. 3. Decrease the encrypted session cookie's length by enabling a direct encryption algorithm with 'quarkus.oidc.token-state-manager.encryption-algorithm=dir'. 4. Decrease the session cookie's length by disabling its encryption with 'quarkus.oidc.token-state-manager.encryption-required=false' but only if it is considered to be safe in your application's network. 5. Use the 'quarkus-oidc-db-token-state-manager' extension or the 'quarkus-oidc-redis-token-state-manager' extension or register a custom 'quarkus.oidc.TokenStateManager' CDI bean with the alternative priority set to 1 and save the tokens on the server.", (Object)configContext.oidcConfig().tenantId().get(), (Object)OidcUtils.MAX_COOKIE_VALUE_LENGTH);
                            OidcUtils.createChunkedCookie(context, configContext.oidcConfig(), sessionName, cookieValue, sessionMaxAge);
                        } else {
                            OidcUtils.createSessionCookie(context, configContext.oidcConfig(), sessionName, cookieValue, sessionMaxAge);
                        }
                        CodeAuthenticationMechanism.this.fireEvent(SecurityEvent.Type.OIDC_LOGIN, securityIdentity);
                        return null;
                    }
                });
            }
        });
    }

    private void fireEvent(SecurityEvent.Type eventType, SecurityIdentity securityIdentity) {
        if (this.resolver.isSecurityEventObserved()) {
            SecurityEventHelper.fire(this.resolver.getSecurityEvent(), (io.quarkus.security.spi.runtime.SecurityEvent)new SecurityEvent(eventType, securityIdentity));
        }
    }

    private void fireEvent(SecurityEvent.Type eventType, Map<String, Object> properties) {
        if (this.resolver.isSecurityEventObserved()) {
            SecurityEventHelper.fire(this.resolver.getSecurityEvent(), (io.quarkus.security.spi.runtime.SecurityEvent)new SecurityEvent(eventType, properties));
        }
    }

    private static String decryptIdToken(TenantConfigContext configContext, String idToken) {
        if (configContext.oidcConfig().token().decryptIdToken().isPresent() && !configContext.oidcConfig().token().decryptIdToken().get().booleanValue()) {
            return idToken;
        }
        if (configContext.oidcConfig().token().decryptIdToken().orElse(false).booleanValue() || configContext.oidcConfig().token().decryptionKeyLocation().isPresent()) {
            return OidcUtils.decryptToken(configContext, idToken);
        }
        return idToken;
    }

    private String getRedirectPath(OidcTenantConfig oidcConfig, RoutingContext context) {
        OidcTenantConfig.Authentication auth = oidcConfig.authentication();
        return auth.redirectPath().isPresent() ? auth.redirectPath().get() : context.request().path();
    }

    private String generateCodeFlowState(RoutingContext context, TenantConfigContext configContext, String redirectPath, io.vertx.core.MultiMap requestQueryWithoutForwardedParams, String pkceCodeVerifier, String nonce) {
        String uuid = UUID.randomUUID().toString();
        Object cookieValue = uuid;
        OidcTenantConfig.Authentication authentication = configContext.oidcConfig().authentication();
        boolean restorePath = this.isRestorePath(authentication);
        if (restorePath || pkceCodeVerifier != null || nonce != null) {
            extraStateValue = new CodeAuthenticationStateBean();
            if (restorePath) {
                Object requestPath;
                String requestQuery = context.request().query();
                Object object = requestPath = !redirectPath.equals(context.request().path()) || requestQuery != null ? context.request().path() : "";
                if (requestQuery != null) {
                    requestPath = (String)requestPath + QUESTION_MARK;
                    if (requestQueryWithoutForwardedParams == null) {
                        requestPath = (String)requestPath + requestQuery;
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (String requestQueryParam : requestQueryWithoutForwardedParams.names()) {
                            for (String requestQueryParamValue : requestQueryWithoutForwardedParams.getAll(requestQueryParam)) {
                                if (sb.length() > 0) {
                                    sb.append(AMP);
                                }
                                sb.append(requestQueryParam).append(EQ).append(OidcCommonUtils.urlEncode((String)requestQueryParamValue));
                            }
                        }
                        requestPath = (String)requestPath + sb.toString();
                    }
                }
                if (!((String)requestPath).isEmpty()) {
                    extraStateValue.setRestorePath((String)requestPath);
                }
            }
            extraStateValue.setCodeVerifier(pkceCodeVerifier);
            extraStateValue.setNonce(nonce);
            if (!extraStateValue.isEmpty()) {
                cookieValue = (String)cookieValue + COOKIE_DELIM + this.encodeExtraStateValue(extraStateValue, configContext);
            }
        } else if (context.request().query() != null) {
            extraStateValue = new CodeAuthenticationStateBean();
            extraStateValue.setRestorePath(QUESTION_MARK + context.request().query());
            cookieValue = (String)cookieValue + COOKIE_DELIM + this.encodeExtraStateValue(extraStateValue, configContext);
        }
        Object stateCookieNameSuffix = configContext.oidcConfig().authentication().allowMultipleCodeFlows() ? "_" + uuid : "";
        OidcUtils.createCookie(context, configContext.oidcConfig(), CodeAuthenticationMechanism.getStateCookieName(configContext.oidcConfig()) + (String)stateCookieNameSuffix, (String)cookieValue, configContext.oidcConfig().authentication().stateCookieAge().toSeconds());
        return uuid;
    }

    private boolean isRestorePath(OidcTenantConfig.Authentication auth) {
        return auth.restorePathAfterRedirect() || !auth.redirectPath().isPresent();
    }

    private String encodeExtraStateValue(CodeAuthenticationStateBean extraStateValue, TenantConfigContext configContext) {
        JsonObject json = new JsonObject();
        if (extraStateValue.getCodeVerifier() != null || extraStateValue.getNonce() != null) {
            if (extraStateValue.getCodeVerifier() != null) {
                json.put("code_verifier", (Object)extraStateValue.getCodeVerifier());
            }
            if (extraStateValue.getNonce() != null) {
                json.put("nonce", (Object)extraStateValue.getNonce());
            }
            if (extraStateValue.getRestorePath() != null) {
                json.put("restore-path", (Object)extraStateValue.getRestorePath());
            }
            try {
                return OidcUtils.encryptJson(json, configContext.getStateCookieEncryptionKey());
            }
            catch (Exception ex) {
                LOG.errorf("State cookie value for the %s tenant can not be encrypted: %s", (Object)configContext.oidcConfig().tenantId().get(), (Object)ex.getMessage());
                throw new AuthenticationCompletionException((Throwable)ex);
            }
        }
        json.put("restore-path", (Object)extraStateValue.getRestorePath());
        return Base64.getUrlEncoder().withoutPadding().encodeToString(json.encode().getBytes(StandardCharsets.UTF_8));
    }

    private String generatePostLogoutState(RoutingContext context, TenantConfigContext configContext) {
        OidcUtils.removeCookie(context, configContext.oidcConfig(), CodeAuthenticationMechanism.getPostLogoutCookieName(configContext.oidcConfig()));
        return OidcUtils.createCookie(context, configContext.oidcConfig(), CodeAuthenticationMechanism.getPostLogoutCookieName(configContext.oidcConfig()), UUID.randomUUID().toString(), 1800L).getValue();
    }

    private String buildUri(RoutingContext context, boolean forceHttps, String path) {
        if (path.startsWith(HTTP_SCHEME)) {
            return path;
        }
        String authority = URI.create(context.request().absoluteURI()).getAuthority();
        return this.buildUri(context, forceHttps, authority, path);
    }

    private String buildUri(RoutingContext context, boolean forceHttps, String authority, String path) {
        String forwardedPrefixHeader;
        String scheme = forceHttps ? "https" : context.request().scheme();
        String forwardedPrefix = "";
        if (this.resolver.isEnableHttpForwardedPrefix() && (forwardedPrefixHeader = context.request().getHeader("X-Forwarded-Prefix")) != null && !forwardedPrefixHeader.equals("/") && !forwardedPrefixHeader.equals("//") && (forwardedPrefix = forwardedPrefixHeader).endsWith("/")) {
            forwardedPrefix = forwardedPrefix.substring(0, forwardedPrefix.length() - 1);
        }
        return scheme + "://" + authority + forwardedPrefix + path;
    }

    private boolean isRpInitiatedLogout(RoutingContext context, TenantConfigContext configContext) {
        return this.isEqualToRequestPath(configContext.oidcConfig().logout().path(), context, configContext);
    }

    private boolean isEqualToRequestPath(Optional<String> path, RoutingContext context, TenantConfigContext configContext) {
        if (path.isPresent()) {
            return context.request().path().equals(path.get());
        }
        return false;
    }

    private Uni<SecurityIdentity> refreshSecurityIdentity(final TenantConfigContext configContext, final String currentIdToken, String refreshToken, final RoutingContext context, final IdentityProviderManager identityProviderManager, final boolean autoRefresh, final SecurityIdentity fallback) {
        Uni<AuthorizationCodeTokens> refreshedTokensUni = this.refreshTokensUni(configContext, currentIdToken, refreshToken, autoRefresh);
        return refreshedTokensUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<AuthorizationCodeTokens, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final AuthorizationCodeTokens tokens, Throwable t) {
                if (t != null) {
                    LOG.debugf("ID token refresh has failed: %s", (Object)CodeAuthenticationMechanism.errorMessage(t));
                    if (autoRefresh) {
                        if (fallback != null) {
                            LOG.debug((Object)"Using the current SecurityIdentity since the ID token is still valid");
                            return Uni.createFrom().item((Object)fallback);
                        }
                        return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t, CodeAuthenticationMechanism.tokenMap(currentIdToken)));
                    }
                    if (configContext.oidcConfig().authentication().sessionExpiredPath().isPresent()) {
                        return CodeAuthenticationMechanism.this.redirectToSessionExpiredPage(context, configContext);
                    }
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t, CodeAuthenticationMechanism.tokenMap(currentIdToken)));
                }
                context.put("access_token", (Object)tokens.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), (Object)tokens);
                context.put("refresh_token_grant_response", (Object)Boolean.TRUE);
                final String idToken = CodeAuthenticationMechanism.decryptIdToken(configContext, tokens.getIdToken());
                LOG.debug((Object)"Verifying the refreshed ID token");
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(idToken, CodeAuthenticationMechanism.this.isInternalIdToken(idToken, configContext))).call(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<Void> apply(SecurityIdentity identity) {
                        return CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, tokens, idToken, identity);
                    }
                }).map((Function)new Function<SecurityIdentity, SecurityIdentity>(){

                    @Override
                    public SecurityIdentity apply(SecurityIdentity identity) {
                        CodeAuthenticationMechanism.this.fireEvent(autoRefresh ? SecurityEvent.Type.OIDC_SESSION_REFRESHED : SecurityEvent.Type.OIDC_SESSION_EXPIRED_AND_REFRESHED, identity);
                        return identity;
                    }
                }).onFailure().transform((Function)new Function<Throwable, Throwable>(){

                    @Override
                    public Throwable apply(Throwable tInner) {
                        LOG.debugf("Verifying the refreshed ID token failed %s", (Object)CodeAuthenticationMechanism.errorMessage(tInner));
                        return new AuthenticationFailedException(tInner, CodeAuthenticationMechanism.tokenMap(currentIdToken));
                    }
                });
            }
        });
    }

    private Uni<AuthorizationCodeTokens> refreshTokensUni(final TenantConfigContext configContext, final String currentIdToken, final String refreshToken, final boolean autoRefresh) {
        return configContext.provider().refreshTokens(refreshToken).onItem().transform((Function)new Function<AuthorizationCodeTokens, AuthorizationCodeTokens>(){

            @Override
            public AuthorizationCodeTokens apply(AuthorizationCodeTokens tokens) {
                if (tokens.getRefreshToken() == null) {
                    tokens.setRefreshToken(refreshToken);
                }
                if (tokens.getIdToken() == null) {
                    if (CodeAuthenticationMechanism.this.isIdTokenRequired(configContext) || !CodeAuthenticationMechanism.this.isInternalIdToken(currentIdToken, configContext)) {
                        if (!autoRefresh) {
                            LOG.debugf("ID token is not returned in the refresh token grant response, re-authentication is required", new Object[0]);
                            throw new AuthenticationFailedException(CodeAuthenticationMechanism.tokenMap(currentIdToken));
                        }
                        tokens.setIdToken(currentIdToken);
                    } else {
                        tokens.setIdToken(CodeAuthenticationMechanism.this.generateInternalIdToken(configContext, null, currentIdToken, tokens.getAccessTokenExpiresIn()));
                    }
                }
                return tokens;
            }
        });
    }

    private Uni<AuthorizationCodeTokens> getCodeFlowTokensUni(RoutingContext context, TenantConfigContext configContext, String code, String codeVerifier) {
        Optional<String> configuredRedirectPath = configContext.oidcConfig().authentication().redirectPath();
        if (configuredRedirectPath.isPresent()) {
            String requestPath;
            String string = requestPath = configuredRedirectPath.get().startsWith(HTTP_SCHEME) ? this.buildUri(context, configContext.oidcConfig().authentication().forceRedirectHttpsScheme().orElse(false), context.request().path()) : context.request().path();
            if (!configuredRedirectPath.get().equals(requestPath)) {
                LOG.warnf("Token redirect path %s does not match the current request path", (Object)requestPath);
                return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Wrong redirect path"));
            }
        }
        String redirectPath = this.getRedirectPath(configContext.oidcConfig(), context);
        String redirectUriParam = this.buildUri(context, this.isForceHttps(configContext.oidcConfig()), redirectPath);
        LOG.debugf("Token request redirect_uri parameter: %s", (Object)redirectUriParam);
        return configContext.provider().getCodeFlowTokens(code, redirectUriParam, codeVerifier);
    }

    private String buildLogoutRedirectUri(TenantConfigContext configContext, String idToken, RoutingContext context) {
        String logoutPath = configContext.provider().getMetadata().getEndSessionUri();
        Map<String, String> extraParams = configContext.oidcConfig().logout().extraParams();
        StringBuilder logoutUri = new StringBuilder(logoutPath);
        if (idToken != null || configContext.oidcConfig().logout().postLogoutPath().isPresent() || extraParams != null && !extraParams.isEmpty()) {
            logoutUri.append(QUESTION_MARK);
        }
        if (idToken != null) {
            logoutUri.append("id_token_hint").append(EQ).append(idToken);
        }
        if (configContext.oidcConfig().logout().postLogoutPath().isPresent()) {
            logoutUri.append(AMP).append(configContext.oidcConfig().logout().postLogoutUriParam()).append(EQ).append(OidcCommonUtils.urlEncode((String)this.buildUri(context, this.isForceHttps(configContext.oidcConfig()), configContext.oidcConfig().logout().postLogoutPath().get())));
            logoutUri.append(AMP).append("state").append(EQ).append(this.generatePostLogoutState(context, configContext));
        }
        CodeAuthenticationMechanism.addExtraParamsToUri(logoutUri, configContext.oidcConfig().logout().extraParams());
        return logoutUri.toString();
    }

    private static void addExtraParamsToUri(StringBuilder builder, Map<String, String> extraParams) {
        if (extraParams != null) {
            for (Map.Entry<String, String> entry : extraParams.entrySet()) {
                if (entry.getKey().equals("scope")) continue;
                builder.append(AMP).append(entry.getKey()).append(EQ).append(OidcCommonUtils.urlEncode((String)entry.getValue()));
            }
        }
    }

    private boolean isForceHttps(OidcTenantConfig oidcConfig) {
        return oidcConfig.authentication().forceRedirectHttpsScheme().orElse(false);
    }

    private Uni<Void> buildLogoutRedirectUriUni(final RoutingContext context, final TenantConfigContext configContext, final String idToken) {
        return this.removeSessionCookie(context, configContext.oidcConfig()).map((Function)new Function<Void, Void>(){

            @Override
            public Void apply(Void t) {
                if (configContext.oidcConfig().logout().logoutMode() == OidcTenantConfig.Logout.LogoutMode.QUERY) {
                    String logoutUri = CodeAuthenticationMechanism.this.buildLogoutRedirectUri(configContext, idToken, context);
                    LOG.debugf("Logout uri: %s", (Object)logoutUri);
                    throw new AuthenticationRedirectException(CodeAuthenticationMechanism.filterRedirect(context, configContext, logoutUri, Redirect.Location.OIDC_LOGOUT));
                }
                String postLogoutUrl = null;
                String postLogoutState = null;
                if (configContext.oidcConfig().logout().postLogoutPath().isPresent()) {
                    postLogoutUrl = CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(configContext.oidcConfig()), configContext.oidcConfig().logout().postLogoutPath().get());
                    postLogoutState = CodeAuthenticationMechanism.this.generatePostLogoutState(context, configContext);
                }
                String logoutUrl = CodeAuthenticationMechanism.filterRedirect(context, configContext, configContext.provider().getMetadata().getEndSessionUri(), Redirect.Location.OIDC_LOGOUT);
                String formPostLogout = LogoutUtils.createFormPostLogout(configContext.oidcConfig().logout(), logoutUrl, idToken, postLogoutUrl, postLogoutState);
                LOG.debugf("Initiating form post logout", new Object[0]);
                throw new AuthenticationRedirectException(200, formPostLogout);
            }
        });
    }

    private static String getStateCookieName(OidcTenantConfig oidcConfig) {
        return "q_auth" + OidcUtils.getCookieSuffix(oidcConfig);
    }

    private static String getPostLogoutCookieName(OidcTenantConfig oidcConfig) {
        return "q_post_logout" + OidcUtils.getCookieSuffix(oidcConfig);
    }

    private Uni<Void> removeSessionCookie(RoutingContext context, OidcTenantConfig oidcConfig) {
        return OidcUtils.removeSessionCookie(context, oidcConfig, this.resolver.getTokenStateManager());
    }

    private static Map<String, Object> tokenMap(String token) {
        return Map.of("id_token", token);
    }

    private class LogoutCall
    implements Function<SecurityIdentity, Uni<?>> {
        RoutingContext context;
        TenantConfigContext configContext;
        String idToken;

        LogoutCall(RoutingContext context, TenantConfigContext configContext, String idToken) {
            this.context = context;
            this.configContext = configContext;
            this.idToken = idToken;
        }

        @Override
        public Uni<Void> apply(SecurityIdentity identity) {
            if (CodeAuthenticationMechanism.this.isRpInitiatedLogout(this.context, this.configContext)) {
                LOG.debug((Object)"Performing an RP initiated logout");
                CodeAuthenticationMechanism.this.fireEvent(SecurityEvent.Type.OIDC_LOGOUT_RP_INITIATED, identity);
                OidcUtils.setClearSiteData(this.context, this.configContext.oidcConfig());
                return CodeAuthenticationMechanism.this.buildLogoutRedirectUriUni(this.context, this.configContext, this.idToken);
            }
            if (CodeAuthenticationMechanism.this.isBackChannelLogoutPendingAndValid(this.configContext, identity) || CodeAuthenticationMechanism.this.isFrontChannelLogoutValid(this.context, this.configContext, identity)) {
                OidcUtils.setClearSiteData(this.context, this.configContext.oidcConfig());
                return CodeAuthenticationMechanism.this.removeSessionCookie(this.context, this.configContext.oidcConfig()).map((Function)new Function<Void, Void>(){

                    @Override
                    public Void apply(Void t) {
                        throw new LogoutException();
                    }
                });
            }
            return VOID_UNI;
        }
    }
}

