/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcProviderClient;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.common.OidcEndpoint;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.OidcRequestFilter;
import io.quarkus.oidc.common.OidcResponseFilter;
import io.quarkus.oidc.common.runtime.ClientAssertionProvider;
import io.quarkus.oidc.common.runtime.OidcClientRedirectException;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.oidc.runtime.JsonWebKeySet;
import io.quarkus.oidc.runtime.OidcProvider;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.security.credential.TokenCredential;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnItem;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.Closeable;
import java.net.SocketException;
import java.nio.file.Path;
import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.jose4j.lang.UnresolvableKeyException;

public class OidcProviderClientImpl
implements OidcProviderClient,
Closeable {
    private static final Logger LOG = Logger.getLogger(OidcProviderClientImpl.class);
    private static final String AUTHORIZATION_HEADER = String.valueOf(HttpHeaders.AUTHORIZATION);
    private static final String CONTENT_TYPE_HEADER = String.valueOf(HttpHeaders.CONTENT_TYPE);
    private static final String ACCEPT_HEADER = String.valueOf(HttpHeaders.ACCEPT);
    private static final String APPLICATION_X_WWW_FORM_URLENCODED = HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString();
    private static final String APPLICATION_JSON = "application/json";
    private final WebClient client;
    private final Vertx vertx;
    private final OidcConfigurationMetadata metadata;
    private final OidcTenantConfig oidcConfig;
    private final String clientSecretBasicAuthScheme;
    private final String introspectionBasicAuthScheme;
    private final Key clientJwtKey;
    private final boolean jwtBearerAuthentication;
    private final ClientAssertionProvider clientAssertionProvider;
    private final Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters;
    private final Map<OidcEndpoint.Type, List<OidcResponseFilter>> responseFilters;
    private final boolean clientSecretQueryAuthentication;
    private OidcProvider oidcProvider;

    public OidcProviderClientImpl(WebClient client, Vertx vertx, OidcConfigurationMetadata metadata, OidcTenantConfig oidcConfig, Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters, Map<OidcEndpoint.Type, List<OidcResponseFilter>> responseFilters) {
        this.client = client;
        this.vertx = vertx;
        this.metadata = metadata;
        this.oidcConfig = oidcConfig;
        this.clientSecretBasicAuthScheme = OidcCommonUtils.initClientSecretBasicAuth((OidcClientCommonConfig)oidcConfig);
        this.jwtBearerAuthentication = oidcConfig.credentials().jwt().source() == OidcClientCommonConfig.Credentials.Jwt.Source.BEARER;
        this.clientAssertionProvider = this.jwtBearerAuthentication ? OidcProviderClientImpl.createClientAssertionProvider(vertx, oidcConfig) : null;
        this.clientJwtKey = this.jwtBearerAuthentication ? null : OidcCommonUtils.initClientJwtKey((OidcClientCommonConfig)oidcConfig, (boolean)true);
        this.introspectionBasicAuthScheme = OidcProviderClientImpl.initIntrospectionBasicAuthScheme(oidcConfig);
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.clientSecretQueryAuthentication = oidcConfig.credentials().clientSecret().method().orElse(null) == OidcClientCommonConfig.Credentials.Secret.Method.QUERY;
    }

    private static ClientAssertionProvider createClientAssertionProvider(Vertx vertx, OidcTenantConfig oidcConfig) {
        ClientAssertionProvider clientAssertionProvider = new ClientAssertionProvider(vertx, (Path)oidcConfig.credentials().jwt().tokenPath().get());
        if (clientAssertionProvider.getClientAssertion() == null) {
            throw new OIDCException("Cannot find a valid JWT bearer token at path: " + String.valueOf(oidcConfig.credentials().jwt().tokenPath().get()));
        }
        return clientAssertionProvider;
    }

    void setOidcProvider(OidcProvider oidcProvider) {
        this.oidcProvider = oidcProvider;
    }

    private static String initIntrospectionBasicAuthScheme(OidcTenantConfig oidcConfig) {
        if (oidcConfig.introspectionCredentials().name().isPresent() && oidcConfig.introspectionCredentials().secret().isPresent()) {
            return OidcCommonUtils.basicSchemeValue((String)oidcConfig.introspectionCredentials().name().get(), (String)oidcConfig.introspectionCredentials().secret().get());
        }
        return null;
    }

    OidcConfigurationMetadata getMetadata() {
        return this.metadata;
    }

    Uni<JsonWebKeySet> getJsonWebKeySet(OidcRequestContextProperties contextProperties) {
        final OidcRequestContextProperties requestProps = this.getRequestProps(contextProperties);
        return this.doGetJsonWebKeySet(requestProps, List.of()).onFailure(OidcCommonUtils.validOidcClientRedirect((String)this.metadata.getJsonWebKeySetUri())).recoverWithUni((Function)new Function<Throwable, Uni<? extends JsonWebKeySet>>(){

            @Override
            public Uni<JsonWebKeySet> apply(Throwable t) {
                OidcClientRedirectException ex = (OidcClientRedirectException)t;
                return OidcProviderClientImpl.this.doGetJsonWebKeySet(requestProps, ex.getCookies());
            }
        });
    }

    private Uni<JsonWebKeySet> doGetJsonWebKeySet(OidcRequestContextProperties requestProps, List<String> cookies) {
        LOG.debugf("Get verification JWT Key Set at %s", (Object)this.metadata.getJsonWebKeySetUri());
        HttpRequest request = this.client.getAbs(this.metadata.getJsonWebKeySetUri());
        if (!cookies.isEmpty()) {
            request.putHeader(OidcCommonUtils.COOKIE_REQUEST_HEADER, cookies);
        }
        return OidcCommonUtils.sendRequest((Vertx)this.vertx, this.filterHttpRequest(requestProps, OidcEndpoint.Type.JWKS, (HttpRequest<Buffer>)request, null), (boolean)this.oidcConfig.useBlockingDnsLookup()).onItem().transform(resp -> this.getJsonWebKeySet(requestProps, (HttpResponse<Buffer>)resp));
    }

    @Override
    public Uni<UserInfo> getUserInfo(final String accessToken) {
        final OidcRequestContextProperties requestProps = this.getRequestProps(null, null);
        Uni response = this.doGetUserInfo(requestProps, accessToken, List.of()).onFailure(OidcCommonUtils.validOidcClientRedirect((String)this.metadata.getUserInfoUri())).recoverWithUni((Function)new Function<Throwable, Uni<? extends UserInfoResponse>>(){

            @Override
            public Uni<UserInfoResponse> apply(Throwable t) {
                OidcClientRedirectException ex = (OidcClientRedirectException)t;
                return OidcProviderClientImpl.this.doGetUserInfo(requestProps, accessToken, ex.getCookies());
            }
        });
        return response.onItem().transformToUni((Function)new Function<UserInfoResponse, Uni<? extends UserInfo>>(){

            @Override
            public Uni<UserInfo> apply(UserInfoResponse response) {
                if (OidcUtils.isApplicationJwtContentType(response.contentType())) {
                    if (OidcProviderClientImpl.this.oidcConfig.jwks().resolveEarly()) {
                        try {
                            LOG.debugf("Verifying the signed UserInfo with the local JWK keys: %s", (Object)response.data());
                            return Uni.createFrom().item((Object)new UserInfo(OidcProviderClientImpl.this.oidcProvider.verifyJwtToken((String)response.data(), (boolean)true, (boolean)false, null).localVerificationResult.encode()));
                        }
                        catch (Throwable t) {
                            if (t.getCause() instanceof UnresolvableKeyException) {
                                LOG.debug((Object)"No matching JWK key is found, refreshing and repeating the signed UserInfo verification");
                                return OidcProviderClientImpl.this.oidcProvider.refreshJwksAndVerifyJwtToken(response.data(), true, false, null).onItem().transform(v -> new UserInfo(v.localVerificationResult.encode()));
                            }
                            LOG.debugf("Signed UserInfo verification has failed: %s", (Object)t.getMessage());
                            return Uni.createFrom().failure(t);
                        }
                    }
                    return OidcProviderClientImpl.this.oidcProvider.getKeyResolverAndVerifyJwtToken(new TokenCredential(response.data(), "userinfo"), true, false, null, true).onItem().transform(v -> new UserInfo(v.localVerificationResult.encode()));
                }
                return Uni.createFrom().item((Object)new UserInfo(response.data()));
            }
        });
    }

    private Uni<UserInfoResponse> doGetUserInfo(OidcRequestContextProperties requestProps, String token, List<String> cookies) {
        LOG.debugf("Get UserInfo on: %s auth: %s", (Object)this.metadata.getUserInfoUri(), (Object)("Bearer " + token));
        HttpRequest request = this.client.getAbs(this.metadata.getUserInfoUri());
        if (!cookies.isEmpty()) {
            request.putHeader(OidcCommonUtils.COOKIE_REQUEST_HEADER, cookies);
        }
        return OidcCommonUtils.sendRequest((Vertx)this.vertx, (HttpRequest)this.filterHttpRequest(requestProps, OidcEndpoint.Type.USERINFO, (HttpRequest<Buffer>)request, null).putHeader(AUTHORIZATION_HEADER, "Bearer " + token), (boolean)this.oidcConfig.useBlockingDnsLookup()).onItem().transform(resp -> this.getUserInfo(requestProps, (HttpResponse<Buffer>)resp));
    }

    @Override
    public Uni<TokenIntrospection> introspectAccessToken(String token) {
        MultiMap introspectionParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        introspectionParams.add("token", token);
        introspectionParams.add("token_type_hint", "access_token");
        OidcRequestContextProperties requestProps = this.getRequestProps(null, null);
        return this.getHttpResponse(requestProps, this.metadata.getIntrospectionUri(), introspectionParams, true).transform(resp -> this.getTokenIntrospection(requestProps, (HttpResponse<Buffer>)resp));
    }

    private JsonWebKeySet getJsonWebKeySet(OidcRequestContextProperties requestProps, HttpResponse<Buffer> resp) {
        return new JsonWebKeySet(this.getString(requestProps, this.metadata.getJsonWebKeySetUri(), resp, OidcEndpoint.Type.JWKS));
    }

    Uni<AuthorizationCodeTokens> getAuthorizationCodeTokens(String code, String redirectUri, String codeVerifier) {
        MultiMap codeGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        codeGrantParams.add("grant_type", "authorization_code");
        codeGrantParams.add("code", code);
        codeGrantParams.add("redirect_uri", redirectUri);
        if (codeVerifier != null) {
            codeGrantParams.add("code_verifier", codeVerifier);
        }
        if (this.oidcConfig.codeGrant().extraParams() != null) {
            codeGrantParams.addAll(this.oidcConfig.codeGrant().extraParams());
        }
        OidcRequestContextProperties requestProps = this.getRequestProps("authorization_code");
        return this.getHttpResponse(requestProps, this.metadata.getTokenUri(), codeGrantParams, false).transform(resp -> this.getAuthorizationCodeTokens(requestProps, (HttpResponse<Buffer>)resp));
    }

    Uni<AuthorizationCodeTokens> refreshAuthorizationCodeTokens(String refreshToken) {
        MultiMap refreshGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        refreshGrantParams.add("grant_type", "refresh_token");
        refreshGrantParams.add("refresh_token", refreshToken);
        OidcRequestContextProperties requestProps = this.getRequestProps("refresh_token");
        return this.getHttpResponse(requestProps, this.metadata.getTokenUri(), refreshGrantParams, false).transform(resp -> this.getAuthorizationCodeTokens(requestProps, (HttpResponse<Buffer>)resp));
    }

    @Override
    public Uni<Boolean> revokeAccessToken(String accessToken) {
        return this.revokeToken(accessToken, "access_token");
    }

    @Override
    public Uni<Boolean> revokeRefreshToken(String refreshToken) {
        return this.revokeToken(refreshToken, "refresh_token");
    }

    private Uni<Boolean> revokeToken(String token, String tokenTypeHint) {
        if (this.metadata.getRevocationUri() != null) {
            OidcRequestContextProperties requestProps = this.getRequestProps(null, null);
            MultiMap tokenRevokeParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
            tokenRevokeParams.set("token", token);
            tokenRevokeParams.set("token_type_hint", tokenTypeHint);
            return this.getHttpResponse(requestProps, this.metadata.getRevocationUri(), tokenRevokeParams, false).transform(resp -> this.toRevokeResponse(requestProps, (HttpResponse<Buffer>)resp));
        }
        LOG.debugf("The %s token can not be revoked because the revocation endpoint URL is not set", (Object)tokenTypeHint);
        return Uni.createFrom().item((Object)false);
    }

    private Boolean toRevokeResponse(OidcRequestContextProperties requestProps, HttpResponse<Buffer> resp) {
        OidcCommonUtils.filterHttpResponse((OidcRequestContextProperties)requestProps, resp, this.responseFilters, (OidcEndpoint.Type)OidcEndpoint.Type.TOKEN_REVOCATION);
        return resp.statusCode() != 503;
    }

    private UniOnItem<HttpResponse<Buffer>> getHttpResponse(OidcRequestContextProperties requestProps, String uri, MultiMap formBody, boolean introspect) {
        HttpRequest request = this.client.postAbs(uri);
        Buffer buffer = null;
        if (!this.clientSecretQueryAuthentication) {
            request.putHeader(CONTENT_TYPE_HEADER, APPLICATION_X_WWW_FORM_URLENCODED);
            request.putHeader(ACCEPT_HEADER, APPLICATION_JSON);
            if (introspect && this.introspectionBasicAuthScheme != null) {
                request.putHeader(AUTHORIZATION_HEADER, this.introspectionBasicAuthScheme);
                if (this.oidcConfig.clientId().isPresent() && this.oidcConfig.introspectionCredentials().includeClientId()) {
                    formBody.set("client_id", (String)this.oidcConfig.clientId().get());
                }
            } else if (this.clientSecretBasicAuthScheme != null) {
                request.putHeader(AUTHORIZATION_HEADER, this.clientSecretBasicAuthScheme);
            } else if (this.jwtBearerAuthentication) {
                String clientAssertion = this.clientAssertionProvider.getClientAssertion();
                if (clientAssertion == null) {
                    throw new OIDCException(String.format("Cannot get token for tenant '%s' because a JWT bearer client_assertion is not available", this.oidcConfig.tenantId().get()));
                }
                formBody.add("client_assertion", clientAssertion);
                formBody.add("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            } else if (this.clientJwtKey != null) {
                Iterator<Map.Entry<String, String>> jwt = OidcCommonUtils.signJwtWithKey((OidcClientCommonConfig)this.oidcConfig, (String)this.metadata.getTokenUri(), (Key)this.clientJwtKey);
                if (OidcCommonUtils.isClientSecretPostJwtAuthRequired((OidcClientCommonConfig.Credentials)this.oidcConfig.credentials())) {
                    formBody.add("client_id", (String)this.oidcConfig.clientId().get());
                    formBody.add("client_secret", jwt);
                } else {
                    formBody.add("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
                    formBody.add("client_assertion", jwt);
                }
            } else if (OidcCommonUtils.isClientSecretPostAuthRequired((OidcClientCommonConfig.Credentials)this.oidcConfig.credentials())) {
                formBody.add("client_id", (String)this.oidcConfig.clientId().get());
                formBody.add("client_secret", OidcCommonUtils.clientSecret((OidcClientCommonConfig.Credentials)this.oidcConfig.credentials()));
            } else {
                formBody.add("client_id", (String)this.oidcConfig.clientId().get());
            }
            buffer = OidcCommonUtils.encodeForm((MultiMap)formBody);
        } else {
            formBody.add("client_id", (String)this.oidcConfig.clientId().get());
            formBody.add("client_secret", OidcCommonUtils.clientSecret((OidcClientCommonConfig.Credentials)this.oidcConfig.credentials()));
            for (Map.Entry entry : formBody) {
                request.addQueryParam((String)entry.getKey(), OidcCommonUtils.urlEncode((String)((String)entry.getValue())));
            }
            request.putHeader(ACCEPT_HEADER, APPLICATION_JSON);
            buffer = Buffer.buffer();
        }
        if (this.oidcConfig.codeGrant().headers() != null) {
            for (Map.Entry<String, String> headerEntry : this.oidcConfig.codeGrant().headers().entrySet()) {
                request.putHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("%s token: %s params: %s headers: %s", new Object[]{introspect ? "Introspect" : "Get", this.metadata.getTokenUri(), formBody, request.headers()});
        }
        OidcEndpoint.Type endpoint = introspect ? OidcEndpoint.Type.INTROSPECTION : OidcEndpoint.Type.TOKEN;
        Uni response = this.filterHttpRequest(requestProps, endpoint, (HttpRequest<Buffer>)request, buffer).sendBuffer(OidcCommonUtils.getRequestBuffer((OidcRequestContextProperties)requestProps, (Buffer)buffer)).onFailure(SocketException.class).retry().atMost((long)this.oidcConfig.connectionRetryCount()).onFailure().transform(Throwable::getCause);
        return response.onItem();
    }

    private AuthorizationCodeTokens getAuthorizationCodeTokens(OidcRequestContextProperties requestProps, HttpResponse<Buffer> resp) {
        JsonObject json = this.getJsonObject(requestProps, this.metadata.getTokenUri(), resp, OidcEndpoint.Type.TOKEN);
        String idToken = json.getString("id_token");
        String accessToken = json.getString("access_token");
        String refreshToken = json.getString("refresh_token");
        Long tokenExpiresIn = null;
        Object tokenExpiresInObj = json.getValue("expires_in");
        if (tokenExpiresInObj != null) {
            tokenExpiresIn = tokenExpiresInObj instanceof Number ? ((Number)tokenExpiresInObj).longValue() : Long.parseLong(tokenExpiresInObj.toString());
        }
        String accessTokenScope = json.getString("scope");
        return new AuthorizationCodeTokens(idToken, accessToken, refreshToken, tokenExpiresIn, accessTokenScope);
    }

    private UserInfoResponse getUserInfo(OidcRequestContextProperties requestProps, HttpResponse<Buffer> resp) {
        return new UserInfoResponse(resp.getHeader(CONTENT_TYPE_HEADER), this.getString(requestProps, this.metadata.getUserInfoUri(), resp, OidcEndpoint.Type.USERINFO));
    }

    private TokenIntrospection getTokenIntrospection(OidcRequestContextProperties requestProps, HttpResponse<Buffer> resp) {
        return new TokenIntrospection(this.getString(requestProps, this.metadata.getIntrospectionUri(), resp, OidcEndpoint.Type.INTROSPECTION));
    }

    private JsonObject getJsonObject(OidcRequestContextProperties requestProps, String requestUri, HttpResponse<Buffer> resp, OidcEndpoint.Type endpoint) {
        Buffer buffer = OidcCommonUtils.filterHttpResponse((OidcRequestContextProperties)requestProps, resp, this.responseFilters, (OidcEndpoint.Type)endpoint);
        if (resp.statusCode() == 200) {
            LOG.debugf("Request succeeded: %s", (Object)resp.bodyAsJsonObject());
            return buffer.toJsonObject();
        }
        if (resp.statusCode() == 302) {
            throw OidcCommonUtils.createOidcClientRedirectException(resp);
        }
        throw OidcProviderClientImpl.responseException(requestUri, resp, buffer);
    }

    private String getString(OidcRequestContextProperties requestProps, String requestUri, HttpResponse<Buffer> resp, OidcEndpoint.Type endpoint) {
        Buffer buffer = OidcCommonUtils.filterHttpResponse((OidcRequestContextProperties)requestProps, resp, this.responseFilters, (OidcEndpoint.Type)endpoint);
        if (resp.statusCode() == 200) {
            LOG.debugf("Request succeeded: %s", (Object)resp.bodyAsString());
            return buffer.toString();
        }
        if (resp.statusCode() == 302) {
            throw OidcCommonUtils.createOidcClientRedirectException(resp);
        }
        throw OidcProviderClientImpl.responseException(requestUri, resp, buffer);
    }

    private static OIDCException responseException(String requestUri, HttpResponse<Buffer> resp, Buffer buffer) {
        String errorMessage = buffer.toString();
        if (errorMessage != null && !errorMessage.isEmpty()) {
            LOG.errorf("Request %s has failed: status: %d, error message: %s", (Object)requestUri, (Object)resp.statusCode(), (Object)errorMessage);
            throw new OIDCException(errorMessage);
        }
        LOG.errorf("Request %s has failed: status: %d", (Object)requestUri, (Object)resp.statusCode());
        throw new OIDCException("Error status:" + resp.statusCode());
    }

    @Override
    public void close() {
        this.client.close();
        if (this.clientAssertionProvider != null) {
            this.clientAssertionProvider.close();
        }
    }

    Key getClientJwtKey() {
        return this.clientJwtKey;
    }

    private HttpRequest<Buffer> filterHttpRequest(OidcRequestContextProperties requestProps, OidcEndpoint.Type endpointType, HttpRequest<Buffer> request, Buffer body) {
        if (!this.requestFilters.isEmpty()) {
            OidcRequestFilter.OidcRequestContext context = new OidcRequestFilter.OidcRequestContext(request, body, requestProps);
            for (OidcRequestFilter filter : OidcCommonUtils.getMatchingOidcRequestFilters(this.requestFilters, (OidcEndpoint.Type)endpointType)) {
                filter.filter(context);
            }
        }
        return request;
    }

    private OidcRequestContextProperties getRequestProps(String grantType) {
        return this.getRequestProps(null, grantType);
    }

    private OidcRequestContextProperties getRequestProps(OidcRequestContextProperties contextProperties) {
        return this.getRequestProps(contextProperties, null);
    }

    private OidcRequestContextProperties getRequestProps(OidcRequestContextProperties contextProperties, String grantType) {
        if (this.requestFilters.isEmpty() && this.responseFilters.isEmpty()) {
            return null;
        }
        HashMap<String, Object> newProperties = contextProperties == null ? new HashMap<String, Object>() : new HashMap(contextProperties.getAll());
        newProperties.put("tenant-id", this.oidcConfig.tenantId().orElse("Default"));
        newProperties.put(OidcConfigurationMetadata.class.getName(), this.metadata);
        if (grantType != null) {
            newProperties.put("grant_type", grantType);
        }
        return new OidcRequestContextProperties(newProperties);
    }

    Vertx getVertx() {
        return this.vertx;
    }

    public WebClient getWebClient() {
        return this.client;
    }

    record UserInfoResponse(String contentType, String data) {
    }
}

