/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcProviderClient;
import io.quarkus.oidc.runtime.OidcProviderClientImpl;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;

@RequestScoped
public class OidcConfigurationAndProviderProducer {
    @Inject
    TenantConfigBean tenantConfig;
    @Inject
    SecurityIdentity identity;

    @Produces
    @RequestScoped
    OidcConfigurationMetadata produceMetadata() {
        OidcConfigurationMetadata configMetadata = (OidcConfigurationMetadata)OidcUtils.getAttribute(this.identity, "configuration-metadata");
        if (configMetadata == null && this.tenantConfig.getDefaultTenant().oidcConfig().tenantEnabled()) {
            configMetadata = this.tenantConfig.getDefaultTenant().provider().getMetadata();
        }
        if (configMetadata == null) {
            throw new OIDCException("OidcConfigurationMetadata can not be injected");
        }
        return configMetadata;
    }

    @Produces
    @RequestScoped
    OidcProviderClient produceProviderClient() {
        OidcProviderClientImpl client = null;
        String tenantId = (String)OidcUtils.getAttribute(this.identity, "tenant-id");
        if (tenantId != null) {
            if ("Default".equals(tenantId)) {
                return this.tenantConfig.getDefaultTenant().getOidcProviderClient();
            }
            TenantConfigContext context = this.tenantConfig.getStaticTenant(tenantId);
            if (context == null) {
                context = this.tenantConfig.getDynamicTenant(tenantId);
            }
            if (context != null) {
                client = context.getOidcProviderClient();
            }
        }
        if (client == null) {
            throw new OIDCException("OidcProviderClient can not be injected");
        }
        return client;
    }
}

