/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.devui;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class OidcDevUiRpcSvcPropertiesBean {
    private final String authorizationUrl;
    private final String tokenUrl;
    private final String logoutUrl;
    private final Duration webClientTimeout;
    private final Map<String, Map<String, String>> grantOptions;
    private final Map<String, String> oidcUsers;
    private final String oidcProviderName;
    private final String oidcApplicationType;
    private final String oidcGrantType;
    private final boolean introspectionIsAvailable;
    private final String keycloakAdminUrl;
    private final List<String> keycloakRealms;
    private final boolean swaggerIsAvailable;
    private final boolean graphqlIsAvailable;
    private final String swaggerUiPath;
    private final String graphqlUiPath;
    private final boolean alwaysLogoutUserInDevUiOnReload;
    private final String propertiesStateId;

    OidcDevUiRpcSvcPropertiesBean(String authorizationUrl, String tokenUrl, String logoutUrl, Duration webClientTimeout, Map<String, Map<String, String>> grantOptions, Map<String, String> oidcUsers, String oidcProviderName, String oidcApplicationType, String oidcGrantType, boolean introspectionIsAvailable, String keycloakAdminUrl, List<String> keycloakRealms, boolean swaggerIsAvailable, boolean graphqlIsAvailable, String swaggerUiPath, String graphqlUiPath, boolean alwaysLogoutUserInDevUiOnReload) {
        this.authorizationUrl = authorizationUrl;
        this.tokenUrl = tokenUrl;
        this.logoutUrl = logoutUrl;
        this.webClientTimeout = webClientTimeout;
        this.grantOptions = Map.copyOf(grantOptions);
        this.oidcUsers = oidcUsers == null || oidcUsers.isEmpty() ? Map.of() : Map.copyOf(oidcUsers);
        this.oidcProviderName = oidcProviderName;
        this.oidcApplicationType = oidcApplicationType;
        this.oidcGrantType = oidcGrantType;
        this.introspectionIsAvailable = introspectionIsAvailable;
        this.keycloakAdminUrl = keycloakAdminUrl;
        this.keycloakRealms = keycloakRealms;
        this.swaggerIsAvailable = swaggerIsAvailable;
        this.graphqlIsAvailable = graphqlIsAvailable;
        this.swaggerUiPath = swaggerUiPath;
        this.graphqlUiPath = graphqlUiPath;
        this.alwaysLogoutUserInDevUiOnReload = alwaysLogoutUserInDevUiOnReload;
        this.propertiesStateId = Long.toString(UUID.randomUUID().getLeastSignificantBits());
    }

    String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    String getTokenUrl() {
        return this.tokenUrl;
    }

    String getLogoutUrl() {
        return this.logoutUrl;
    }

    Duration getWebClientTimeout() {
        return this.webClientTimeout;
    }

    Map<String, String> getCodeGrantOptions() {
        return this.grantOptions.get("code");
    }

    Map<String, String> getPasswordGrantOptions() {
        return this.grantOptions.get("password");
    }

    Map<String, String> getClientCredGrantOptions() {
        return this.grantOptions.get("client");
    }

    Map<String, String> getOidcUsers() {
        return this.oidcUsers;
    }

    boolean isIntrospectionIsAvailable() {
        return this.introspectionIsAvailable;
    }

    String getKeycloakAdminUrl() {
        return this.keycloakAdminUrl;
    }

    List<String> getKeycloakRealms() {
        return this.keycloakRealms;
    }

    boolean isSwaggerIsAvailable() {
        return this.swaggerIsAvailable;
    }

    boolean isGraphqlIsAvailable() {
        return this.graphqlIsAvailable;
    }

    String getSwaggerUiPath() {
        return this.swaggerUiPath;
    }

    String getGraphqlUiPath() {
        return this.graphqlUiPath;
    }

    String getOidcProviderName() {
        return this.oidcProviderName;
    }

    String getOidcApplicationType() {
        return this.oidcApplicationType;
    }

    String getOidcGrantType() {
        return this.oidcGrantType;
    }

    boolean isAlwaysLogoutUserInDevUiOnReload() {
        return this.alwaysLogoutUserInDevUiOnReload;
    }

    String getPropertiesStateId() {
        return this.propertiesStateId;
    }
}

