/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.devui;

import io.quarkus.oidc.runtime.devui.OidcDevLoginObserver;
import io.quarkus.oidc.runtime.devui.OidcDevServicesUtils;
import io.quarkus.oidc.runtime.devui.OidcDevUiRpcSvcPropertiesBean;
import io.quarkus.oidc.runtime.devui.OidcDevUiRuntimePropertiesDTO;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import jakarta.inject.Inject;
import org.eclipse.microprofile.config.ConfigProvider;

public class OidcDevJsonRpcService {
    private OidcDevUiRpcSvcPropertiesBean props;
    private VertxHttpConfig httpConfig;
    @Inject
    OidcDevLoginObserver oidcDevTokensObserver;
    @Inject
    Vertx vertx;

    @NonBlocking
    public OidcDevUiRuntimePropertiesDTO getProperties() {
        return new OidcDevUiRuntimePropertiesDTO(this.props.getAuthorizationUrl(), this.props.getTokenUrl(), this.props.getLogoutUrl(), ConfigProvider.getConfig(), this.httpConfig.port(), this.props.getOidcProviderName(), this.props.getOidcApplicationType(), this.props.getOidcGrantType(), this.props.isIntrospectionIsAvailable(), this.props.getKeycloakAdminUrl(), this.props.getKeycloakRealms(), this.props.isSwaggerIsAvailable(), this.props.isGraphqlIsAvailable(), this.props.getSwaggerUiPath(), this.props.getGraphqlUiPath(), this.props.isAlwaysLogoutUserInDevUiOnReload(), this.props.getPropertiesStateId());
    }

    public Uni<String> exchangeCodeForTokens(String tokenUrl, String clientId, String clientSecret, String authorizationCode, String redirectUri) {
        return OidcDevServicesUtils.getTokens(tokenUrl, clientId, clientSecret, authorizationCode, redirectUri, this.vertx, this.props.getCodeGrantOptions()).ifNoItem().after(this.props.getWebClientTimeout()).fail();
    }

    public Uni<Integer> testServiceWithToken(String token, String serviceUrl) {
        return OidcDevServicesUtils.testServiceWithToken(serviceUrl, token, this.vertx).ifNoItem().after(this.props.getWebClientTimeout()).fail();
    }

    public Uni<String> testServiceWithPassword(String tokenUrl, String serviceUrl, String clientId, String clientSecret, String username, String password) {
        return OidcDevServicesUtils.testServiceWithPassword(tokenUrl, serviceUrl, clientId, clientSecret, username, password, this.vertx, this.props.getWebClientTimeout(), this.props.getPasswordGrantOptions(), this.props.getOidcUsers());
    }

    public Uni<String> testServiceWithClientCred(String tokenUrl, String serviceUrl, String clientId, String clientSecret) {
        return OidcDevServicesUtils.testServiceWithClientCred(tokenUrl, serviceUrl, clientId, clientSecret, this.vertx, this.props.getWebClientTimeout(), this.props.getClientCredGrantOptions());
    }

    public Multi<Boolean> streamOidcLoginEvent() {
        return this.oidcDevTokensObserver.streamOidcLoginEvent();
    }

    void hydrate(OidcDevUiRpcSvcPropertiesBean properties, VertxHttpConfig httpConfig) {
        this.props = properties;
        this.httpConfig = httpConfig;
    }
}

