/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.builders;

import io.quarkus.oidc.OidcTenantConfigBuilder;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class LogoutConfigBuilder {
    private final OidcTenantConfigBuilder builder;
    private final Map<String, String> extraParams = new HashMap<String, String>();
    private Optional<String> path;
    private Optional<String> postLogoutPath;
    private String postLogoutUriParam;
    private OidcTenantConfig.Backchannel backchannel;
    private OidcTenantConfig.Frontchannel frontchannel;

    public LogoutConfigBuilder() {
        this(new OidcTenantConfigBuilder());
    }

    public LogoutConfigBuilder(OidcTenantConfigBuilder builder) {
        this.builder = Objects.requireNonNull(builder);
        OidcTenantConfig.Logout logout = builder.getLogout();
        if (!logout.extraParams().isEmpty()) {
            this.extraParams.putAll(logout.extraParams());
        }
        this.path = logout.path();
        this.postLogoutPath = logout.postLogoutPath();
        this.postLogoutUriParam = logout.postLogoutUriParam();
        this.backchannel = logout.backchannel();
        this.frontchannel = logout.frontchannel();
    }

    public LogoutConfigBuilder frontchannelPath(String path) {
        this.frontchannel = new FrontchannelImpl(Optional.ofNullable(path));
        return this;
    }

    public LogoutConfigBuilder path(String path) {
        this.path = Optional.ofNullable(path);
        return this;
    }

    public LogoutConfigBuilder postLogoutPath(String postLogoutPath) {
        this.postLogoutPath = Optional.ofNullable(postLogoutPath);
        return this;
    }

    public LogoutConfigBuilder postLogoutUriParam(String postLogoutUriParam) {
        this.postLogoutUriParam = Objects.requireNonNull(postLogoutUriParam);
        return this;
    }

    public LogoutConfigBuilder extraParam(String extraParamKey, String extraParamValue) {
        Objects.requireNonNull(extraParamKey);
        Objects.requireNonNull(extraParamValue);
        this.extraParams.put(extraParamKey, extraParamValue);
        return this;
    }

    public LogoutConfigBuilder extraParams(Map<String, String> extraParams) {
        if (extraParams != null) {
            this.extraParams.putAll(extraParams);
        }
        return this;
    }

    public LogoutConfigBuilder backchannel(OidcTenantConfig.Backchannel backchannel) {
        this.backchannel = Objects.requireNonNull(backchannel);
        return this;
    }

    public BackchannelBuilder backchannel() {
        return new BackchannelBuilder(this);
    }

    public OidcTenantConfigBuilder end() {
        return this.builder.logout(this.build());
    }

    public OidcTenantConfig.Logout build() {
        return new LogoutImpl(this.path, this.postLogoutPath, this.postLogoutUriParam, Map.copyOf(this.extraParams), this.backchannel, this.frontchannel);
    }

    private record FrontchannelImpl(Optional<String> path) implements OidcTenantConfig.Frontchannel
    {
    }

    public static final class BackchannelBuilder {
        private final LogoutConfigBuilder logoutBuilder;
        private Optional<String> path;
        private int tokenCacheSize;
        private Duration tokenCacheTimeToLive;
        private Optional<Duration> cleanUpTimerInterval;
        private String logoutTokenKey;

        public BackchannelBuilder() {
            this(new LogoutConfigBuilder());
        }

        public BackchannelBuilder(LogoutConfigBuilder logoutBuilder) {
            this.logoutBuilder = Objects.requireNonNull(logoutBuilder);
            OidcTenantConfig.Backchannel backchannel = logoutBuilder.backchannel;
            this.path = backchannel.path();
            this.tokenCacheSize = backchannel.tokenCacheSize();
            this.tokenCacheTimeToLive = backchannel.tokenCacheTimeToLive();
            this.cleanUpTimerInterval = backchannel.cleanUpTimerInterval();
            this.logoutTokenKey = backchannel.logoutTokenKey();
        }

        public BackchannelBuilder cleanUpTimerInterval(Duration cleanUpTimerInterval) {
            this.cleanUpTimerInterval = Optional.ofNullable(cleanUpTimerInterval);
            return this;
        }

        public BackchannelBuilder logoutTokenKey(String logoutTokenKey) {
            this.logoutTokenKey = Objects.requireNonNull(logoutTokenKey);
            return this;
        }

        public BackchannelBuilder tokenCacheTimeToLive(Duration tokenCacheTimeToLive) {
            this.tokenCacheTimeToLive = Objects.requireNonNull(tokenCacheTimeToLive);
            return this;
        }

        public BackchannelBuilder tokenCacheSize(int tokenCacheSize) {
            this.tokenCacheSize = tokenCacheSize;
            return this;
        }

        public BackchannelBuilder path(String path) {
            this.path = Optional.ofNullable(path);
            return this;
        }

        public OidcTenantConfigBuilder endLogout() {
            return this.end().end();
        }

        public LogoutConfigBuilder end() {
            return this.logoutBuilder.backchannel(this.build());
        }

        public OidcTenantConfig.Backchannel build() {
            return new BackchannelImpl(this.path, this.tokenCacheSize, this.tokenCacheTimeToLive, this.cleanUpTimerInterval, this.logoutTokenKey);
        }

        private record BackchannelImpl(Optional<String> path, int tokenCacheSize, Duration tokenCacheTimeToLive, Optional<Duration> cleanUpTimerInterval, String logoutTokenKey) implements OidcTenantConfig.Backchannel
        {
        }
    }

    private record LogoutImpl(Optional<String> path, Optional<String> postLogoutPath, String postLogoutUriParam, Map<String, String> extraParams, OidcTenantConfig.Backchannel backchannel, OidcTenantConfig.Frontchannel frontchannel) implements OidcTenantConfig.Logout
    {
    }
}

