/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.devservices.keycloak.KeycloakAdminPageBuildItem;
import io.quarkus.devservices.keycloak.KeycloakDevServicesConfigBuildItem;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.oidc.deployment.DevUiConfig;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.AbstractDevUIProcessor;
import io.quarkus.oidc.runtime.dev.ui.OidcDevJsonRpcService;
import io.quarkus.oidc.runtime.dev.ui.OidcDevLoginObserver;
import io.quarkus.oidc.runtime.dev.ui.OidcDevUiRecorder;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KeycloakDevUIProcessor
extends AbstractDevUIProcessor {
    OidcBuildTimeConfig oidcConfig;

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsLocalDevelopment.class})
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    void produceProviderComponent(Optional<KeycloakDevServicesConfigBuildItem> configProps, BuildProducer<KeycloakAdminPageBuildItem> keycloakAdminPageProducer, VertxHttpConfig httpConfig, OidcDevUiRecorder recorder, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, BeanContainerBuildItem beanContainer, Capabilities capabilities) {
        String keycloakAdminUrl = KeycloakDevServicesConfigBuildItem.getKeycloakUrl(configProps);
        if (keycloakAdminUrl != null) {
            String realmUrl = (String)configProps.get().getConfig().get("quarkus.oidc.auth-server-url");
            Map users = (Map)configProps.get().getProperties().get("oidc.users");
            List keycloakRealms = (List)configProps.get().getProperties().get("keycloak.realms");
            CardPageBuildItem cardPageBuildItem = KeycloakDevUIProcessor.createProviderWebComponent(recorder, capabilities, "Keycloak", KeycloakDevUIProcessor.getApplicationType(), this.oidcConfig.devui().grant().type().orElse(DevUiConfig.Grant.Type.CODE).getGrantType(), realmUrl + "/protocol/openid-connect/auth", realmUrl + "/protocol/openid-connect/token", realmUrl + "/protocol/openid-connect/logout", true, beanContainer, this.oidcConfig.devui().webClientTimeout(), this.oidcConfig.devui().grantOptions(), nonApplicationRootPathBuildItem, keycloakAdminUrl, users, keycloakRealms, configProps.get().isContainerRestarted(), httpConfig, false, null);
            KeycloakAdminPageBuildItem keycloakAdminPageItem = new KeycloakAdminPageBuildItem(cardPageBuildItem);
            keycloakAdminPageProducer.produce((BuildItem)keycloakAdminPageItem);
        }
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    JsonRPCProvidersBuildItem produceOidcDevJsonRpcService() {
        return new JsonRPCProvidersBuildItem(OidcDevJsonRpcService.class);
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    AdditionalBeanBuildItem registerOidcDevLoginObserver() {
        return AdditionalBeanBuildItem.unremovableOf(OidcDevLoginObserver.class);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void invokeEndpoint(BuildProducer<RouteBuildItem> routeProducer, OidcDevUiRecorder recorder, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        KeycloakDevUIProcessor.registerOidcWebAppRoutes(routeProducer, recorder, nonApplicationRootPathBuildItem);
    }
}

