/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.db.token.state.manager.runtime;

import io.quarkus.oidc.db.token.state.manager.runtime.OidcDbTokenStateManager;
import io.quarkus.oidc.db.token.state.manager.runtime.OidcDbTokenStateManagerRunTimeConfig;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import jakarta.enterprise.event.Observes;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class OidcDbTokenStateManagerInitializer {
    private static final Logger LOG = Logger.getLogger(OidcDbTokenStateManagerInitializer.class);
    private static final String FAILED_TO_CREATE_DB_TABLE = "unknown reason, please report the issue and create table manually";
    private static final long EXPIRED_EXTRA_GRACE = 30L;
    private static volatile Long timerId = null;

    void initialize(@Observes StartupEvent event, OidcDbTokenStateManagerRunTimeConfig config, Vertx vertx, Pool pool, OidcDbTokenStateManagerInitializerProperties initializerProps) {
        if (config.createDatabaseTableIfNotExists()) {
            OidcDbTokenStateManagerInitializer.createDatabaseTable(pool, initializerProps.createTableDdl, initializerProps.supportsIfTableNotExists);
        }
        OidcDbTokenStateManagerInitializer.periodicallyDeleteExpiredTokens(vertx, pool, config.deleteExpiredDelay().toMillis());
    }

    void shutdown(@Observes ShutdownEvent event, Vertx vertx) {
        if (timerId != null) {
            vertx.cancelTimer(timerId.longValue());
        }
    }

    private static void periodicallyDeleteExpiredTokens(Vertx vertx, final Pool pool, long delayBetweenChecks) {
        timerId = vertx.setPeriodic(5000L, delayBetweenChecks, (Handler)new Handler<Long>(){
            private final AtomicBoolean deleteInProgress = new AtomicBoolean(false);

            public void handle(Long aLong) {
                if (this.deleteInProgress.compareAndSet(false, true)) {
                    long deleteExpiresIn = OidcDbTokenStateManager.now() - 30L;
                    Uni.createFrom().completionStage(pool.query("DELETE FROM oidc_db_token_state_manager WHERE expires_in < " + deleteExpiresIn).execute().toCompletionStage()).subscribe().with((Consumer)new Consumer<RowSet<Row>>(){

                        @Override
                        public void accept(RowSet<Row> ignored) {
                            deleteInProgress.set(false);
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        @Override
                        public void accept(Throwable t) {
                            LOG.errorf("Failed to expired OIDC token states from database: %s", (Object)t.getMessage());
                            deleteInProgress.set(false);
                        }
                    });
                }
            }
        });
    }

    private static void createDatabaseTable(final Pool pool, String createTableDdl, final boolean supportsIfTableNotExists) {
        LOG.debugf("Creating database table with query: %s", (Object)createTableDdl);
        String errMsg = (String)Uni.createFrom().completionStage(pool.query(createTableDdl).execute().toCompletionStage()).onItemOrFailure().transformToUni((BiFunction)new BiFunction<RowSet<Row>, Throwable, Uni<? extends String>>(){

            @Override
            public Uni<String> apply(RowSet<Row> rows, Throwable throwable) {
                if (throwable != null) {
                    if (supportsIfTableNotExists) {
                        return Uni.createFrom().item((Object)throwable.getMessage());
                    }
                    return Uni.createFrom().nullItem();
                }
                return Uni.createFrom().completionStage(pool.query("SELECT MAX(id) FROM oidc_db_token_state_manager").execute().toCompletionStage()).map((Function)new Function<RowSet<Row>, String>(){

                    @Override
                    public String apply(RowSet<Row> rows) {
                        if (rows != null && rows.columnsNames().size() == 1) {
                            return null;
                        }
                        return OidcDbTokenStateManagerInitializer.FAILED_TO_CREATE_DB_TABLE;
                    }
                }).onFailure().recoverWithItem((Function)new Function<Throwable, String>(){

                    @Override
                    public String apply(Throwable throwable) {
                        LOG.error((Object)"Create database query failed with: ", throwable);
                        return OidcDbTokenStateManagerInitializer.FAILED_TO_CREATE_DB_TABLE;
                    }
                });
            }
        }).await().indefinitely();
        if (errMsg != null) {
            throw new RuntimeException("OIDC Token State Manager failed to create database table: " + errMsg);
        }
    }

    public static final class OidcDbTokenStateManagerInitializerProperties {
        private final String createTableDdl;
        private final boolean supportsIfTableNotExists;

        OidcDbTokenStateManagerInitializerProperties(String createTableDdl, boolean supportsIfTableNotExists) {
            this.createTableDdl = createTableDdl;
            this.supportsIfTableNotExists = supportsIfTableNotExists;
        }
    }
}

