/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class OidcClientCommonConfig
extends OidcCommonConfig
implements io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig {
    @Deprecated(since="3.18")
    public Optional<String> tokenPath = Optional.empty();
    @Deprecated(since="3.18")
    public Optional<String> revokePath = Optional.empty();
    @Deprecated(since="3.18")
    public Optional<String> clientId = Optional.empty();
    @Deprecated(since="3.18")
    public Optional<String> clientName = Optional.empty();
    @Deprecated(since="3.18")
    public Credentials credentials = new Credentials();

    protected OidcClientCommonConfig() {
    }

    protected OidcClientCommonConfig(io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig mapping) {
        super(mapping);
        this.tokenPath = mapping.tokenPath();
        this.revokePath = mapping.revokePath();
        this.clientId = mapping.clientId();
        this.clientName = mapping.clientName();
        this.credentials.addConfigMappingValues(mapping.credentials());
    }

    @Override
    public Optional<String> tokenPath() {
        return this.tokenPath;
    }

    @Override
    public Optional<String> revokePath() {
        return this.revokePath;
    }

    @Override
    public Optional<String> clientId() {
        return this.clientId;
    }

    @Override
    public Optional<String> clientName() {
        return this.clientName;
    }

    @Override
    public OidcClientCommonConfig.Credentials credentials() {
        return this.credentials;
    }

    @Deprecated(since="3.18")
    public Optional<String> getTokenPath() {
        return this.tokenPath;
    }

    @Deprecated(since="3.18")
    public void setTokenPath(String tokenPath) {
        this.tokenPath = Optional.of(tokenPath);
    }

    @Deprecated(since="3.18")
    public Optional<String> getRevokePath() {
        return this.revokePath;
    }

    @Deprecated(since="3.18")
    public void setRevokePath(String revokePath) {
        this.revokePath = Optional.of(revokePath);
    }

    @Deprecated(since="3.18")
    public Optional<String> getClientId() {
        return this.clientId;
    }

    @Deprecated(since="3.18")
    public void setClientId(String clientId) {
        this.clientId = Optional.of(clientId);
    }

    @Deprecated(since="3.18")
    public Optional<String> getClientName() {
        return this.clientName;
    }

    @Deprecated(since="3.18")
    public void setClientName(String clientName) {
        this.clientName = Optional.of(clientName);
    }

    @Deprecated(since="3.18")
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Deprecated(since="3.18")
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Deprecated(since="3.18")
    public static class Credentials
    implements OidcClientCommonConfig.Credentials {
        public Optional<String> secret = Optional.empty();
        public Secret clientSecret = new Secret();
        public Jwt jwt = new Jwt();

        public Optional<String> getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = Optional.of(secret);
        }

        public Secret getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(Secret clientSecret) {
            this.clientSecret = clientSecret;
        }

        public Jwt getJwt() {
            return this.jwt;
        }

        public void setJwt(Jwt jwt) {
            this.jwt = jwt;
        }

        private void addConfigMappingValues(OidcClientCommonConfig.Credentials mapping) {
            this.secret = mapping.secret();
            this.clientSecret.addConfigMappingValues(mapping.clientSecret());
            this.jwt.addConfigMappingValues(mapping.jwt());
        }

        @Override
        public Optional<String> secret() {
            return this.secret;
        }

        @Override
        public OidcClientCommonConfig.Credentials.Secret clientSecret() {
            return this.clientSecret;
        }

        @Override
        public OidcClientCommonConfig.Credentials.Jwt jwt() {
            return this.jwt;
        }

        public static class Secret
        implements OidcClientCommonConfig.Credentials.Secret {
            public Optional<String> value = Optional.empty();
            public Provider provider = new Provider();
            public Optional<Method> method = Optional.empty();

            @Override
            public Optional<String> value() {
                return this.value;
            }

            @Override
            public OidcClientCommonConfig.Credentials.Provider provider() {
                return this.provider;
            }

            @Override
            public Optional<OidcClientCommonConfig.Credentials.Secret.Method> method() {
                return this.method.map(Enum::toString).map(OidcClientCommonConfig.Credentials.Secret.Method::valueOf);
            }

            public Optional<String> getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = Optional.of(value);
            }

            public Optional<Method> getMethod() {
                return this.method;
            }

            public void setMethod(Method method) {
                this.method = Optional.of(method);
            }

            public Provider getSecretProvider() {
                return this.provider;
            }

            public void setSecretProvider(Provider secretProvider) {
                this.provider = secretProvider;
            }

            private void addConfigMappingValues(OidcClientCommonConfig.Credentials.Secret mapping) {
                this.value = mapping.value();
                this.provider.addConfigMappingValues(mapping.provider());
                this.method = mapping.method().map(Enum::toString).map(Method::valueOf);
            }

            public static enum Method {
                BASIC,
                POST,
                POST_JWT,
                QUERY;

            }
        }

        public static class Jwt
        implements OidcClientCommonConfig.Credentials.Jwt {
            private Optional<Path> tokenPath = Optional.empty();
            public Source source = Source.CLIENT;
            public Optional<String> secret = Optional.empty();
            public Provider secretProvider = new Provider();
            public Optional<String> key = Optional.empty();
            public Optional<String> keyFile = Optional.empty();
            public Optional<String> keyStoreFile = Optional.empty();
            public Optional<String> keyStorePassword;
            public Optional<String> keyId = Optional.empty();
            public Optional<String> keyPassword;
            public Optional<String> audience = Optional.empty();
            public Optional<String> tokenKeyId = Optional.empty();
            public Optional<String> issuer = Optional.empty();
            public Optional<String> subject = Optional.empty();
            public Map<String, String> claims = new HashMap<String, String>();
            public Optional<String> signatureAlgorithm = Optional.empty();
            public int lifespan = 10;
            public boolean assertion = false;

            @Override
            public OidcClientCommonConfig.Credentials.Jwt.Source source() {
                return this.source == null ? null : OidcClientCommonConfig.Credentials.Jwt.Source.valueOf(this.source.toString());
            }

            @Override
            public Optional<Path> tokenPath() {
                return this.tokenPath;
            }

            @Override
            public Optional<String> secret() {
                return this.secret;
            }

            @Override
            public OidcClientCommonConfig.Credentials.Provider secretProvider() {
                return this.secretProvider;
            }

            @Override
            public Optional<String> key() {
                return this.key;
            }

            @Override
            public Optional<String> keyFile() {
                return this.keyFile;
            }

            @Override
            public Optional<String> keyStoreFile() {
                return this.keyStoreFile;
            }

            @Override
            public Optional<String> keyStorePassword() {
                return this.keyStorePassword;
            }

            @Override
            public Optional<String> keyId() {
                return this.keyId;
            }

            @Override
            public Optional<String> keyPassword() {
                return this.keyPassword;
            }

            @Override
            public Optional<String> audience() {
                return this.audience;
            }

            @Override
            public Optional<String> tokenKeyId() {
                return this.tokenKeyId;
            }

            @Override
            public Optional<String> issuer() {
                return this.issuer;
            }

            @Override
            public Optional<String> subject() {
                return this.subject;
            }

            @Override
            public Map<String, String> claims() {
                return this.claims;
            }

            @Override
            public Optional<String> signatureAlgorithm() {
                return this.signatureAlgorithm;
            }

            @Override
            public int lifespan() {
                return this.lifespan;
            }

            @Override
            public boolean assertion() {
                return this.assertion;
            }

            public Optional<String> getSecret() {
                return this.secret;
            }

            public void setSecret(String secret) {
                this.secret = Optional.of(secret);
            }

            public int getLifespan() {
                return this.lifespan;
            }

            public void setLifespan(int lifespan) {
                this.lifespan = lifespan;
            }

            public Optional<String> getTokenKeyId() {
                return this.tokenKeyId;
            }

            public void setTokenKeyId(String tokenKeyId) {
                this.tokenKeyId = Optional.of(tokenKeyId);
            }

            public Provider getSecretProvider() {
                return this.secretProvider;
            }

            public void setSecretProvider(Provider secretProvider) {
                this.secretProvider = secretProvider;
            }

            public Optional<String> getSignatureAlgorithm() {
                return this.signatureAlgorithm;
            }

            public void setSignatureAlgorithm(String signatureAlgorithm) {
                this.signatureAlgorithm = Optional.of(signatureAlgorithm);
            }

            public Optional<String> getAudience() {
                return this.audience;
            }

            public void setAudience(String audience) {
                this.audience = Optional.of(audience);
            }

            public Optional<String> getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = Optional.of(key);
            }

            public Optional<String> getKeyFile() {
                return this.keyFile;
            }

            public void setKeyFile(String keyFile) {
                this.keyFile = Optional.of(keyFile);
            }

            public Map<String, String> getClaims() {
                return this.claims;
            }

            public void setClaims(Map<String, String> claims) {
                this.claims = claims;
            }

            public Source getSource() {
                return this.source;
            }

            public void setSource(Source source) {
                this.source = source;
            }

            public boolean isAssertion() {
                return this.assertion;
            }

            public void setAssertion(boolean assertion) {
                this.assertion = assertion;
            }

            private void addConfigMappingValues(OidcClientCommonConfig.Credentials.Jwt mapping) {
                this.source = Source.valueOf(mapping.source().toString());
                this.secret = mapping.secret();
                this.secretProvider.addConfigMappingValues(mapping.secretProvider());
                this.key = mapping.key();
                this.keyFile = mapping.keyFile();
                this.keyStoreFile = mapping.keyStoreFile();
                this.keyStorePassword = mapping.keyStorePassword();
                this.keyId = mapping.keyId();
                this.keyPassword = mapping.keyPassword();
                this.audience = mapping.audience();
                this.tokenKeyId = mapping.tokenKeyId();
                this.issuer = mapping.issuer();
                this.subject = mapping.subject();
                this.claims = mapping.claims();
                this.signatureAlgorithm = mapping.signatureAlgorithm();
                this.lifespan = mapping.lifespan();
                this.assertion = mapping.assertion();
                this.tokenPath = mapping.tokenPath();
            }

            public static enum Source {
                CLIENT,
                BEARER;

            }
        }

        public static class Provider
        implements OidcClientCommonConfig.Credentials.Provider {
            public Optional<String> name = Optional.empty();
            public Optional<String> keyringName = Optional.empty();
            public Optional<String> key = Optional.empty();

            public Optional<String> getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = Optional.of(name);
            }

            public Optional<String> getKeyringName() {
                return this.keyringName;
            }

            public void setKeyringName(String keyringName) {
                this.keyringName = Optional.of(keyringName);
            }

            public Optional<String> getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = Optional.of(key);
            }

            private void addConfigMappingValues(OidcClientCommonConfig.Credentials.Provider mapping) {
                this.name = mapping.name();
                this.keyringName = mapping.keyringName();
                this.key = mapping.key();
            }

            @Override
            public Optional<String> name() {
                return this.name;
            }

            @Override
            public Optional<String> keyringName() {
                return this.keyringName;
            }

            @Override
            public Optional<String> key() {
                return this.key;
            }
        }
    }
}

