/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.Unremovable;
import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClientException;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.runtime.OidcClientConfig;
import io.quarkus.oidc.client.runtime.OidcClientImpl;
import io.quarkus.oidc.client.runtime.OidcClientRecorder;
import io.quarkus.oidc.client.runtime.OidcClientsConfig;
import io.quarkus.oidc.common.runtime.OidcTlsSupport;
import io.quarkus.runtime.Shutdown;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Singleton
public final class OidcClientsImpl
implements OidcClients,
Closeable {
    private static final Logger LOG = Logger.getLogger(OidcClientsImpl.class);
    private final OidcClient defaultClient;
    private final Map<String, OidcClient> staticOidcClients;
    private final Vertx vertx;
    private final OidcTlsSupport tlsSupport;
    private volatile PeriodicTask tokenRefreshTask;

    @Inject
    OidcClientsImpl(OidcClientsConfig oidcClientsConfig, Vertx vertx, TlsConfigurationRegistry registry) {
        this(oidcClientsConfig, vertx, OidcClientsConfig.getDefaultClient(oidcClientsConfig), OidcTlsSupport.of((TlsConfigurationRegistry)registry));
    }

    private OidcClientsImpl(OidcClientsConfig oidcClientsConfig, Vertx vertx, OidcClientConfig defaultClientConfig, OidcTlsSupport tlsSupport) {
        this(OidcClientRecorder.createOidcClient(defaultClientConfig, defaultClientConfig.id().get(), vertx, tlsSupport), OidcClientRecorder.createStaticOidcClients(oidcClientsConfig, vertx, tlsSupport, defaultClientConfig), vertx, tlsSupport, OidcClientsImpl.createTokenRefreshPeriodicTask(oidcClientsConfig, vertx));
    }

    private OidcClientsImpl(OidcClient defaultClient, Map<String, OidcClient> staticOidcClients, Vertx vertx, OidcTlsSupport tlsSupport, PeriodicTask tokenRefreshTask) {
        this.defaultClient = defaultClient;
        this.staticOidcClients = staticOidcClients;
        this.vertx = vertx;
        this.tlsSupport = tlsSupport;
        this.tokenRefreshTask = tokenRefreshTask;
    }

    @Override
    public OidcClient getClient() {
        return this.defaultClient;
    }

    @Override
    public OidcClient getClient(String id) {
        return this.staticOidcClients.get(id);
    }

    @Override
    public void close() throws IOException {
        this.defaultClient.close();
        for (OidcClient client : this.staticOidcClients.values()) {
            client.close();
        }
    }

    @Override
    public Uni<OidcClient> newClient(OidcClientConfig clientConfig) {
        if (clientConfig.id().isEmpty()) {
            throw new OidcClientException("'id' property must be set");
        }
        return OidcClientRecorder.createOidcClientUni(clientConfig, clientConfig.id().get(), this.vertx, this.tlsSupport);
    }

    @Singleton
    @Produces
    @Unremovable
    OidcClient createOidcClientBean() {
        return this.defaultClient;
    }

    @PreDestroy
    void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Shutdown
    void shutdown() {
        if (this.tokenRefreshTask != null) {
            this.tokenRefreshTask.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTokenRefresh(OidcClient oidcClient, final Supplier<Uni<Tokens>> tokensSupplier) {
        OidcClientImpl oidcClientImpl;
        Object object = ClientProxy.unwrap((Object)oidcClient);
        if (object instanceof OidcClientImpl && (oidcClientImpl = (OidcClientImpl)object).getConfig().refreshInterval().isPresent()) {
            Duration refreshInterval = oidcClientImpl.getConfig().refreshInterval().get();
            CancellableTask refreshTask = new CancellableTask(){
                private final AtomicInteger numOfErrorsInRow = new AtomicInteger();

                @Override
                public void run() {
                    ((Uni)tokensSupplier.get()).subscribe().with((Consumer)new Consumer<Tokens>(){

                        @Override
                        public void accept(Tokens ignored) {
                            if (numOfErrorsInRow.get() != 0) {
                                numOfErrorsInRow.set(0);
                            }
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        @Override
                        public void accept(Throwable throwable) {
                            if (numOfErrorsInRow.incrementAndGet() >= 10) {
                                LOG.warnf("Cancelling periodic token refresh for OIDC client '%s' as %d previous attempts failed", (Object)oidcClientImpl.getConfig().id().get(), (Object)numOfErrorsInRow.get());
                                this.cancel();
                            }
                        }
                    });
                }
            };
            if (this.tokenRefreshTask == null) {
                OidcClientsImpl oidcClientsImpl = this;
                synchronized (oidcClientsImpl) {
                    if (this.tokenRefreshTask == null) {
                        this.tokenRefreshTask = new PeriodicTask(this.vertx);
                    }
                }
            }
            this.tokenRefreshTask.add(refreshTask, refreshInterval);
        }
    }

    private static PeriodicTask createTokenRefreshPeriodicTask(OidcClientsConfig oidcClientsConfig, Vertx vertx) {
        for (OidcClientConfig config : oidcClientsConfig.namedClients().values()) {
            if (!config.refreshInterval().isPresent()) continue;
            return new PeriodicTask(vertx);
        }
        return null;
    }

    private static final class PeriodicTask {
        private final Vertx vertx;
        private final Set<Long> timerIds;

        private PeriodicTask(Vertx vertx) {
            this.vertx = vertx;
            this.timerIds = new CopyOnWriteArraySet<Long>();
        }

        private void add(CancellableTask task, Duration refreshInterval) {
            long timerId = this.scheduleTask(task, refreshInterval);
            this.timerIds.add(timerId);
        }

        private void cancel() {
            for (long timerId : this.timerIds) {
                this.vertx.cancelTimer(timerId);
            }
        }

        private long scheduleTask(CancellableTask task, Duration refreshInterval) {
            final long timerId = this.vertx.setPeriodic(0L, refreshInterval.toMillis(), (Handler)task);
            task.cancel = new Runnable(){

                @Override
                public void run() {
                    timerIds.remove(timerId);
                    vertx.cancelTimer(timerId);
                }
            };
            return timerId;
        }
    }

    private static abstract class CancellableTask
    implements Handler<Long> {
        private volatile Runnable cancel;

        private CancellableTask() {
        }

        protected abstract void run();

        protected final void cancel() {
            if (this.cancel != null) {
                this.cancel.run();
            }
        }

        public final void handle(Long ignored) {
            this.run();
        }
    }
}

