/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.runtime.OidcClientBuildTimeConfig;
import io.quarkus.oidc.client.runtime.OidcClientsConfig;
import io.quarkus.oidc.client.runtime.OidcClientsImpl;
import io.quarkus.oidc.client.runtime.TokensHelper;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public abstract class AbstractTokensProducer {
    private static final Logger LOG = Logger.getLogger(AbstractTokensProducer.class);
    private static final String DEFAULT_OIDC_CLIENT_ID = "Default";
    private OidcClient oidcClient;
    protected boolean earlyTokenAcquisition = true;
    @Inject
    public OidcClientsConfig oidcClientsConfig;
    @Inject
    public OidcClientBuildTimeConfig oidcClientBuildTimeConfig;
    @Inject
    public Instance<OidcClientsImpl> oidcClientsInstance;
    final TokensHelper tokensHelper = new TokensHelper();

    @PostConstruct
    public void init() {
        if (this.isClientFeatureDisabled()) {
            LOG.debug((Object)"OIDC client is disabled with `quarkus.oidc-client.enabled=false`, skipping the token producer initialization");
            return;
        }
        OidcClientsImpl oidcClients = (OidcClientsImpl)this.oidcClientsInstance.get();
        Optional<OidcClient> initializedClient = this.client();
        if (initializedClient.isEmpty()) {
            Optional<String> clientId = Objects.requireNonNull(this.clientId(), "clientId must not be null");
            if (clientId.isPresent()) {
                this.oidcClient = Objects.requireNonNull(oidcClients.getClient(clientId.get()), "Unknown client");
                this.earlyTokenAcquisition = this.oidcClientsConfig.namedClients().get(clientId.get()).earlyTokensAcquisition();
            } else {
                this.earlyTokenAcquisition = OidcClientsConfig.getDefaultClient(this.oidcClientsConfig).earlyTokensAcquisition();
                this.oidcClient = oidcClients.getClient();
            }
        } else {
            this.oidcClient = initializedClient.get();
        }
        this.initTokens();
        if (!this.isForceNewTokens()) {
            oidcClients.registerTokenRefresh(this.oidcClient, new Supplier<Uni<Tokens>>(){

                @Override
                public Uni<Tokens> get() {
                    return AbstractTokensProducer.this.getTokens();
                }
            });
        }
    }

    protected boolean isClientFeatureDisabled() {
        return !this.oidcClientBuildTimeConfig.enabled();
    }

    protected void initTokens() {
        if (this.isClientFeatureDisabled()) {
            throw new IllegalStateException("OIDC client feature is disabled with `quarkus.oidc-client.enabled=false` but the initTokens() method is called.");
        }
        if (this.earlyTokenAcquisition) {
            this.tokensHelper.initTokens(this.oidcClient, this.additionalParameters());
        }
    }

    public Uni<Tokens> getTokens() {
        if (this.isClientFeatureDisabled()) {
            throw new IllegalStateException("OIDC client feature is disabled with `quarkus.oidc-client.enabled=false` but the getTokens() method is called.");
        }
        boolean forceNewTokens = this.isForceNewTokens();
        if (forceNewTokens) {
            Optional<String> clientId = this.clientId();
            LOG.debugf("%s OidcClient will discard the current access and refresh tokens", (Object)clientId.orElse(DEFAULT_OIDC_CLIENT_ID));
        }
        return this.tokensHelper.getTokens(this.oidcClient, this.additionalParameters(), forceNewTokens);
    }

    public Tokens awaitTokens() {
        if (this.isClientFeatureDisabled()) {
            throw new IllegalStateException("OIDC client feature is disabled with `quarkus.oidc-client.enabled=false`.");
        }
        return (Tokens)this.getTokens().await().indefinitely();
    }

    protected Optional<String> clientId() {
        return Optional.empty();
    }

    protected Optional<OidcClient> client() {
        return Optional.empty();
    }

    protected boolean isForceNewTokens() {
        return false;
    }

    protected Map<String, String> additionalParameters() {
        return Map.of();
    }
}

