/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.registration;

import io.quarkus.oidc.client.registration.OidcClientRegistrationConfig;
import io.quarkus.oidc.client.registration.runtime.OidcClientRegistrationsConfig;
import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.config.OidcCommonConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class OidcClientRegistrationConfigBuilder
extends OidcCommonConfigBuilder<OidcClientRegistrationConfigBuilder> {
    private static volatile OidcClientRegistrationConfig configWithDefaults = null;
    private Optional<String> id;
    private boolean registrationEnabled;
    private boolean registerEarly;
    private Optional<String> initialToken;
    private OidcClientRegistrationConfig.Metadata metadata;

    public OidcClientRegistrationConfigBuilder() {
        this(OidcClientRegistrationConfigBuilder.getConfigWithDefaults());
    }

    public OidcClientRegistrationConfigBuilder(OidcClientRegistrationConfig config) {
        super((OidcCommonConfig)Objects.requireNonNull(config));
        this.id = config.id();
        this.registrationEnabled = config.registrationEnabled();
        this.registerEarly = config.registerEarly();
        this.initialToken = config.initialToken();
        this.metadata = config.metadata();
    }

    protected OidcClientRegistrationConfigBuilder getBuilder() {
        return this;
    }

    public OidcClientRegistrationConfigBuilder id(String id) {
        this.id = Optional.ofNullable(id);
        return this;
    }

    public OidcClientRegistrationConfigBuilder registrationEnabled(boolean registrationEnabled) {
        this.registrationEnabled = registrationEnabled;
        return this;
    }

    public OidcClientRegistrationConfigBuilder registerEarly(boolean registerEarly) {
        this.registerEarly = registerEarly;
        return this;
    }

    public OidcClientRegistrationConfigBuilder initialToken(String initialToken) {
        this.initialToken = Optional.ofNullable(initialToken);
        return this;
    }

    public OidcClientRegistrationConfigBuilder metadata(String redirectUri) {
        return this.metadata().redirectUri(redirectUri).end();
    }

    public OidcClientRegistrationConfigBuilder metadata(String clientName, String redirectUri) {
        return this.metadata().clientName(clientName).redirectUri(redirectUri).end();
    }

    public OidcClientRegistrationConfigBuilder metadata(OidcClientRegistrationConfig.Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata);
        return this;
    }

    public MetadataBuilder metadata() {
        return new MetadataBuilder(this);
    }

    public OidcClientRegistrationConfig build() {
        return new OidcClientRegistrationConfigImpl(this);
    }

    private static OidcClientRegistrationConfig getConfigWithDefaults() {
        if (configWithDefaults == null) {
            OidcClientRegistrationsConfig clientRegistrationsConfig = (OidcClientRegistrationsConfig)new SmallRyeConfigBuilder().addDiscoveredConverters().withMapping(OidcClientRegistrationsConfig.class).build().getConfigMapping(OidcClientRegistrationsConfig.class);
            configWithDefaults = OidcClientRegistrationsConfig.getDefaultClientRegistration(clientRegistrationsConfig);
        }
        return configWithDefaults;
    }

    public static final class MetadataBuilder {
        private Optional<String> clientName = Optional.empty();
        private Optional<String> redirectUri = Optional.empty();
        private Optional<String> postLogoutUri = Optional.empty();
        private final Map<String, String> extraProps = new HashMap<String, String>();
        private final OidcClientRegistrationConfigBuilder configBuilder;

        public MetadataBuilder(OidcClientRegistrationConfigBuilder configBuilder) {
            this.configBuilder = configBuilder;
        }

        public MetadataBuilder() {
            this(new OidcClientRegistrationConfigBuilder());
        }

        public OidcClientRegistrationConfig.Metadata build() {
            return new MetadataImpl(this.clientName, this.redirectUri, this.postLogoutUri, this.extraProps);
        }

        public OidcClientRegistrationConfigBuilder end() {
            Objects.requireNonNull(this.configBuilder);
            this.configBuilder.metadata = this.build();
            return this.configBuilder;
        }

        public MetadataBuilder clientName(String clientName) {
            this.clientName = Optional.ofNullable(clientName);
            return this;
        }

        public MetadataBuilder redirectUri(String redirectUri) {
            this.redirectUri = Optional.ofNullable(redirectUri);
            return this;
        }

        public MetadataBuilder postLogoutUri(String postLogoutUri) {
            this.postLogoutUri = Optional.ofNullable(postLogoutUri);
            return this;
        }

        public MetadataBuilder extraProperty(String key, String value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.extraProps.put(key, value);
            return this;
        }

        public MetadataBuilder extraProps(Map<String, String> extraProps) {
            Objects.requireNonNull(extraProps);
            this.extraProps.putAll(extraProps);
            return this;
        }
    }

    private static final class OidcClientRegistrationConfigImpl
    extends OidcCommonConfigBuilder.OidcCommonConfigImpl
    implements OidcClientRegistrationConfig {
        private final Optional<String> id;
        private final boolean registrationEnabled;
        private final boolean registerEarly;
        private final Optional<String> initialToken;
        private final OidcClientRegistrationConfig.Metadata metadata;

        private OidcClientRegistrationConfigImpl(OidcClientRegistrationConfigBuilder builder) {
            super((OidcCommonConfigBuilder)builder);
            this.id = builder.id;
            this.registrationEnabled = builder.registrationEnabled;
            this.registerEarly = builder.registerEarly;
            this.initialToken = builder.initialToken;
            this.metadata = builder.metadata;
        }

        @Override
        public Optional<String> id() {
            return this.id;
        }

        @Override
        public boolean registrationEnabled() {
            return this.registrationEnabled;
        }

        @Override
        public boolean registerEarly() {
            return this.registerEarly;
        }

        @Override
        public Optional<String> initialToken() {
            return this.initialToken;
        }

        @Override
        public OidcClientRegistrationConfig.Metadata metadata() {
            return this.metadata;
        }
    }

    private record MetadataImpl(Optional<String> clientName, Optional<String> redirectUri, Optional<String> postLogoutUri, Map<String, String> extraProps) implements OidcClientRegistrationConfig.Metadata
    {
    }
}

