/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.registration;

import io.quarkus.jsonp.JsonProviderHolder;
import io.quarkus.oidc.client.registration.runtime.OidcClientRegistrationException;
import io.quarkus.oidc.common.runtime.AbstractJsonObject;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.EdECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.lang.JoseException;

public class ClientMetadata
extends AbstractJsonObject {
    public ClientMetadata() {
    }

    public ClientMetadata(String json) {
        super(json);
    }

    public ClientMetadata(JsonObject json) {
        super(json);
    }

    public ClientMetadata(ClientMetadata metadata) {
        super(metadata.getJsonObject());
    }

    public String getClientId() {
        return super.getString("client_id");
    }

    public String getClientSecret() {
        return super.getString("client_secret");
    }

    public String getClientName() {
        return super.getString("client_name");
    }

    public List<String> getRedirectUris() {
        return this.getListOfStrings("redirect_uris");
    }

    public List<String> getPostLogoutUris() {
        return this.getListOfStrings("post_logout_redirect_uris");
    }

    public String getMetadataString() {
        return super.getJsonString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClientMetadata m) {
        return new Builder(m.getJsonObject());
    }

    public static class Builder {
        JsonObjectBuilder builder;
        boolean built = false;

        Builder() {
            this.builder = JsonProviderHolder.jsonProvider().createObjectBuilder();
        }

        Builder(JsonObject json) {
            this.builder = JsonProviderHolder.jsonProvider().createObjectBuilder(json);
        }

        public Builder clientName(String clientName) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.builder.add("client_name", clientName);
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.builder.add("redirect_uris", (JsonValue)JsonProviderHolder.jsonProvider().createArrayBuilder().add(redirectUri).build());
            return this;
        }

        public Builder postLogoutUri(String postLogoutUri) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.builder.add("post_logout_redirect_uris", (JsonValue)JsonProviderHolder.jsonProvider().createArrayBuilder().add(postLogoutUri).build());
            return this;
        }

        public Builder grantType(String grantType) {
            return this.grantTypes(Set.of(grantType));
        }

        public Builder grantTypes(Set<String> grantTypes) {
            if (this.built) {
                throw new IllegalStateException();
            }
            JsonArrayBuilder arrayBuilder = JsonProviderHolder.jsonProvider().createArrayBuilder();
            for (String grantType : grantTypes) {
                arrayBuilder.add(grantType);
            }
            this.builder.add("grant_types", (JsonValue)arrayBuilder.build());
            return this;
        }

        public Builder tokenEndpointAuthMethod(String tokenEndpointAuthMethod) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.builder.add("token_endpoint_auth_method", tokenEndpointAuthMethod);
            return this;
        }

        public Builder jwk(PublicKey publicKey) {
            return this.jwks(Set.of(publicKey));
        }

        public Builder jwks(Set<PublicKey> publicKeys) {
            if (this.built) {
                throw new IllegalStateException();
            }
            JsonArrayBuilder keysBuilder = JsonProviderHolder.jsonProvider().createArrayBuilder();
            for (PublicKey publicKey : publicKeys) {
                JsonObjectBuilder jwkBuilder = JsonProviderHolder.jsonProvider().createObjectBuilder();
                for (Map.Entry<String, Object> entry : Builder.convertPublicKeyToJwk(publicKey).entrySet()) {
                    jwkBuilder.add(entry.getKey(), entry.getValue().toString());
                }
                jwkBuilder.add("use", "sig");
                jwkBuilder.add("alg", Builder.getAlgorithm(publicKey));
                keysBuilder.add(jwkBuilder);
            }
            JsonObjectBuilder jwksBuilder = JsonProviderHolder.jsonProvider().createObjectBuilder();
            jwksBuilder.add("keys", keysBuilder);
            this.builder.add("jwks", jwksBuilder);
            return this;
        }

        public Builder jwk(Map<String, String> keyProperties) {
            if (this.built) {
                throw new IllegalStateException();
            }
            JsonArrayBuilder keysBuilder = JsonProviderHolder.jsonProvider().createArrayBuilder();
            JsonObjectBuilder jwkBuilder = JsonProviderHolder.jsonProvider().createObjectBuilder();
            for (Map.Entry<String, String> entry : keyProperties.entrySet()) {
                jwkBuilder.add(entry.getKey(), entry.getValue());
            }
            keysBuilder.add(jwkBuilder);
            JsonObjectBuilder jwksBuilder = JsonProviderHolder.jsonProvider().createObjectBuilder();
            jwksBuilder.add("keys", keysBuilder);
            this.builder.add("jwks", jwksBuilder);
            return this;
        }

        public Builder extraProps(Map<String, String> extraProps) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.builder.addAll(JsonProviderHolder.jsonProvider().createObjectBuilder(extraProps));
            return this;
        }

        private static Map<String, Object> convertPublicKeyToJwk(PublicKey key) {
            try {
                return PublicJsonWebKey.Factory.newPublicJwk((Key)key).toParams(JsonWebKey.OutputControlLevel.PUBLIC_ONLY);
            }
            catch (JoseException ex) {
                throw new OidcClientRegistrationException(ex);
            }
        }

        private static String getAlgorithm(PublicKey publicKey) {
            if (publicKey instanceof RSAPublicKey) {
                return SignatureAlgorithm.RS256.getAlgorithm();
            }
            if (publicKey instanceof ECPublicKey) {
                return SignatureAlgorithm.ES256.getAlgorithm();
            }
            if (publicKey instanceof EdECPublicKey) {
                return SignatureAlgorithm.EDDSA.getAlgorithm();
            }
            throw new OidcClientRegistrationException("Unrecognized public key algorithm: " + publicKey.getAlgorithm());
        }

        public ClientMetadata build() {
            this.built = true;
            return new ClientMetadata(this.builder.build());
        }
    }
}

