/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.registration.runtime;

import io.quarkus.oidc.client.registration.ClientMetadata;
import io.quarkus.oidc.client.registration.OidcClientRegistration;
import io.quarkus.oidc.client.registration.OidcClientRegistrationConfig;
import io.quarkus.oidc.client.registration.OidcClientRegistrations;
import io.quarkus.oidc.client.registration.RegisteredClient;
import io.quarkus.oidc.client.registration.runtime.DisabledOidcClientRegistrationException;
import io.quarkus.oidc.client.registration.runtime.OidcClientRegistrationException;
import io.quarkus.oidc.client.registration.runtime.OidcClientRegistrationImpl;
import io.quarkus.oidc.client.registration.runtime.OidcClientRegistrationsConfig;
import io.quarkus.oidc.client.registration.runtime.OidcClientRegistrationsImpl;
import io.quarkus.oidc.common.OidcEndpoint;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.OidcRequestFilter;
import io.quarkus.oidc.common.OidcResponseFilter;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.common.runtime.OidcTlsSupport;
import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class OidcClientRegistrationRecorder {
    private static final Logger LOG = Logger.getLogger(OidcClientRegistrationRecorder.class);
    private static final String DEFAULT_ID = "Default";
    private final RuntimeValue<OidcClientRegistrationsConfig> runtimeConfig;

    public OidcClientRegistrationRecorder(RuntimeValue<OidcClientRegistrationsConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public OidcClientRegistrations setup(final Supplier<Vertx> vertx, Supplier<TlsConfigurationRegistry> registrySupplier) {
        final OidcTlsSupport tlsSupport = OidcTlsSupport.of(registrySupplier);
        OidcClientRegistration defaultClientReg = OidcClientRegistrationRecorder.createOidcClientRegistration(OidcClientRegistrationsConfig.getDefaultClientRegistration((OidcClientRegistrationsConfig)this.runtimeConfig.getValue()), tlsSupport, vertx);
        HashMap<String, OidcClientRegistration> staticOidcClientRegs = new HashMap<String, OidcClientRegistration>();
        for (Map.Entry<String, OidcClientRegistrationConfig> config : ((OidcClientRegistrationsConfig)this.runtimeConfig.getValue()).namedClientRegistrations().entrySet()) {
            staticOidcClientRegs.put(config.getKey(), OidcClientRegistrationRecorder.createOidcClientRegistration(config.getValue(), tlsSupport, vertx));
        }
        return new OidcClientRegistrationsImpl(defaultClientReg, staticOidcClientRegs, new Function<OidcClientRegistrationConfig, Uni<OidcClientRegistration>>(){

            @Override
            public Uni<OidcClientRegistration> apply(OidcClientRegistrationConfig config) {
                return OidcClientRegistrationRecorder.createOidcClientRegistrationUni(config, tlsSupport, vertx);
            }
        });
    }

    private static boolean isEmptyMetadata(OidcClientRegistrationConfig.Metadata m) {
        return m.clientName().isEmpty() && m.redirectUri().isEmpty() && m.postLogoutUri().isEmpty() && m.extraProps().isEmpty();
    }

    public Supplier<OidcClientRegistration> createOidcClientRegistrationBean(final OidcClientRegistrations oidcClientRegs) {
        return new Supplier<OidcClientRegistration>(){

            @Override
            public OidcClientRegistration get() {
                return oidcClientRegs.getClientRegistration();
            }
        };
    }

    public Supplier<OidcClientRegistrations> createOidcClientRegistrationsBean(final OidcClientRegistrations oidcClientRegs) {
        return new Supplier<OidcClientRegistrations>(){

            @Override
            public OidcClientRegistrations get() {
                return oidcClientRegs;
            }
        };
    }

    public static OidcClientRegistration createOidcClientRegistration(OidcClientRegistrationConfig oidcConfig, OidcTlsSupport tlsSupport, Supplier<Vertx> vertxSupplier) {
        return (OidcClientRegistration)OidcClientRegistrationRecorder.createOidcClientRegistrationUni(oidcConfig, tlsSupport, vertxSupplier).await().atMost(oidcConfig.connectionTimeout());
    }

    public static Uni<OidcClientRegistration> createOidcClientRegistrationUni(final OidcClientRegistrationConfig oidcConfig, OidcTlsSupport tlsSupport, Supplier<Vertx> vertxSupplier) {
        if (!oidcConfig.registrationEnabled()) {
            String message = String.format("'%s' client registration configuration is disabled", "");
            LOG.debug((Object)message);
            return Uni.createFrom().item((Object)new DisabledOidcClientRegistration(message));
        }
        try {
            if (oidcConfig.authServerUrl().isEmpty() && !OidcCommonUtils.isAbsoluteUrl((Optional)oidcConfig.registrationPath())) {
                if (OidcClientRegistrationRecorder.isEmptyMetadata(oidcConfig.metadata())) {
                    return Uni.createFrom().nullItem();
                }
                String clientName = DEFAULT_ID.equals(oidcConfig.id().orElse(DEFAULT_ID)) ? "" : "." + oidcConfig.id().get();
                throw new ConfigurationException("Either 'quarkus.oidc-client-registration" + clientName + ".auth-server-url' or absolute 'quarkus.oidc-client-registration" + clientName + ".registration-path' URL must be set");
            }
            OidcCommonUtils.verifyEndpointUrl((String)OidcClientRegistrationRecorder.getEndpointUrl(oidcConfig));
        }
        catch (Throwable t) {
            LOG.error((Object)t.getMessage());
            String message = String.format("'%s' client registration configuration is not initialized", oidcConfig.id().orElse(DEFAULT_ID));
            return Uni.createFrom().failure((Throwable)new RuntimeException(message));
        }
        WebClientOptions options = new WebClientOptions();
        options.setFollowRedirects(oidcConfig.followRedirects());
        OidcCommonUtils.setHttpClientOptions((OidcCommonConfig)oidcConfig, (HttpClientOptions)options, (OidcTlsSupport.TlsConfigSupport)tlsSupport.forConfig(oidcConfig.tls().tlsConfigurationName()));
        io.vertx.mutiny.core.Vertx vertx = new io.vertx.mutiny.core.Vertx(vertxSupplier.get());
        final WebClient client = WebClient.create((io.vertx.mutiny.core.Vertx)vertx, (WebClientOptions)options);
        final Map oidcRequestFilters = OidcCommonUtils.getOidcRequestFilters();
        final Map oidcResponseFilters = OidcCommonUtils.getOidcResponseFilters();
        Uni clientRegConfigUni = null;
        if (OidcCommonUtils.isAbsoluteUrl((Optional)oidcConfig.registrationPath())) {
            clientRegConfigUni = Uni.createFrom().item((Object)new OidcConfigurationMetadata((String)oidcConfig.registrationPath().get()));
        } else {
            String authServerUriString = OidcCommonUtils.getAuthServerUrl((OidcCommonConfig)oidcConfig);
            clientRegConfigUni = oidcConfig.discoveryEnabled().orElse(true) == false ? Uni.createFrom().item((Object)new OidcConfigurationMetadata(OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, (Optional)oidcConfig.registrationPath()))) : OidcClientRegistrationRecorder.discoverRegistrationUri(client, oidcRequestFilters, oidcResponseFilters, authServerUriString.toString(), vertx, oidcConfig);
        }
        return clientRegConfigUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<OidcConfigurationMetadata, Throwable, Uni<? extends OidcClientRegistration>>(){

            @Override
            public Uni<OidcClientRegistration> apply(final OidcConfigurationMetadata metadata, Throwable t) {
                if (t != null) {
                    throw OidcClientRegistrationRecorder.toOidcClientRegException(OidcClientRegistrationRecorder.getEndpointUrl(oidcConfig), t);
                }
                if (metadata.clientRegistrationUri == null) {
                    throw new ConfigurationException("OpenId Connect Provider client registration endpoint URL is not configured and can not be discovered");
                }
                final long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis((OidcCommonConfig)oidcConfig);
                ClientMetadata clientMetadata = OidcClientRegistrationImpl.createMetadata(oidcConfig.metadata());
                if (!oidcConfig.registerEarly()) {
                    LOG.debugf("%s client registration is delayed", (Object)oidcConfig.id().orElse(OidcClientRegistrationRecorder.DEFAULT_ID));
                    return Uni.createFrom().item((Object)new OidcClientRegistrationImpl(client, connectionDelayInMillisecs, metadata.clientRegistrationUri, oidcConfig, null, oidcRequestFilters, oidcResponseFilters));
                }
                if (clientMetadata.getJsonObject().isEmpty()) {
                    LOG.debugf("%s client registration is skipped because its metadata is not configured", (Object)oidcConfig.id().orElse(OidcClientRegistrationRecorder.DEFAULT_ID));
                    return Uni.createFrom().item((Object)new OidcClientRegistrationImpl(client, connectionDelayInMillisecs, metadata.clientRegistrationUri, oidcConfig, null, oidcRequestFilters, oidcResponseFilters));
                }
                return OidcClientRegistrationImpl.registerClient(client, metadata.clientRegistrationUri, oidcConfig, oidcRequestFilters, oidcResponseFilters, clientMetadata.getMetadataString()).onFailure(OidcCommonUtils.oidcEndpointNotAvailable()).retry().withBackOff(OidcCommonUtils.CONNECTION_BACKOFF_DURATION, OidcCommonUtils.CONNECTION_BACKOFF_DURATION).expireIn(connectionDelayInMillisecs).onItemOrFailure().transform((BiFunction)new BiFunction<RegisteredClient, Throwable, OidcClientRegistration>(){

                    @Override
                    public OidcClientRegistration apply(RegisteredClient r, Throwable t2) {
                        RegisteredClient registeredClient;
                        if (t2 != null) {
                            LOG.errorf("%s client registration failed: %s, it can be retried later", (Object)oidcConfig.id().orElse(OidcClientRegistrationRecorder.DEFAULT_ID), (Object)t2.getMessage());
                            registeredClient = null;
                        } else {
                            registeredClient = r;
                            LOG.debugf("Registered client id: %s", (Object)r.metadata().getClientId());
                        }
                        return new OidcClientRegistrationImpl(client, connectionDelayInMillisecs, metadata.clientRegistrationUri, oidcConfig, registeredClient, oidcRequestFilters, oidcResponseFilters);
                    }
                });
            }
        });
    }

    private static String getEndpointUrl(OidcClientRegistrationConfig oidcConfig) {
        return oidcConfig.authServerUrl().isPresent() ? (String)oidcConfig.authServerUrl().get() : (String)oidcConfig.registrationPath().get();
    }

    private static Uni<OidcConfigurationMetadata> discoverRegistrationUri(WebClient client, Map<OidcEndpoint.Type, List<OidcRequestFilter>> oidcRequestFilters, Map<OidcEndpoint.Type, List<OidcResponseFilter>> oidcResponseFilters, String authServerUrl, io.vertx.mutiny.core.Vertx vertx, OidcClientRegistrationConfig oidcConfig) {
        long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis((OidcCommonConfig)oidcConfig);
        return OidcCommonUtils.discoverMetadata((WebClient)client, oidcRequestFilters, (OidcRequestContextProperties)new OidcRequestContextProperties(), oidcResponseFilters, (String)authServerUrl, (long)connectionDelayInMillisecs, (io.vertx.mutiny.core.Vertx)vertx, (boolean)oidcConfig.useBlockingDnsLookup()).onItem().transform(json -> new OidcConfigurationMetadata(json.getString("registration_endpoint")));
    }

    protected static OidcClientRegistrationException toOidcClientRegException(String authServerUrlString, Throwable cause) {
        return new OidcClientRegistrationException(OidcCommonUtils.formatConnectionErrorMessage((String)authServerUrlString), cause);
    }

    private static class DisabledOidcClientRegistration
    implements OidcClientRegistration {
        String message;

        DisabledOidcClientRegistration(String message) {
            this.message = message;
        }

        @Override
        public Uni<RegisteredClient> registeredClient() {
            throw new DisabledOidcClientRegistrationException(this.message);
        }

        @Override
        public Uni<RegisteredClient> registerClient(ClientMetadata reg) {
            throw new DisabledOidcClientRegistrationException(this.message);
        }

        @Override
        public Multi<RegisteredClient> registerClients(List<ClientMetadata> regs) {
            throw new DisabledOidcClientRegistrationException(this.message);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public Uni<RegisteredClient> readClient(String registrationUri, String registrationToken) {
            throw new DisabledOidcClientRegistrationException(this.message);
        }
    }

    private record OidcConfigurationMetadata(String clientRegistrationUri) {
    }
}

