/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.registration.runtime;

import io.quarkus.jsonp.JsonProviderHolder;
import io.quarkus.oidc.client.registration.ClientMetadata;
import io.quarkus.oidc.client.registration.OidcClientRegistration;
import io.quarkus.oidc.client.registration.OidcClientRegistrationConfig;
import io.quarkus.oidc.client.registration.RegisteredClient;
import io.quarkus.oidc.client.registration.runtime.OidcClientRegistrationException;
import io.quarkus.oidc.client.registration.runtime.RegisteredClientImpl;
import io.quarkus.oidc.common.OidcEndpoint;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.OidcRequestFilter;
import io.quarkus.oidc.common.OidcResponseFilter;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnItem;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import jakarta.json.JsonObjectBuilder;
import java.io.IOException;
import java.net.SocketException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class OidcClientRegistrationImpl
implements OidcClientRegistration {
    private static final Logger LOG = Logger.getLogger(OidcClientRegistrationImpl.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String AUTHORIZATION_HEADER = String.valueOf(HttpHeaders.AUTHORIZATION);
    private static final String DEFAULT_ID = "Default";
    private final WebClient client;
    private final long connectionDelayInMillisecs;
    private final String registrationUri;
    private final OidcClientRegistrationConfig oidcConfig;
    private final Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters;
    private final Map<OidcEndpoint.Type, List<OidcResponseFilter>> responseFilters;
    private final RegisteredClient registeredClient;
    private volatile boolean closed;

    public OidcClientRegistrationImpl(WebClient client, long connectionDelayInMillisecs, String registrationUri, OidcClientRegistrationConfig oidcConfig, RegisteredClient registeredClient, Map<OidcEndpoint.Type, List<OidcRequestFilter>> oidcRequestFilters, Map<OidcEndpoint.Type, List<OidcResponseFilter>> oidcResponseFilters) {
        this.client = client;
        this.connectionDelayInMillisecs = connectionDelayInMillisecs;
        this.registrationUri = registrationUri;
        this.oidcConfig = oidcConfig;
        this.requestFilters = oidcRequestFilters;
        this.responseFilters = oidcResponseFilters;
        this.registeredClient = registeredClient;
    }

    @Override
    public Uni<RegisteredClient> registeredClient() {
        if (this.registeredClient != null) {
            return Uni.createFrom().item((Object)this.registeredClient);
        }
        if (this.oidcConfig.registerEarly()) {
            return Uni.createFrom().nullItem();
        }
        ClientMetadata metadata = OidcClientRegistrationImpl.createMetadata(this.oidcConfig.metadata());
        if (metadata.getJsonObject().isEmpty()) {
            LOG.debugf("%s client registration is skipped because its metadata is not configured", (Object)this.oidcConfig.id().orElse(DEFAULT_ID));
            return Uni.createFrom().nullItem();
        }
        return OidcClientRegistrationImpl.registerClient(this.client, this.registrationUri, this.oidcConfig, this.requestFilters, this.responseFilters, metadata.getMetadataString()).onFailure(OidcCommonUtils.oidcEndpointNotAvailable()).retry().withBackOff(OidcCommonUtils.CONNECTION_BACKOFF_DURATION, OidcCommonUtils.CONNECTION_BACKOFF_DURATION).expireIn(this.connectionDelayInMillisecs);
    }

    @Override
    public Uni<RegisteredClient> registerClient(ClientMetadata metadata) {
        LOG.debugf("Register client metadata: %s", (Object)metadata.getMetadataString());
        this.checkClosed();
        OidcRequestContextProperties requestProps = this.getRequestProps();
        return OidcClientRegistrationImpl.postRequest(requestProps, this.client, this.registrationUri, this.oidcConfig, this.requestFilters, metadata.getMetadataString()).transform(resp -> OidcClientRegistrationImpl.newRegisteredClient((HttpResponse<Buffer>)resp, this.client, this.registrationUri, this.oidcConfig, this.requestFilters, this.responseFilters, requestProps));
    }

    @Override
    public Multi<RegisteredClient> registerClients(final List<ClientMetadata> metadataList) {
        LOG.debugf("Register clients", new Object[0]);
        this.checkClosed();
        final OidcRequestContextProperties requestProps = this.getRequestProps();
        return Multi.createFrom().emitter((Consumer)new Consumer<MultiEmitter<? super RegisteredClient>>(){

            @Override
            public void accept(final MultiEmitter<? super RegisteredClient> multiEmitter) {
                try {
                    final AtomicInteger emitted = new AtomicInteger();
                    for (ClientMetadata metadata : metadataList) {
                        OidcClientRegistrationImpl.postRequest(requestProps, OidcClientRegistrationImpl.this.client, OidcClientRegistrationImpl.this.registrationUri, OidcClientRegistrationImpl.this.oidcConfig, OidcClientRegistrationImpl.this.requestFilters, metadata.getMetadataString()).transform(resp -> OidcClientRegistrationImpl.newRegisteredClient((HttpResponse<Buffer>)resp, OidcClientRegistrationImpl.this.client, OidcClientRegistrationImpl.this.registrationUri, OidcClientRegistrationImpl.this.oidcConfig, OidcClientRegistrationImpl.this.requestFilters, OidcClientRegistrationImpl.this.responseFilters, requestProps)).subscribe().with((Consumer)new Consumer<RegisteredClient>(){

                            @Override
                            public void accept(RegisteredClient client) {
                                multiEmitter.emit((Object)client);
                                if (emitted.incrementAndGet() == metadataList.size()) {
                                    multiEmitter.complete();
                                }
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    multiEmitter.fail((Throwable)ex);
                }
            }
        });
    }

    private OidcRequestContextProperties getRequestProps() {
        return this.requestFilters.isEmpty() && this.responseFilters.isEmpty() ? null : new OidcRequestContextProperties();
    }

    static Uni<RegisteredClient> registerClient(WebClient client, String registrationUri, OidcClientRegistrationConfig oidcConfig, Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters, Map<OidcEndpoint.Type, List<OidcResponseFilter>> responseFilters, String clientRegJson) {
        OidcRequestContextProperties requestProps = requestFilters == null && responseFilters.isEmpty() ? null : new OidcRequestContextProperties();
        return OidcClientRegistrationImpl.postRequest(requestProps, client, registrationUri, oidcConfig, requestFilters, clientRegJson).transform(resp -> OidcClientRegistrationImpl.newRegisteredClient((HttpResponse<Buffer>)resp, client, registrationUri, oidcConfig, requestFilters, responseFilters, requestProps));
    }

    static UniOnItem<HttpResponse<Buffer>> postRequest(OidcRequestContextProperties requestProps, WebClient client, String registrationUri, OidcClientRegistrationConfig oidcConfig, Map<OidcEndpoint.Type, List<OidcRequestFilter>> filters, String clientRegJson) {
        HttpRequest request = client.postAbs(registrationUri);
        request.putHeader(HttpHeaders.CONTENT_TYPE.toString(), APPLICATION_JSON);
        request.putHeader(HttpHeaders.ACCEPT.toString(), APPLICATION_JSON);
        if (oidcConfig.initialToken().orElse(null) != null) {
            request.putHeader(AUTHORIZATION_HEADER, "Bearer " + oidcConfig.initialToken().get());
        }
        Buffer buffer = Buffer.buffer((String)clientRegJson);
        Uni response = OidcClientRegistrationImpl.filterHttpRequest(requestProps, (HttpRequest<Buffer>)request, filters, buffer).sendBuffer(OidcCommonUtils.getRequestBuffer((OidcRequestContextProperties)requestProps, (Buffer)buffer)).onFailure(SocketException.class).retry().atMost((long)oidcConfig.connectionRetryCount()).onFailure().transform(t -> {
            LOG.warn((Object)"OIDC Server is not available:", t.getCause() != null ? t.getCause() : t);
            return new OidcClientRegistrationException("OIDC Server is not available");
        });
        return response.onItem();
    }

    private static HttpRequest<Buffer> filterHttpRequest(OidcRequestContextProperties requestProps, HttpRequest<Buffer> request, Map<OidcEndpoint.Type, List<OidcRequestFilter>> filters, Buffer body) {
        if (!filters.isEmpty()) {
            OidcRequestFilter.OidcRequestContext context = new OidcRequestFilter.OidcRequestContext(request, body, requestProps);
            for (OidcRequestFilter filter : OidcCommonUtils.getMatchingOidcRequestFilters(filters, (OidcEndpoint.Type)OidcEndpoint.Type.CLIENT_REGISTRATION)) {
                filter.filter(context);
            }
        }
        return request;
    }

    private static RegisteredClient newRegisteredClient(HttpResponse<Buffer> resp, WebClient client, String registrationUri, OidcClientRegistrationConfig oidcConfig, Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters, Map<OidcEndpoint.Type, List<OidcResponseFilter>> responseFilters, OidcRequestContextProperties requestProps) {
        Buffer buffer = OidcCommonUtils.filterHttpResponse((OidcRequestContextProperties)requestProps, resp, responseFilters, (OidcEndpoint.Type)OidcEndpoint.Type.CLIENT_REGISTRATION);
        if (resp.statusCode() == 200 || resp.statusCode() == 201) {
            JsonObject json = buffer.toJsonObject();
            LOG.debugf("Client has been succesfully registered: %s", (Object)json.toString());
            String registrationClientUri = (String)json.remove("registration_client_uri");
            String registrationToken = (String)json.remove("registration_access_token");
            ClientMetadata metadata = new ClientMetadata(json.toString());
            return new RegisteredClientImpl(client, oidcConfig, requestFilters, responseFilters, metadata, registrationClientUri, registrationToken);
        }
        String errorMessage = buffer.toString();
        LOG.errorf("Client registeration has failed:  status: %d, error message: %s", (Object)resp.statusCode(), (Object)errorMessage);
        throw new OidcClientRegistrationException(errorMessage);
    }

    @Override
    public Uni<RegisteredClient> readClient(String registrationUri, String registrationToken) {
        RegisteredClientImpl newClient = new RegisteredClientImpl(this.client, this.oidcConfig, this.requestFilters, this.responseFilters, OidcClientRegistrationImpl.createMetadata(this.oidcConfig.metadata()), registrationUri, registrationToken);
        return newClient.read();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.client.close();
            }
            catch (Exception ex) {
                LOG.debug((Object)"Failed to close the client", (Throwable)ex);
            }
            this.closed = true;
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("OIDC Client Registration is closed");
        }
    }

    static ClientMetadata createMetadata(OidcClientRegistrationConfig.Metadata metadata) {
        JsonObjectBuilder json = JsonProviderHolder.jsonProvider().createObjectBuilder();
        if (metadata.clientName().isPresent()) {
            json.add("client_name", metadata.clientName().get());
        }
        if (metadata.redirectUri().isPresent()) {
            json.add("redirect_uris", JsonProviderHolder.jsonProvider().createArrayBuilder().add(metadata.redirectUri().get()));
        }
        if (metadata.postLogoutUri().isPresent()) {
            json.add("post_logout_redirect_uri", JsonProviderHolder.jsonProvider().createArrayBuilder().add(metadata.postLogoutUri().get()));
        }
        for (Map.Entry<String, String> entry : metadata.extraProps().entrySet()) {
            json.add(entry.getKey(), entry.getValue());
        }
        return new ClientMetadata(json.build());
    }

    static class ClientRegistrationHelper {
        RegisteredClient client;
        String registrationUri;

        ClientRegistrationHelper(RegisteredClient client, String registrationUri) {
            this.client = client;
            this.registrationUri = registrationUri;
        }
    }
}

