/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.registration;

import io.quarkus.oidc.client.registration.OidcClientRegistrationConfigBuilder;
import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import io.smallrye.config.WithDefault;
import java.util.Map;
import java.util.Optional;

public interface OidcClientRegistrationConfig
extends OidcCommonConfig {
    public Optional<String> id();

    @WithDefault(value="true")
    public boolean registrationEnabled();

    @WithDefault(value="true")
    public boolean registerEarly();

    public Optional<String> initialToken();

    public Metadata metadata();

    public static OidcClientRegistrationConfigBuilder builder() {
        return new OidcClientRegistrationConfigBuilder();
    }

    public static OidcClientRegistrationConfigBuilder builder(OidcClientRegistrationConfig config) {
        return new OidcClientRegistrationConfigBuilder(config);
    }

    public static OidcClientRegistrationConfigBuilder authServerUrl(String authServerUrl) {
        return (OidcClientRegistrationConfigBuilder)((Object)OidcClientRegistrationConfig.builder().authServerUrl(authServerUrl));
    }

    public static OidcClientRegistrationConfigBuilder registrationPath(String registrationPath) {
        return (OidcClientRegistrationConfigBuilder)((Object)OidcClientRegistrationConfig.builder().registrationPath(registrationPath));
    }

    public static interface Metadata {
        public Optional<String> clientName();

        public Optional<String> redirectUri();

        public Optional<String> postLogoutUri();

        public Map<String, String> extraProps();
    }
}

