/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.registration;

import io.quarkus.oidc.client.registration.OidcClientRegistrationConfigBuilder;
import io.quarkus.oidc.client.registration.runtime.OidcClientRegistrationsConfig;
import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.WithDefault;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public interface OidcClientRegistrationConfig
extends OidcCommonConfig {
    public Optional<String> id();

    @WithDefault(value="true")
    public boolean registrationEnabled();

    @WithDefault(value="true")
    public boolean registerEarly();

    public Optional<String> initialToken();

    public Metadata metadata();

    public static OidcClientRegistrationConfigBuilder builder() {
        OidcClientRegistrationsConfig clientRegistrationsConfig = (OidcClientRegistrationsConfig)new SmallRyeConfigBuilder().addDiscoveredConverters().withMapping(OidcClientRegistrationsConfig.class).build().getConfigMapping(OidcClientRegistrationsConfig.class);
        OidcClientRegistrationConfig clientRegistrationWithDefaultValues = OidcClientRegistrationsConfig.getDefaultClientRegistration(clientRegistrationsConfig);
        return new OidcClientRegistrationConfigBuilder(clientRegistrationWithDefaultValues);
    }

    public static OidcClientRegistrationConfigBuilder builder(OidcClientRegistrationConfig config) {
        Objects.requireNonNull(config);
        return new OidcClientRegistrationConfigBuilder(config);
    }

    public static OidcClientRegistrationConfigBuilder authServerUrl(String authServerUrl) {
        return (OidcClientRegistrationConfigBuilder)((Object)OidcClientRegistrationConfig.builder().authServerUrl(authServerUrl));
    }

    public static OidcClientRegistrationConfigBuilder registrationPath(String registrationPath) {
        return (OidcClientRegistrationConfigBuilder)((Object)OidcClientRegistrationConfig.builder().registrationPath(registrationPath));
    }

    public static interface Metadata {
        public Optional<String> clientName();

        public Optional<String> redirectUri();

        public Optional<String> postLogoutUri();

        public Map<String, String> extraProps();
    }
}

